#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Logical Function andzro (outcd1, outcd2)


**************************************************************
*                                                            *
*  Function outcd1_and_outcd2                                *
*                                                            *
*     This function is used to AND the two position codes    *
*     together, telling us if the two points occur in the    *
*     same plane or origin. If the two points have a sim-    *
*     ilar plane, then the line can't disect the window's    *
*     face.                                                  *
*                                                            *
*     The routine returns a boolean variable, stating if     *
*     the two points do lie in a common plane. If the        *
*     points do have a common plane, the routine returns     *
*     'false', else 'true' is returned, since the two        *
*     points could possibly disect the window's face.        *
*                                                            *
*     ex)                                                    *
*          0101  AND  0001 --> 0001    Cannot disect the     *
*                                      window's face.        *
*          0101  AND  1000 --> 0000    Possibly disect the   *
*                                      window's face.        *
*          0000  AND  1010 --> 0000    Definitely disects    *
*                                      the window's face.    *
*                                                            *
**************************************************************


        Integer outcd1, outcd2, temp1, temp2, mod

*       (* Set temporary code numbers. *)
        temp1 = outcd1
        temp2 = outcd2

*       (* Set andzro to true, neither point 1 or 2 share a
*          similar plane. *)
        andzro = .TRUE.

*       (* While neither number is 0 and while andzro is true
*          keep checking position bit. If in same plane set 
*          boolean. *)
  100   IF (((temp1 .NE. 0) .AND. (temp2 .NE. 0)) .AND. (andzro)) THEN
          IF ((mod(temp1,10) .EQ. 1 .AND. mod(temp2,10) .EQ. 1)) THEN
            andzro = .FALSE.
          ELSE
            temp1 = temp1/10
            temp2 = temp2/10
          ENDIF
          GOTO 100
        ENDIF

        RETURN
        END
