
/* Copyright (C) 1992  AHPCRC, Univeristy of Minnesota
 * Earlier versions Copyright 1992,  Minnesota Supercomputer Center Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program in a file named 'Copying'; if not, write to
 * the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139.
 */

/* Author:
 *	Ken Chin-Purcell (ken@ahpcrc.umn.edu)
 *	Army High Performance Computing Research Center (AHPCRC)
 *	Univeristy of Minnesota
 *
 * $Header: /usr/people/ken/gvl/bob/RCS/draw.h,v 2.2 92/10/27 16:50:25 ken Exp Locker: ken $
 *
 * $Log:	draw.h,v $
 * Revision 2.2  92/10/27  16:50:25  ken
 * Added basic point support
 * 
 * Revision 2.1  92/10/19  17:03:37  ken
 * *** empty log message ***
 * 
 * Revision 1.1  92/10/19  17:03:01  ken
 * Initial revision
 * 
 */

typedef enum _FinderEnum {
    FinderSync, FinderDiff, FinderRead, FinderInterp, FinderScan
} FinderEnum;

extern FinderEnum	finderMode;
extern unsigned		finderPlane;


/* Prototypes */

/* draw.c */
void	DrawVoxel (int ix, int direction, unsigned dim [3 ], float *pos [3 ], unsigned char *cdata, float cmap [256 ][4 ], unsigned char *faces, unsigned soft);
void	DrawStrideVoxel (int ix, int direction, unsigned dim [3 ], float *pos [3 ], unsigned char *cdata, float cmap [256 ][4 ], unsigned char *faces, unsigned stride);
void	DrawMaxVal (int ix, int direction, unsigned dim [3 ], float *pos [3 ], unsigned char *cdata, float cmap [256 ][4 ], unsigned char *faces);
void	DrawStrideMaxVal (int ix, int direction, unsigned dim [3 ], float *pos [3 ], unsigned char *cdata, float cmap [256 ][4 ], unsigned char *faces, unsigned stride);
void	DrawVoxFace (int ix, int direction, unsigned dim [3 ], float *pos [3 ], unsigned char *cdata, float cmap [256 ][4 ]);
void	DrawVoxFaces (unsigned dim [3 ][3 ], float *pos [3 ][3 ], unsigned char *cdata [3 ], float cmap [256 ][4 ]);
void	DrawBounds (float dim [3 ], unsigned asBox);
void	DrawAnnotatedBox (float dim [3 ], unsigned lo [3 ], unsigned hi [3 ]);
void	DrawColorBar (float ctab [256 ][4 ], float atab [256 ]);
void	DrawAxis (float *axlen);
void	DrawSetupFinder (void);
void	DrawFinderScene (int voxdim [3 ], int stride, int voxoff [3 ], unsigned filedim [3 ], float dimScale [3 ], Trackball *tball);
void	DrawPoint (float *point, unsigned npoint, int psize, float *pcolor);
