.TH BOB  1 "1992" "AHPCRC"
.SH NAME
bob \- Brick of Bytes
.SH SYNOPSIS
\fBbob\fR [ \-option ] [ -s XxYxZ filename ... ]
.SH EXAMPLES
bob -s 150x150x150 molecule.vol
.br
bob -cmap rainbow -scale 1x1x2 -s 128x128x64 file1 file2
.SH DESCRIPTION
Bob is a tool for browsing three dimensional data sets.  The program
was designed to quickly render portions of potentially large time
dependent volumes.  Bob can also create a series of images that
can be later compiled into a movie.
.PP
To learn how to use Bob, consult the manual "All About Bob".  This
document only covers the command line options and resource values.
An on line version of "All About Bob", without figures, is available
as 'man allbob'.
.SH OPTIONS
Bob recognizes the standard X toolkit options, such as
-geometry, -title, -bg, -fg, etc.
Bob also has two sets of options of its own.
The first set define global settings, and should be specified once at most.
The second set define the file format, and can be repeated to 
change the format for multiple files.
.PP
Global options:
.IP "-cmap | -c  file"
Specify the initial color map.  If no alpha map is specified, the
alpha will be computed as the brightness of the color map.  The colormap
can be in one of two formats: indexed ascii or interleaved binary.
The indexed ascii format consists of ascii integer quadruples, 
as in "index red green blue ...".  
The integers should range from zero to 255.
The interleaved binary format contains 768 bytes, with 256 rgb triples,
as in "rgbrgbrgb...".  Icol can interchange between these formats and two
others.
.IP "-amap | -a  file"
Specify the initial alpha map.  The alpha file format is the same
color map file format.  If the red, green and blue values are different,
the alpha value is computed as the brightness 
(1/8 blue + 5/8 green + 2/8 red).  In other words, alpha maps are 
represented using black and white color maps.
.IP "-scale | -x  XxYxZ"
Space the data set using a ratio of X\ :\ Y\ :\ Z.  For example,
if a data set needs to be expanded in the Z direction by a factor of
3, use "-x 1x1x3".  Note that high scale factors introduce more
rendering artifacts.  For the best quality images, create an interpolated
data set and avoid using a scale factor.
.IP "-default | -d  file"
Load default settings from file.  
Bob will also check for the file "Bobfile" in the current directory
for default settings.  
See "Defaults File" below.
.IP "-single"
Force using only one rendering buffer (i.e. no double buffering).
Some SGI machines with limited bit planes will allow double buffering
at the expense of image quality (e.g. Elan and Indigo).  
To obtain the best quality images on these machines, use this option.
.IP "-savebgr"
Save animation image files as interlaced bgr bytes, as in bgrbgrbgr....
This is the default because it is the format for xraz.
.IP "-savergb"
Save animation image files as interlaced rgb bytes, as in rgbrgbrgb....
This is the format
that is easiest to convert.  For example, to convert a 512 by 512 image
file produced by Bob, called ras.000, to SGI image format, use:
.br
.sp
frombin ras.000 sgi.000 512 512 3
.IP "-fastrate #"
Set the interactive rendering rate to # frames per second (an integer).
When the volume in Bob is manipulated by the mouse, the resolution is 
cut to achieve a certain number of frames per second rendering rate
on the given hardware.
The default rate is 6 frames per second.  
.IP "-fov"
Field of view, an integer, in tenths of a degree.  The default field
of view is 34 degrees.  Higher values accentuate the sense of
perspective.
.IP "-eye"
Set the eye separation for stereo viewing.  The default value is 0.07.
Higher eye separation increases the sense of depth, but causes more
eye strain.
.IP "-distance"
Set the distance of the volume from the eye.  The default value of
3.0 places the volume to just fill the window for the default
field of view.
.IP "-help | -h"
Print a short command summary.
.IP "-debug #"
Set the debug level.  Currently, "1" will time the rendering loop
for polygon speed.
.PP
The following options control the file format, and 
can be interspersed with file names.  A file size \fBmust\fR be specified
before the first file name.  The files and options are
read in order, with option settings applying to all subsequent files.
File offsets and block sizes can be specified using the letters 'k' and 'm',
with k standing for 1024 and m for 1024*1024.  Thus, a four kilobyte
block size can be specified as "4k" and a one hundred megabyte offset
as "100m" or "100kk".
.IP "-size | -s  XxYxZ"
Specify the dimensions of the file.  For example, a 128 by 128 by 64
brick of data would be specified as "\-s\ 128x128x64".
.IP "-number | -n  #"
Set the number of data bricks per file.  Default is 1.
.IP "-offset | -o  #"
Set the offset, in bytes, to where the brick begins in the file.  
Default is zero.
.IP "-block | -b  #"
Set the block size of the device.  This is only useful for accessing raw
disk partitions, which is done at the AHPCRC to gain speed.  
We keep several large striped disk partitions open
(no file system) for disk based visualization.
.SH RESOURCES
Bob's global options can be specified using X resources.  In all
cases, the resource class is the same as the resource name capitalized.
.IP "cmapName"
The color map file name.
.IP "amapName"
The alpha map file name.
.IP "defaultName"
The defaults file name.
.IP "scaleText"
The scale ratio, specified as in the -scale option.
.IP "saveBGR"
A boolean flag to control the file format for animation image files.
.IP "fastRate"
The integer number of frames per second to render on the given hardware
while the volume is being manipulated.
.IP "singleBuffer"
A boolean flag to force using single buffer rendering at all times,
resulting in better image quality on some machines.
.IP "bugAddress"
The mail address to send bug reports to.
.IP "fieldOfView"
The field of view, in tenths of a degree.
.IP "eyeSeparation"
The eye separation.
.IP "eyeDistance"
The distance of the volume from the eye.
.SH DEFAULTS FILE
The defaults file contains one line entries, in the form of
.br
.sp
target = value
.PP
Lines may be commented out using '#', like shell scripts.  
The targets are:
.IP "color = filename"
Set the file name for the initial color table.
.IP "alpha = filename"
Set the file name for the initial alpha table.
.IP "scale = xscale yscale zscale"
Set the scaling factor for the volume in each direction.
The values may be in floating point, and should be separated by white space.
.IP "size = xdim ydim zdim"
Set the data size in the file, with the dimensions separated by white space.
For example,
.br
.sp
size = 128 128 64
.IP "offset = numBytes"
Set the byte offset into the file for where the first brick begins.
The number may contain 'k' or 'm', as in '120m' for 120 megabytes.
.IP "block = numBytes"
Set the blocksize of the file device.  
This is only useful for accessing data on a raw file partition, 
which often improves I/O for large files.
The number may contain 'k' or 'm', as in '8k' for eight kilobytes.
.IP "number = numBrick"
Set the number of data bricks in the file.
.IP "dim = dimension string"
Add an entry to the dimension list, in the form of
.br
.sp
XxYxZ 'by' stride 'at' X,Y,Z
.IP
For example, a 32 by 32 by 32 volume, taken at a stride of 2, 
centered at x=48, y=100, z=48, would read
.br
.sp
dimension = 32x32x32 by 3  at 48,101,48
.IP "file = filename"
Add a file to the file list.
.PP
If there is no target, then the string is assumed to be a file name
and is added to the file list.  Thus, long sequences can be built
by specifying the correct parameters and appending a listing of
file names.
.SH CAVEATS
The data volume is transposed for all three rendering directions.
Thus, a rough estimate of the memory is used is one megabyte plus
three times the size of the rendered volume.  
.PP
Machines without z-buffers are limited to alpha rendering.
Machines without blending hardware, such as the Personal Iris,
are limited to maximum value rendering.  Machines with no blending
or z-buffer hardware are, in Bob's opinion, no better than a Sun.
.SH BUGS
Stereo mode doesn't work when maximum value rendering.
.PP
For large volumes, it is often possible to exceed the swap space available
by simply moving the size scale to its maximum value.
.SH AUTHOR
Ken Chin-Purcell
.br
Mail to gvlware@ahpcrc.umn.edu.
