/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// Code to create a screen snapshot and save it to a disk file
//


#include <math.h>

#include <il/ilGenericImgFile.h>
#include <il/ilMemoryImg.h>

#include "genSetup.H"
#include "hciUpdateScreen.h"
#include "hciMainWindow.H"
#include "misSnapScreen.H"


void SnapScreen(VRState *state)
{
#ifdef VR_IRISGL
  // No code for IrisGL yet...
#endif

#ifdef VR_OPENGL
  int w, h;
  int width, height, aspect;
  int winWidth, winHeight;
  char msg[128];

  width = state->world->snapWidth;
  height = state->world->snapHeight;
  aspect = width / height;

  winWidth = state->view->width-1;
  winHeight = state->view->height-1;

  // Compute the view width and height
  float viewWidth, viewHeight;
  if (state->mode->perspMode) {
    float tangent = tan(0.1 * state->mode->perspFov / 2.0 * M_PI / 180.0);
    viewWidth = 2.0 * state->mode->perspNear * aspect * tangent;
    viewHeight = 2.0 * state->mode->perspNear * tangent;
  } else {
    viewWidth = 2.0 * aspect;
    viewHeight = 2.0;
  }

  // Create the image
  ilFileImg *img;
  img = ilCreateImgFile(state->world->snapFile, ilSize(width, height, 1, 3),
			ilUChar, ilInterleaved, ilTIFF_IMG);
  if (img == NULL) {
    fprintf(stderr, "Unable to open image file \"%s\"!\n",
	    state->world->snapFile);
    return;
  }
  img->setCoordSpace(ilLowerLeftOrigin);

  // Get the pixels
  unsigned char *tilePixels;
  tilePixels = new unsigned char[winWidth*winHeight*4];

  // Avoid getting other keypresses
  state->world->initing = TRUE;
  state->view->snapping = TRUE;

  NotifyInfo("Generating disk file snapshot");

  for (h=0; h<height; h+=winHeight) {
    for (w=0; w<width; w+=winWidth) {

      sprintf(msg, "Drawing chunk [%04d,%04d] to [%04d,%04d]",
	      w+1, h+1, w+winWidth+1, h+winHeight+1);
      NotifyInfo(msg);

      // Compute the view corners for this chunk
      state->view->snapRgt = viewWidth * (w+winWidth) / width - viewWidth / 2.0;
      state->view->snapLft = viewWidth * w / width - viewWidth / 2.0;
      state->view->snapTop = viewHeight * (h+winHeight) / height - viewHeight / 2.0;
      state->view->snapBot = viewHeight * h / height - viewHeight / 2.0;

      // Draw the image
      UpdateView(state);

      // Read the pixels
      glPixelStorei(GL_PACK_ALIGNMENT, 1);
      glReadPixels(0, 0, winWidth, winHeight, GL_RGB, GL_UNSIGNED_BYTE, tilePixels);
      glXSwapBuffers(state->view->disp, state->view->wind);

      // Compute this chunk's tile size
      int tileWidth, tileHeight;
      if ((w+winWidth) > width) tileWidth = width - w;
      else                      tileWidth = winWidth;
      if ((h+winHeight) > height) tileHeight = height - h;
      else                        tileHeight = winHeight;

      img->setSubTile(w, h, tileWidth, tileHeight, tilePixels,
		      w, h, winWidth, winHeight);

    }
  }

  sprintf(msg, "Writing snapshot to disk file \"%s\"...", state->world->snapFile);
  NotifyInfo(msg);

  // Redraw the correct view on the screen
  state->view->snapping = FALSE;
  UpdateView(state);

  delete img;

  // Close the image and free the pixel data
  delete [] tilePixels;

  sprintf(msg, "Writing snapshot to disk file \"%s\"... Done!", state->world->snapFile);
  NotifyInfo(msg);

  // We'll take keypresses again now
  state->world->initing = FALSE;

#if CREATE_SNAPSHOT_WITH_OFFSCREEN_PIXMAP
    Pixmap xPixmap;
    GLXPixmap gPixmap;
    GLXContext gContext;
    int width, height;

    width = state->world->snapWidth;
    height = state->world->snapHeight;

    // Create some pixmaps and a graphics context
    xPixmap = XCreatePixmap(theApplication->display(), window, 
			    width, height, 24);
    gPixmap = glXCreateGLXPixmap(theApplication->display(),
				 visualInfo, xPixmap);
    gContext = glXCreateContext(theApplication->display(), visualInfo,
				NULL, False);
    glXMakeCurrent(theApplication->display(), gPixmap, gContext);

    // Change the with width/height so that UpdateView draws things
    // the right size
    int sWidth = state->view->width;
    int sHeight = state->view->height;
    state->view->width = width;
    state->view->height = height;

    // Render the image
    UpdateView(state);

    // Restore the view width/height
    state->view->width = sWidth;
    state->view->height = sHeight;

    // Get the pixels
    unsigned char *pixels;
    pixels = new unsigned char[width*height*3];
    glReadPixels(0, 0, width, height, GL_RGB, GL_UNSIGNED_BYTE, pixels);

    // Free the pixmaps
    glXDestroyGLXPixmap(theApplication->display(), gPixmap);
    XFreePixmap(theApplication->display(), xPixmap);

    // Write the image to disk
    ilFileImg *img;
    img = ilCreateImgFile(state->world->snapFile, ilSize(width, height, 1, 3),
			  ilUChar, ilInterleaved, ilTIFF_IMG);
    if (img == NULL)
      fprintf(stderr, "Unable to open image file \"%s\"!\n",
	      state->world->snapFile);

    img->setCoordSpace(ilLowerLeftOrigin);
    img->setTile(0, 0, width, height, pixels);

    // Close the image and free the pixel data
    delete img;
    delete [] pixels;
#endif
#endif
}
