/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

/*
 * The main state data structure
 */


#ifndef _GEN_VOLREN_H_
#define _GEN_VOLREN_H_


#include "cppArgs.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>

#ifdef VR_IRISGL
#include <gl/gl.h>
#endif

#ifdef VR_OPENGL
#include <GL/glu.h>
#include <GL/glx.h>
#endif

#include "misMath.h"
#include "misCoord.h"
#include "misQuaternion.h"
#include "misMatrix.h"
#include "misPolyObject.h"
#include "misPlane.h"
#include "misBrick.h"


#ifdef __cplusplus
extern "C" {
#endif


#ifdef DEBUG
#define wait(msg)    if (state->view->debug == 1) \
                       { char buf[10]; fprintf(stderr, msg); fgets(buf, 10, stdin); }
#else
#define wait(msg)    if (0) {}
#endif


#ifdef VR_OPENGL
#ifdef  TRUE
#undef  TRUE
#endif
#define TRUE  GL_TRUE
#ifdef  FALSE
#undef  FALSE
#endif
#define FALSE GL_FALSE
#endif


#define STEREO_SEP     0.10

#define SLICE_FACTOR   3.0

#define NONINTERACTIVE 0
#define INTERACTIVE    1

#define BRICK8BITS     0
#define BRICK4BITS     1

#define NORMAL_IS_X    0
#define NORMAL_IS_Y    1
#define NORMAL_IS_Z    2

#define XY_SURFACE     0
#define Z_SURFACE      1

#define MAX_STATES     100
#define MAX_MAPS        25
#define MAX_FUNCS       20
#define MAX_MONITORS    10
#define MAX_PLANES       6
#define MAX_POINTS     512
#define MAX_VOLS        10		/* The maximum number of loaded volumes */
#define MAX_ELEVS        5		/* The maximum number of loaded elevations */
#define MAX_SURFS       10		/* The maximum number of defined surfaces */
#define MAX_RMODES       3

typedef short RenderType;
static char *renderModeName[] = {
#define MERGE_RENDER 0
  "Merge",
#define MATTE_RENDER 1
  "Matte",
#define SHADE_RENDER 2
  "Shade"
};

#define LEFT  0				/* Left/right eye indices */
#define RIGHT 1

#define COLORMAP  0
#define ALPHAMAP  1
#define TABLEMAP  2

#define BPF_4x1x1 0
#define BPF_1x4x1 1
#define BPF_1x1x4 2
#define BPF_2x2x1 3
#define BPF_2x1x2 4
#define BPF_1x2x2 5

#define OBJ_VOLUME    0
#define OBJ_ELEVATION 1

#define OPAQUE_WHITE        0xffffffff
#define OPAQUE_BLACK        0xff000000
#define OPAQUE_RED          0xff1203d4
#define OPAQUE_ORANGE       0xff0933d4
#define OPAQUE_YELLOW       0xff00bad4
#define OPAQUE_GREEN        0xff00b700
#define OPAQUE_BLUE         0xffb71110
#define OPAQUE_PURPLE       0xffb7009d
#define OPAQUE_GREY         0xff909090
#define OPAQUE_DARK_RED     0xff00009c
#define OPAQUE_DARK_ORANGE  0xff17399c
#define OPAQUE_DARK_YELLOW  0xff327b9c
#define OPAQUE_DARK_GREEN   0xff20781d
#define OPAQUE_DARK_BLUE    0xff680a05
#define OPAQUE_DARK_PURPLE  0xff5c034f
#define OPAQUE_DARK_GREY    0xff606060


#ifdef VR_IRISGL
extern float TriangleFilter[];
extern float BoxFilter[];
#endif

#ifdef VR_OPENGL
extern GLfloat TriangleFilter[];
extern GLfloat BoxFilter[];
#endif


#ifdef __cplusplus
class MainWindow;
#endif


typedef struct
{
  char               *title;			/* Name of table in menu */

  char               *slider[4];		/* Names of sliders */
  int                 sensitive[4];		/* Which sliders are sensitive? */

  int                 useMap;			/* Does this transfer func use color/alphamaps? */

  void               (*func)(float*, float*);

  float               parm[4];			/* User editable parameters */
  float               pmin[4], pmax[4];		/* Parameter min/max values */

} TransferFunc;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  /* General parameters */
  int             initing;		/* Flag to mark that we are still */
					/*   in initialization */
  Display        *disp;			/* The default display value */
  int             scrn;			/* The default screen value */

  float           microfps;		/* The current frame's fps rate */
  float           macrofps;		/* The recent general fps rate */
  float           maxfps;		/* The maximum fps rate */
  struct timeval  lastUpdate;		/* Timer to record last update of the macrofps */
  struct timeval  lastFrame;		/* Timer to record the last frame end time */

  char            msg[128];		/* The current status message */
  char            allowRenderMode[MAX_RMODES]; /* Allow each rendering mode? */
  int             timeVariantVolumes;	/* Are any of the volumes time variant? */

  /* Interface options */
  char            magicExtensions;	/* Enable the magic extensions */
  char           *mapName[MAX_MAPS];	/* Name of color/alpha/table map */
  int             mapType[MAX_MAPS];	/* Map type: color, alpha, or table */
  int             nMaps;		/* Number of maps */
  int             nCMaps, nAMaps;	/* Number of color and alpha maps */
  char           *monitorName[MAX_MONITORS];
  int             nMonitors;		/* Number of monitors */
  long            textureMem;		/* Amount of texture memory in this system */
  long            usableTexMem;		/* Amount of usable texture memory in this system */
  char           *polygonFile;		/* The polygon data file name */
  int             slices;		/* The default slices value */
  int             sliceMin, sliceMax;	/* The minimum and maximum slice count */
  int             modCmap, modAmap;	/* Start with [ac]map modulation on? */
  int             nPlanes;		/* The default nPlanes value */
  char            allowStereoMode;	/* Allow stereo mode? */
  int             stereoMode;		/* Flag for stereo enable/disable */
  int             width;		/* The default width value */
  int             height;		/* The default height value */
  long            backColor;	        /* The background color */
  long            frameColor;		/* The frame color */
  long            curFrameColor;	/* The current frame color */
  long            planeColor;		/* The slice frame color */
  long            curPlaneColor;	/* The current slice frame color */
  long            pointColor;		/* The point color */
  long            curPointColor;	/* The current point color */
  long            xVectorColor;		/* The X axis vector color */
  long            yVectorColor;		/* The Y axis vector color */
  long            zVectorColor;		/* The Z axis vector color */
  long            upVectorColor;	/* The up vector color */
  long            northVectorColor;	/* The north vector color */
  long            frontPolyColor;	/* The front polygon color */
  long            backPolyColor;	/* The back polygon color */
  long            frontElevColor;	/* The front elevation color */
  long            backElevColor;	/* The back elevation color */
  long            xySurfColor;		/* The XY surface color */
  long            zSurfColor;		/* The Z surface color */
  long            enumSurfColor[MAX_SURFS]; /* The nth surface color */
  char           *backColorString;
  char           *frameColorString;
  char           *curFrameColorString;
  char           *planeColorString;
  char           *curPlaneColorString;
  char           *pointColorString;
  char           *curPointColorString;
  char           *xVectorColorString;
  char           *yVectorColorString;
  char           *zVectorColorString;
  char           *upVectorColorString;
  char           *northVectorColorString;
  char           *frontPolyColorString;
  char           *backPolyColorString;
  char           *frontElevColorString;
  char           *backElevColorString;
  char           *xySurfColorString;
  char           *zSurfColorString;
  char           *enumSurfColorString[MAX_SURFS];
  int             verbose;		/* The default verbose value */
  int             debug;		/* The default debug value */

  /* Volume options */
  int             slabs;		/* The default number of slabs */
  int             downSample;		/* The default downSample value */
  float          *resampleFilter;	/* The filter to use during resampling */
  int             define4BitBricks;	/* The default brick definition sizes */
  int             doTextures;		/* Use textures? */
  int             doTexturedSurfs;	/* Allow textured surfaces? */
  int             surfaceNormal;	/* The default surfaceNormal value */
  unsigned char   drawAxes;		/* Draw the XYZ axes or up and north? */
  float           northAngle;		/* The default northAngle value */
  int             byteCompiling;	/* Is the program compiling data? */
  int             readCompiled;		/* Read compiled data? */
  int             allowDataReread;	/* Enable data rereading signal handler */
  char           *outname;

  /* Per volume options/information */
  int             nVols;                /* Number of input volumes */
  int             multiResMode;		/* Run in multi-resolution mode? */
  int             handedness[MAX_VOLS]; /* Volume handedness */
  float           xScl[MAX_VOLS],
                  yScl[MAX_VOLS],
                  zScl[MAX_VOLS];	/* The volume scale */
  float           xStride[MAX_VOLS],
                  yStride[MAX_VOLS],
                  zStride[MAX_VOLS];	/* The volume strides */
  int             teRes[MAX_VOLS];	/* The entire volume resolution in time */
  long            timeInterval[MAX_VOLS]; /* Time interval before change for a volume */
  char           *extension[MAX_VOLS];  /* Input data file name extension */
  int             sOff[MAX_VOLS];	/* The volume slice offset */
  int             xOff[MAX_VOLS];	/* The volume X offset */
  int             yOff[MAX_VOLS];	/* The volume Y offset */
  int             xbRes[MAX_VOLS],
                  ybRes[MAX_VOLS],
                  zbRes[MAX_VOLS];	/* The brick volume resolution */
  int             brickResGiven[MAX_VOLS];/* Brick resolution given by the user? */
  int             xsRes[MAX_VOLS],
                  ysRes[MAX_VOLS],
                  zsRes[MAX_VOLS];	/* The subvolume resolution */
  int             brickPacking[MAX_VOLS]; /* The brick packing format */
  int             xeRes[MAX_VOLS],
                  yeRes[MAX_VOLS],
                  zeRes[MAX_VOLS];	/* The entire volume resolution */
  float           xTrn[MAX_VOLS],
                  yTrn[MAX_VOLS],
                  zTrn[MAX_VOLS];       /* Volume translation */
  char           *basename[MAX_VOLS];	/* Input data file names */

  /* Per elevation options/information */
  int             nElevs;		/* Number of input elevations */
  float           elevXScl[MAX_ELEVS],
                  elevYScl[MAX_ELEVS],
                  elevZScl[MAX_ELEVS];	/* The elevation scale */
  int             elevLight[MAX_ELEVS];	/* Light this elevation data? */
  float           elevRot[MAX_ELEVS];	/* The elevation rotation angle */
  float           elevXTrn[MAX_VOLS],
                  elevYTrn[MAX_VOLS],
                  elevZTrn[MAX_VOLS];	/* The elevation translation */
  char           *elevColorImg[MAX_ELEVS];
  char           *elevElevImg[MAX_ELEVS];

  /* Snapshot options */
  int             snapWidth;		/* Width of the snapped image */
  int             snapHeight;		/* Height of the snapped image */
  char           *snapFile;		/* File name for the snapped image */

} VRWorld;
  

typedef struct 
{
  int             xWin[3], yWin[3];	/* The most recent pointer motion deltas */
  int             xLast, yLast;		/* The last (x,y) position */
} VRMotion;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  Display        *disp;			/* The window's display */
  int             scrn;			/* The window's screen */
  Window          wind;			/* The window's Xwindow ID */
#ifdef VR_OPENGL
  GLXContext      context;		/* The openGL context */  
#endif
  
  Font           *font;			/* The fonts */
  int            *fontBase, numFonts;	/* The font list offsets and number */
  char          **fontName;		/* The font names */
  int             noFonts;		/* Are there any fonts defined? */

#ifdef VR_OPENGL
  GLint           tlutBase;		/* Texture lookup table offsets */
#endif

  int             width;		/* User defined width and height of */
  int             height;		/*   of the rendering window */
  float           aspect;		/* The aspect of width to height */
  int             auxWidth;		/* The auxilary buffer width and height */
  int             auxHeight;

  int             snapping;		/* Are we presently taking a snapshot? */
  GLdouble        snapRgt;
  GLdouble        snapLft;
  GLdouble        snapTop;
  GLdouble        snapBot;

  int             verbose;		/* Information stdout flag */
  int             debug;		/* Debug info stdout flag */

  int             autoSpin;		/* Flag indicating if the volume is spinning */

  int             slices;		/* The number of slices in each brick */
  float           delta;		/* The current delta Z */
  float           deltas[2];		/* delta Z steps for interactive and */

  float           userScale;		/* Interactive user defined scale */

  float           zTrans;		/* Final GL viewing fustrum translation */

  matrix          RotMat;		/* Global rotation matrix */
  matrix          InvRotMat;		/*  and its inverse */

  matrix          PhanRotMat;           /* Phantom eye rotation matrix */
  matrix          InvPhanRotMat;        /*  and its inverse */

  matrix          RTCMat;		/* Rotated-To-Camera matrix */
  matrix          WTCMat;		/* World-To-Camera matrix */
  matrix          CTWMat;		/*  and its inverse */
  matrix          CTSMat;		/* Camera-To-Screen matrix */
  matrix          STCMat;		/*  and its inverse */
  matrix          WTSMat;		/* World-To-Screen matrix */

  int             enabledVolCount;      /* The number of currently enabled volumes */

  int             curPlane;	        /* The currently active plane */
  int             curSurf;		/* The currently active surface */
  int             curVol;		/* The currently selected volume */

  struct timeval  t3, t4;		/* Timers to compute if autospin should occur */

  VRMotion        motion;
  VRMotion        phantomMotion;

  int             boundLights;		/* Have the lights been bound for this view? */
  int             boundFonts;		/* Have fonts been defined for this view? */

} VRView;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  int             interactive;		/* Interactive mode ON/OFF */

  short           renderMode;		/* Index of the current render mode */

  int             volumeMode;		/* Flag used to turn on and off volume rendering */
  int             elevMode;		/* Flag used to turn on and off elevations */
  int             pointsMode;	        /* Flag used to signify if points mode is on */
  int             surfaceMode;	        /* Flag used to signify if surface mode is on */
  int             sliceMode;		/* Flag used to turn on and off slice planes */
  int		  sliceModeSave;	/* Old slice mode value */
  int             textMode;		/* Flag used to turn on and off text drawing */

  int             sliderMode;		/* Which slider button is depressed? */

  int             iaSurfMode;		/* Interactively update surface during point edits? */
  int             iaSliderMode;		/* Interactively update trans func during slider edits? */

  int             mipMode;		/* Flag for maximum intensity projection */
  int             vectorMode;		/* Flag for display of up/north vectors */
  int             followMode;		/* Flag for following slice planes */
  int             followModeSave;	/* Old follow mode value */
  int             frontbufMode;	        /* Flag indicating to draw in the front buffer */
  int             frameMode;		/* Flag for frame enable/disable */
  int             stereoEye;		/* Which eye is being drawn? */
  float           stereoRot;		/* Stereo rotation amount */
  float           stereoSep;		/* Stereo separation */
  int             perspMode;		/* Flag indicating the use of perspective */
  float           perspFov;		/* Perspective field of view */
  float           perspNear;		/* Perspective near clip plane distance */
  float           perspFar;		/* Perspective far clip plane distance */
  float           perspScale;		/* Perspective normalization scale */

  int             pixelRes;		/* Flag indicating pixel resolution */
  int             pixelResSave;		/* Old pixel resolution */
  int             brickRes;	        /* Flag indicating brick resolution */


  int             loopMode;		/* Flag to indicate if cine loop is on or off */
  int             clipGeomMode;		/* Flag to indicate if geometry should be clipped */

} VRMode;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  int             nObjects;
  PolyObject     *object;

} VRPolygonData;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  float          *cmap[MAX_MAPS];	/* User defined colormaps */
  int             nColormaps;		/* Number of colormaps */
  float          *amap[MAX_MAPS];	/* User defined alphamaps */
  int             nAlphamaps;		/* Number of alphamaps */

  char           *colormapName[MAX_MAPS]; /* Colormap names */
  char           *alphamapName[MAX_MAPS]; /* Alphamap names */

  TransferFunc    cafunc;		/* Controllable color/alpha parameters */
  TransferFunc    func[MAX_FUNCS];	/* Controllable transfer functions */
  int             nFuncs;		/* Number of transfer functions */

  int             opaquify;		/* Should the table be made completely opaque? */
  int             tableRedef;		/* Reload table flag */

} VRTableData;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  Plane           plane[MAX_PLANES];	/* The slicing planes */
  int             nPlanes;
  unsigned char   planeMoving;		/* Is the clip plane being moved now? */

} VRPlaneData;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  coord           point[MAX_POINTS];	/* The selected geometry points */
  int             nPoints;	        /* The current number of points */
  int             maxPoints;	        /* The maximum number of points */
  int             curPoint;		/* The current point */
  int             pointMoving;		/* Is the point currently being moved/created? */

} VRPointData;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  int             haveSurf;		/* Has a surface ever been generated? */

  coord          *polys;		/* The array of points that make up the surface */
  coord          *normals;		/* The array of normals to surface */
  int             polyWidth, polyHeight; /* The width and height of the surface array */

  int             surfaceType;		/* The type of surface (XY or Z) */
  int             drawTextured;		/* Draw this surface textured? */
  int             drawLighted;		/* Draw this surface lighted? */
  int             drawMeshed;
  coord           normal;		/* The normal to this surface */
  coord           up;			/* The up vector for this surface */

  int             active;		/* User set flag to turn rendering on and off */

  int             surfaceMoving;

} VRSurfaceData;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  int             xRes, yRes, zRes;	/* Volume resolution */
  float           xScl, yScl, zScl;	/* Voxel spacing */

  int             tRes;			/* Volume resolution in time */
  int             curTime;		/* Current volume time */
  XtIntervalId    timerId;		/* Id of the most recent timer */
  long            timeInterval;		/* Time between volume switches (in ms) */

  int             drawColor;		/* Render in color? */
  int             drawInterp;		/* Use linear interpolation? */

  float           xTrn, yTrn, zTrn;     /* Volume translation */
  float           uxScl, uyScl, uzScl;  /* Volume scaling */

  matrix          RotMat;		/* Volume rotation matrix */
  matrix          InvRotMat;		/*  and its inverse */

  matrix          VTWMat;		/* Volume-To-World matrix */
  matrix          WTVMat;		/*  and its inverse */
  matrix          VTRMat;		/* Volume-To-Rotated matrix */
  matrix          RTVMat;		/*  [ see hciHandlers.c:StorePerVolumeMatrix() ] */

  unsigned char   volumeMoving;		/* Is the volume moving now? */

  Brick        ***brick[2];		/* The (8/4)-bit volume bricks */
  Brick         **sbrick[2];            /* The sorted bricks */
  int             nxBricks, nyBricks, nzBricks;
  int             nBricks;		/* Total number of bricks */

  Brick           volBrick;		/* A brick the size of this entire volume */

  int             subvolume;		/* Are we viewing a subvolume? */
  int             xOff, yOff, zOff;     /* Offset of this subvolume */

  int             curFunc;		/* Transfer function for this volume */
  int             curCmap;		/* Colormap for this volume */
  int             curAmap;		/* Alphamap for this volume */

  int             modCmap;		/* Modulate the colormap with the transfer function? */
  int             modAmap;		/* Modulate the alphamap with the transfer function? */

  float           parm[4];		/* Transfer function editable parameters */
  unsigned char   parmValid;		/* Are these parameters valid?  If not get defaults */

  float           caparm[4];		/* Colormap / alphamap editable parameters */
  unsigned char   cmapValid;		/* Are the colormap parameters valid? */
  unsigned char   amapValid;		/* Are the alphamap parameters valid? */

  float           tfunc[256];		/* The transfer function for this volume */
  float           camap[256*4];		/* The colormap/alphamap for this volume */
  float           tlut[256*4];		/* The lookup table for this volume */

  unsigned char   histValid;		/* Is this histogram valid? */
  float           hist[256];		/* The volume's histogram table */

  int             active;		/* User set flag to turn rendering on and off */
  int             autoSpin;		/* Is this volume autospinning? */

  VRMotion        motion;

} VRVolumeData;


typedef struct
{
  int             refCount;		/* The number of references to this data */
  int             stateChanged;		/* Has this data changed since last redraw? */

  int             haveTexture;		/* This elevation has a texture */
#ifdef VR_IRISGL
  int             texId, tevId;		/* Texture ids */
#endif
#ifdef VR_OPENGL
  GLuint          texId, tevId;		/* Texture ids */
#endif
  float           txScl, tyScl;		/* Texture scale */

  coord          *polys;		/* The array of points that make up the surface */
  coord          *normals;		/* The array of normals to surface */
  int             polyWidth, polyHeight; /* The width and height of the surface array */

  float           xScl, yScl, zScl;	/* Elevation scaling */
  int             light;		/* Light this elevation? */
  float           xyRot;		/* Elevation X-Y rotation */
  float           xTrn, yTrn, zTrn;     /* Elevation translation */

} VRElevData;


typedef struct
{
  VRWorld        *world;		/* The globally shared parameters */
  VRView         *view;			/* The view specific parameters */
  VRMode         *mode;			/* The mode specific parameters */
  VRPolygonData  *polygonData;		/* The polygon data parameters */
  VRTableData    *tableData;		/* The transfer table data parameters */
  VRPlaneData    *planeData;		/* The slice plane data parameters */
  VRPointData    *pointData[MAX_SURFS];	/* The point data parameters */
  VRSurfaceData  *surfaceData[MAX_SURFS]; /* The surface data parameters */
  VRVolumeData   *volumeData[MAX_VOLS];	/* The volume data parameters */
  VRElevData     *elevData[MAX_ELEVS];	/* The elevation data parameters */

#ifdef __cplusplus
  MainWindow     *win;			/* The window associated with this state */
#else
  void           *win;			/* The window associated with this state */
#endif

  Window *winList;			/* A list of all X windows owned by this state */
  int winListCount;

} VRState;


#ifdef __cplusplus
}
#endif


#endif
