/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

/*
 * Signal handler code.
 */


#define _BSD_SIGNALS
#include <signal.h>

#include "genSignal.H"
#include "genSetup.H"
#include "genLoadData.h"
#include "hciMainWindow.H"


static XtSignalId signalID;


int RereadHandler(int, int, struct sigcontext*)
{
  void *ret;

  // Ignore reoccurences of the signal until we finish handling the reload
  ret = signal(SIGUSR1, SIG_IGN);
  if (ret == SIG_ERR) {
    fprintf(stderr, "Unable to register a SIGUSR1 handler!\n");
  }

  XtNoticeSignal(signalID);

  printf("Xt noticed a reread signal!\n");

  // We must reregister for the signal handler
  // Only reregister in System V, not BSD!
  // RegisterRereadSignalHandler();

  return( 0 );
}


void RereadData(XtPointer, XtSignalId*)
{
  void *ret;

  if (!world->readCompiled) {

    // We can only reread data in compiled mode
    NotifyError("A data reread was requested but cannot be attempted because\n"
		" volren is not in byte compiled data mode.", TRUE);

  } else {

    // Put up an application modal dialog!
    NotifyInfo("Rereading byte compiled data...");

    for (int i=0; i<state->world->nVols; i++)
       ReloadVRVolumeData( state, state->volumeData, i );
  }

  // Prepare handler to assept more reload signals again
  ret = signal(SIGUSR1, (void(*)(int)) RereadHandler);
  if (ret == SIG_ERR) {
    fprintf(stderr, "Unable to register a SIGUSR1 handler!\n");
  }
}


void RegisterRereadSignalHandler(void)
{
  void *ret;

  signalID = XtAppAddSignal(theApplication->appContext(), RereadData, NULL);

  ret = signal(SIGUSR1, (void(*)(int)) RereadHandler);
  if (ret == SIG_ERR) {
    fprintf(stderr, "Unable to register a SIGUSR1 handler!\n");
  }
}
