/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

#include "misQuaternion.h"


#define EPSILON 0.00001 


void quaternion_sphere_angle( quaternion *quat, 
			      double      tau, 
			      double      omega,
			      double      theta,
			      double      rotation ) 
{
   double norm ;

/* copied from Chen/ACM SIGGRAPH 88 */
   quat->x = -sin( tau ) * cos( theta ) * cos( omega ) - sin( theta ) * cos( tau ) ;
   quat->y = -sin( tau ) * sin( theta ) * cos( omega ) + cos( theta ) * cos( tau ) ;
   quat->z =  sin( tau ) * sin( omega ) ;
   quat->w = cos( rotation / 2 ) ;

   norm = 1.0 / ( quat->x * quat->x + quat->y * quat->y + quat->z * quat->z ) ;
   norm = sqrt( norm ) ;

   quat->x = norm * quat->x * sin( rotation / 2 ) ;
   quat->y = norm * quat->y * sin( rotation / 2 ) ;
   quat->z = norm * quat->z * sin( rotation / 2 ) ;
}


void quaternion_multiply( quaternion *qL,
			  quaternion *qR,
			  quaternion *q_out )
{
/* copied from Shoemake/ACM SIGGRAPH 89 */
   quaternion q_temp ;

   q_temp.w =   qL->w * qR->w - qL->x * qR->x   - qL->y * qR->y - qL->z * qR->z ;
   q_temp.x =   qL->w * qR->x   + qL->x * qR->w + qL->y * qR->z - qL->z * qR->y ;
   q_temp.y =   qL->w * qR->y   + qL->y * qR->w + qL->z * qR->x - qL->x * qR->z ;
   q_temp.z =   qL->w * qR->z   + qL->z * qR->w + qL->x * qR->y - qL->y * qR->x ;

   q_out->w = q_temp.w ;
   q_out->x   = q_temp.x ;
   q_out->y   = q_temp.y ;
   q_out->z   = q_temp.z ;
}


void quaternion_inverse( quaternion *q_in, quaternion *q_out )
{
/* copied from Shoemake/ACM SIGGRAPH 89 */
   double norm_inv ;

   norm_inv =  1.0 / ( q_in->w * q_in->w
		     + q_in->x * q_in->x 
		     + q_in->y * q_in->y
		     + q_in->z + q_in->z ) ;

   q_out->w = q_in->w * norm_inv ;
   q_out->x   = -q_in->x * norm_inv ;
   q_out->y   = -q_in->y * norm_inv ;
   q_out->z   = -q_in->z * norm_inv ;
}


void quaternion_matrix( quaternion *q, matrix mat )
{
/* copied from Shoemake/ACM SIGGRAPH 89 */
   double xs, ys, zs, wx, wy, wz, xx, xy, xz, yy, yz, zz ;

   xs = q->x + q->x;
   ys = q->y + q->y;
   zs = q->z + q->z;

   wx = q->w * xs ; wy = q->w * ys ; wz = q->w * zs ;
   xx = q->x * xs ; xy = q->x * ys ; xz = q->x * zs ;
   yy = q->y * ys ; yz = q->y * zs ; zz = q->z * zs ;

   mat[0][0] = 1.0 - ( yy + zz ) ;
   mat[0][1] = xy - wz ;
   mat[0][2] = xz + wy ;
   mat[1][0] = xy + wz ;
   mat[1][1] = 1.0 - ( xx + zz ) ;
   mat[1][2] = yz - wx ;
   mat[2][0] = xz - wy ;
   mat[2][1] = yz + wx ;
   mat[2][2] = 1.0 - ( xx + yy ) ;   

   mat[0][3] = 0.0;
   mat[1][3] = 0.0;
   mat[2][3] = 0.0;

   mat[3][0] = 0.0;
   mat[3][1] = 0.0;
   mat[3][2] = 0.0;
   mat[3][3] = 1.0;
}

/*
 * qexp: Exponentiate quaternion, assuming scalar part 0.
 */
void qexp( quaternion *q_in, quaternion *q_out )
{
/* copied from Shoemake/ACM SIGGRAPH 89 */
   double theta, scale ;

   theta = sqrt( q_in->x * q_in->x + q_in->y * q_in->y + q_in->z * q_in->z ) ;
   scale = 1.0 ;

   if( theta > EPSILON )
	scale = sin(theta)/theta ;
    q_out->x = scale * q_in->x ;
    q_out->y = scale * q_in->y ;
    q_out->z = scale * q_in->z ;
    q_out->w = cos( theta ) ;
}


/*
 * qlog: Exponentiate quaternion, assuming scalar part 0.
 */
void qlog( quaternion *q_in, quaternion *q_out )
{
/* copied from Shoemake/ACM SIGGRAPH 89 */
   double theta, scale ;

   scale = sqrt( q_in->x * q_in->x + q_in->y * q_in->y + q_in->z * q_in->z ) ;
   theta = atan2( scale, q_in->w ) ;

   if( scale > 0.0 )
	scale = theta/scale ;
    q_out->x = scale * q_in->x ;
    q_out->y = scale * q_in->y ;
    q_out->z = scale * q_in->z ;
    q_out->w = 0.0 ; 
}


/*
 * slerp: Spherical linear interpolation of unit quaternions.
 * As t goes from 0 to 1, qt goes from p to q.
 */
void slerp( quaternion *p, quaternion *q, double t, quaternion *qt )
{
/* copied from Shoemake/ACM SIGGRAPH 89 */

   double omega, cosom, sinom, sclp, sclq ;

   cosom = p->x * q->x + p->y * q->y + p->z * q->z + p->w * q->w ;
   if( (1.0 + cosom) > EPSILON ) 
     { /* usual case */
       if( (1.0 - cosom) > EPSILON )
         { /* usual case */
           omega= acos( cosom ) ;
	   sinom = sin( omega ) ;
	   sclp = sin((1.0 -t) * omega) /sinom ;
	   sclq = sin(t * omega) /sinom ;
         }
       else
	 { /* ends very close */
	   sclp = 1.0 - t ;
	   sclq = t ;
         }
       qt->x = sclp * p->x + sclq * q->x ;
       qt->y = sclp * p->y + sclq * q->y ;
       qt->z = sclp * p->z + sclq * q->z ;
       qt->w = sclp * p->w + sclq * q->w ;
     }
   else
     { /* ends nearly opposite */
       qt->x = -p->y ;
       qt->y = p->x ;
       qt->z = -p->w ;
       qt->w = p->z ;
       sclp = sin((0.5 - t) * M_PI ) ;
       sclq = sin( t * M_PI ) ;

       qt->x = sclp * p->x + sclq * qt->x ;
       qt->y = sclp * p->y + sclq * qt->y ;
       qt->z = sclp * p->z + sclq * qt->z ;
       qt->w = sclp * p->w + sclq * qt->w ;
     }
}
