/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "misBhash.h"
#include "genVolRen.h"


#define NG 16


/*
 * This routine marshalls arguments from struct oriented C coordinate data structures
 * to column oriented Fortran structures used by bhash.f
 */
void Interpolate2Ddata( coord *Data, int Npoints, int IndependentVarDirection,
                        int xRes, int yRes, coord *InterpolatedData  )
{
   int      i, j;
   int     *work_x, *work_y;

   float   *xCoords, *yCoords;

   float   *Datax, *Datay, *Dataf;

   float    xMin, xMax, xRange;
   float    yMin, yMax, yRange;

   float    dx, dy;

   int      UpDirection;

   float   *Eval;

   float    xg[NG], yg[NG];

   static   int ng = NG;  /* First stage grid size */

   static
   int      option_list[5] = {  0,   /* 0 = three stage interpolation */
                                     /* 1 = two stage approximation */
                                3,   /* degree used on boundary */
                                3,   /* degree used on the interior */
                                1,   /* do not assume low magnitude varying data */
                                1    /* bhash creates LSE grid */
			     };

   if ( IndependentVarDirection < 0 ||  IndependentVarDirection  > NORMAL_IS_Z )
   {
      fprintf( stderr, "Bogus independent variable direction: %d. Using Z axis\n",
	       IndependentVarDirection );
      UpDirection = NORMAL_IS_Z;
   }
   else
   {
      UpDirection = IndependentVarDirection;
   }

   work_x = (int *)malloc( sizeof(int) * Npoints );
   work_y = (int *)malloc( sizeof(int) * Npoints );

   if ( work_x == NULL || work_y == NULL )
   {
      fprintf( stderr, "Unable to allocate work array for interpolation routine\n" );
      exit( EXIT_FAILURE );
   }

   xCoords = (float *)malloc( sizeof(float)*xRes );
   yCoords = (float *)malloc( sizeof(float)*yRes );

   if ( xCoords == NULL || yCoords == NULL )
   {
      fprintf( stderr, "Unable to allocate memory for dependent variable coordinates\n" );
      exit( EXIT_FAILURE );
   }

   Datax = (float *)malloc( sizeof(float) * Npoints );
   Datay = (float *)malloc( sizeof(float) * Npoints );
   Dataf = (float *)malloc( sizeof(float) * Npoints );

   if ( Datax == NULL || Datay == NULL || Dataf == NULL )
   {
      fprintf( stderr, "Unable to allocate memory for data coordinates\n" );
      exit( EXIT_FAILURE );
   }
    
   for ( i = 0; i < Npoints; i++ )
   {
      switch ( UpDirection ) {

      case NORMAL_IS_X:
	Datax[i] = Data[i].z;
	Datay[i] = Data[i].y;
	Dataf[i] = Data[i].x;
	break;

      case NORMAL_IS_Y:
	Datax[i] = Data[i].x;
	Datay[i] = Data[i].z;
	Dataf[i] = Data[i].y;
	break;

      case NORMAL_IS_Z:
	Datax[i] = Data[i].x;
	Datay[i] = Data[i].y;
	Dataf[i] = Data[i].z;
	break;
      }
   }

   xMin = yMin =  HUGE;
   xMax = yMax = -HUGE;

   for ( i = 0; i < Npoints; i++ )
   {
      if ( xMin > Datax[i] ) xMin = Datax[i];
      if ( yMin > Datay[i] ) yMin = Datay[i];

      if ( xMax < Datax[i] ) xMax = Datax[i];
      if ( yMax < Datay[i] ) yMax = Datay[i];

      printf( "%d -- %f %f %f\n", i, Datax[i], Datay[i], Dataf[i] );
   }

   xRange = xMax - xMin;
   yRange = yMax - yMin;

   /* Pad the spatial ranges by +/- 0% */
   xMax += xRange * 0.0;
   yMax += yRange * 0.0;

   xMin -= xRange * 0.0;
   yMin -= yRange * 0.0;

   /* Recompute the range */
   xRange = xMax - xMin;
   yRange = yMax - yMin;

   dx = xRange / (float)(xRes - 1);
   dy = yRange / (float)(yRes - 1);

   for ( i = 0; i < xRes; i++ )
      xCoords[i] = i * dx + xMin;

   for ( i = 0; i < yRes; i++ )
      yCoords[i] = i * dy + yMin;

   Eval = (float *)malloc( sizeof(float) * xRes * yRes );

   if ( Eval == NULL )
   {
      fprintf( stderr, "Unable to allocate temporary surface data.\n" );
      exit( EXIT_FAILURE );
   }

   /* Interpolate the scattered data into a uniformily sampled volume */
   bhashd_(  Datax,
	     Datay,
	     Dataf,
	     &Npoints,                                 /* scattered data */
             xg, &ng, yg, &ng,                         /* bicubic hermite grid */
             xCoords, &xRes,                           /* grid coords */
	     yCoords, &yRes,
	     Eval,                                     /* scalar field */
	     &xRes,                                    /* xy grid res */
	     option_list,                              /* control options */
	     work_x, work_y                            /* temp work space */
           );


   for ( j = 0; j < xRes; j++ )
      for ( i = 0; i < yRes; i++ )
	switch ( UpDirection ) {

	case NORMAL_IS_X:
	  coord_fill( Eval[i*xRes + j], yCoords[i], xCoords[j], 
		      InterpolatedData[i*xRes +j] );
	  break;

	case NORMAL_IS_Y:
	  coord_fill( xCoords[j], Eval[i*xRes + j], yCoords[i],
		      InterpolatedData[i*xRes +j] );
	  break;

	 case NORMAL_IS_Z:
	  coord_fill( xCoords[j], yCoords[i], Eval[i*xRes + j],
		      InterpolatedData[i*xRes +j] );
	  break;
      }

   free( work_x );
   free( work_y );
   free( xCoords );
   free( yCoords );
   free( Datax );
   free( Datay );
   free( Dataf );
   free( Eval );
}
