/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

//
// Window maintainence routines
//


#include <Vk/VkApp.h>
#include <Vk/VkErrorDialog.h>

#include "genVolRen.h"
#include "genSetup.H"
#include "genWindowMaint.h"
#include "hciMainWindow.H"
#include "hciUpdateScreen.h"
#include "hciHandlers.h"
#include "volInit.h"


// All the states for all the open windows!

VRState *states[MAX_STATES];
int      stateCount = 0;


MainWindow* MakeTopLevelWindow( VRState *state, int monitor )
{
  MainWindow *win;
  Display *disp;
  char *dispName;

  if (monitor == -1)
    dispName = DisplayString(theApplication->display());
  else
    dispName = state->world->monitorName[monitor];

  disp = XOpenDisplay(dispName);
  if (disp == NULL) {

    char buf[128];

    sprintf(buf, "Unable to open a connection to display \"%s\"!\n",
	    state->world->monitorName[monitor]);
    NotifyError(buf, TRUE);

    return( NULL );
  }

  // Set the new display and screen
  state->view->disp = disp;
  state->view->scrn = DefaultScreen(disp);

  // Create a window
  win = new MainWindow("topLevelWin", state);

  // Record the window in the state
  state->win = win;

  // Record the new state
  states[stateCount++] = state;

  return( win );
}


void ReleaseTopLevelWindow( VRState *state )
{
  delete state->win;

  // Remove this state from the states list
  for (int i=0; i<stateCount; i++)
    if (state == states[i]) {
      states[i] = states[stateCount-1];
      stateCount--;
    }

  ReleaseVRState( state );
}


MainWindow* MakeTiedWindow( VRState *_state, int monitor )
{
  VRState *state;

  state = MakeVRState( _state, _state->world );

  // Get this window its own view
  ReleaseVRView( state->view );
  state->view = MakeVRView( state, _state->view );

  // Get this window its own mode
  ReleaseVRMode( state->mode );
  state->mode = MakeVRMode( state, _state->mode );

  return( MakeTopLevelWindow(state, monitor) );
}


MainWindow* MakeUntiedWindow( VRState *_state, int monitor )
{
  int i;
  VRState *state;

  state = MakeVRState( _state, _state->world );

  // Get this window its own view
  ReleaseVRView( state->view );
  state->view = MakeVRView( state, _state->view );

  // Get this window its own mode
  ReleaseVRMode( state->mode );
  state->mode = MakeVRMode( state, _state->mode );

  // Get this window its own tableData
  ReleaseVRTableData( state->tableData );
  state->tableData = MakeVRTableData( state, _state->tableData );

  // Get this window its own planeData
  ReleaseVRPlaneData( state->planeData );
  state->planeData = MakeVRPlaneData( state, _state->planeData );

  for (i=0; i<MAX_SURFS; i++) {
    // Get this window its own pointData
    ReleaseVRPointData( state->pointData[i] );
    state->pointData[i] = MakeVRPointData( state, NULL );

    // Get this window its own surfaceData
    ReleaseVRSurfaceData( state->surfaceData[i] );
    state->surfaceData[i] = MakeVRSurfaceData( state, NULL );
  }

  return( MakeTopLevelWindow(state, monitor) );
}


static int WindowStateChanged( VRState *state )
{
  int i;
  int flag = FALSE;


  flag = state->world->stateChanged       || state->view->stateChanged        ||
	 state->mode->stateChanged        || state->tableData->stateChanged   ||
	 state->planeData->stateChanged   || state->view->autoSpin            ||
         state->mode->loopMode;

  for (i=0; i<MAX_SURFS; i++)
    flag |= state->pointData[i]->stateChanged ||
            state->surfaceData[i]->stateChanged;

  for (i=0; i<state->world->nVols; i++)
    flag |= state->volumeData[i]->stateChanged ||
            state->volumeData[i]->autoSpin;

  for (i=0; i<state->world->nElevs; i++)
    flag |= state->elevData[i]->stateChanged;

  return( flag );
}


static void WindowStateClear( VRState *state )
{
  int i;

  state->world->stateChanged       = state->view->stateChanged       =
  state->mode->stateChanged        = state->tableData->stateChanged  =
  state->planeData->stateChanged   = FALSE;

  for (i=0; i<MAX_SURFS; i++) {
    state->pointData[i]->stateChanged = FALSE;
    state->surfaceData[i]->stateChanged = FALSE;
  }

  for (i=0; i<state->world->nVols; i++)
    state->volumeData[i]->stateChanged = FALSE;

  for (i=0; i<state->world->nElevs; i++)
    state->elevData[i]->stateChanged = FALSE;
}


void RedrawWindow( VRState *state )
{
  // If we are still initializing, don't update the screen
  // because the state structure is not yet valid!
  if (state->world->initing)
    return;

  // Focus on this window
  FocusView( state );

  // Turn the volume if it is spinning
  if (state->view->autoSpin)
    SpinVolume( state, -1, NULL, NULL );

  for (int volNumber=0; volNumber<state->world->nVols; volNumber++)
    if (state->volumeData[volNumber]->autoSpin)
      SpinVolume( state, volNumber, NULL, NULL );

  // Draw the image in the window
  UpdateView( state );

  // Check for OpenGL errors
  winCheckError(state);

  // Update the window state (sliders)
  if (state->tableData->stateChanged) {
    state->win->ResetSliderValues();
    state->tableData->stateChanged = FALSE;
  }
}


void RedrawWindows()
{
  for (int i=0; i<stateCount; i++)
    if (WindowStateChanged( states[i] ))
      RedrawWindow( states[i] );

  for (i=0; i<stateCount; i++)
    WindowStateClear( states[i] );
}


void winCheckError(VRState *state)
{
#ifdef VR_OPENGL
  GLenum err = glGetError();

  if (err != GL_NO_ERROR)
    printf("GL error : %s (0x%04x)\n", gluErrorString(err), (int) err);
  else
    if (state->view->verbose)
      printf("No error\n");
#endif
}
