/*
Copyright 1994 Silicon Graphics, Inc. -- All Rights Reserved

If the Software is acquired by or on behalf of an entity of government
of  the  United States of America, the following provision applies: U.
S.  GOVERNMENT  RESTRICTED  RIGHTS  LEGEND:    Use,   duplication   or
disclosure of Software by the Government is subject to restrictions as
set forth in FAR 52.227-19(c)(2) or  subparagraph  (c)(1)(ii)  of  the
Rights  in  Technical  Data  and  Computer  Software  clause  at DFARS
252.227-7013 and/or in similar or successor clauses in the FAR, or the
DOD  or  NASA  FAR Supplement. Unpub-lished- rights reserved under the
Copyright  Laws  of  the  United  States.  Contractor/manufacturer  is
SILICON  GRAPHICS,  INC.,  2011  N. Shoreline Blvd., Mountain View, CA
94039- 7311.

Silicon Graphics, Inc. hereby grants  to  you  a  non-exclusive,  non-
transferable,  personal, paid-up license to use, modify and distribute
the Software solely with SGI computer products.  You must include,  in
all  copies  of  the  Software  and  any associated documentation, the
copyright notice and restricted rights legend set forth above.

THE SOFTWARE IS PROVIDED  TO  YOU  "AS-IS"  AND  WITHOUT  ANY  SUPPORT
OBLIGATION  OR  WARRANTY  OF  ANY KIND, EXPRESS, IMPLIED OR OTHERWISE,
INCLUDING WITHOUT  LIMITATION,  ANY  WARRANTY  OF  MERCHANTABILITY  OR
FITNESS  FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SGI BE LIABLE FOR
SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF  LIABILITY,
ARISING  OUT  OF  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

You agree that you will not export or re-export the Software, directly
or  indirectly,  unless  (a)  the  Export  Administration of the U. S.
Department of Commerce explicitly permits the export or  re-export  of
the  Software  or  (b)  the  Office  of  Export Licensing of the U. S.
Department of Commerce has granted au-thorization to  you  in  writing
for the  export or re- export the Software.

If you fail to fulfill any  of  the  foregoing  obligations,  SGI  may
pursue  all  available  legal  remedies  to  enforce  these  terms and
conditions, and SGI may,  at  any  time  after  your  default  hereof,
terminate  the  license  and  rights  granted  to  you hereunder.  You
further agree that, if SGI terminates this license for  your  default,
you  will, within ten (10) days after any such termination, deliver to
SGI or  render  unusable  all  Software  originally  provided  to  you
hereunder and any copies thereof embodied in any medium.
*/

/*
 * All cpp arguments
 *
 * Every file should include this one before anything else!
 *
 */


#ifndef _CPP_ARGS_H_
#define _CPP_ARGS_H_


#define VR_VERSION   "6.0"


/* Make sure that either IrisGL or OpenGL is specified! */

#if (!defined(VR_IRISGL) && !defined(VR_OPENGL))
#define VR_OPENGL
#endif


/* Make sure that either Venice or Impact is specified! */
#if (!defined(VR_KONA) && !defined(VR_VENICE) && !defined(VR_IMPACT))
#define VR_VENICE
#endif

/*
 * These defined macros are used to mark regions of code that
 * represent functionality in the renderer that is not yet supported.
 * It should be called with a feature and a mode
 * (e.g. VR_FEAT_INTERLEAVE and VR_MODE_IRISGL).  They will cause
 * compile errors by default.  If VR_OVERRIDE_CPPS is defined they
 * will just generate code that will print an error and exit at
 * run-time.
 */

#ifdef VR_FORCE_ERROR
#define NO_SUPPORT_WITH(x,y)    FORCE_ERROR!
#define NO_SUPPORT_WITHOUT(x,y) FORCE_ERROR!
#else
#include <stdio.h>
#include <stdlib.h>
#define NO_SUPPORT_WITH(f,m)    fprintf(stderr, "Error: %s isn't supported with %s!\n", \
					(f), (m)); exit( EXIT_FAILURE )
#define NO_SUPPORT_WITHOUT(f,m) fprintf(stderr, "Error: %s is required for %s!\n", \
					(f), (m)); exit( EXIT_FAILURE )
#endif

/* Modes */
#define VR_MODE_IRISGL          "iris GL"
#define VR_MODE_OPENGL          "open GL"
#define VR_MODE_VENICE          "reality engine graphics"
#define VR_MODE_IMPACT          "impact graphics"
#define VR_MODE_COMPILING       "data compiling"

/* Features */
#define VR_FEAT_IRISGL          "Iris GL"
#define VR_FEAT_OPENGL          "Open GL"
#define VR_FEAT_INTERLEAVE      "Texture interleaving"
#define VR_FEAT_TEXOBJS         "Texture object"
#define VR_FEAT_AUXBUFFER       "Auxilary buffer"
#define VR_FEAT_TLUTS           "Texture lookup table"
#define VR_FEAT_SUBTEX          "Subtexture loading"
#define VR_FEAT_STEREO          "Stereo viewing"


/*
 * Below we setup names for the different enabled options compiled
 * into this version of the renderer.
 */

/* Names */
#define VR_NAME_IRISGL          "Iris GL"
#define VR_NAME_OPENGL          "Open GL"
#define VR_NAME_VENICE          "Reality Engine"
#define VR_NAME_IMPACT          "Impact"
#define VR_NAME_KONA            "Infinite Reality"
#define VR_NAME_INTERLEAVE      "Texture Interleaving"
#define VR_NAME_TEXOBJS         "Texture Objects"
#define VR_NAME_AUXBUFFER       "Auxilary Buffers"
#define VR_NAME_TLUTS           "Texture Lookup Tables"
#define VR_NAME_SUBTEX          "Subtexture Loading"
#define VR_NAME_STEREO          "Stereo Viewing"
#define VR_NAME_MERGING         "Volume Merging"
#define VR_NAME_MATTING         "Volume Matting"
#define VR_NAME_SHADING         "Volume Shading"


#ifdef VR_KONA
#define VR_NAME_MACHINE VR_NAME_KONA
#endif
#ifdef VR_VENICE
#define VR_NAME_MACHINE VR_NAME_VENICE
#endif
#ifdef VR_IMPACT
#define VR_NAME_MACHINE VR_NAME_IMPACT
#endif


/*
 * Below we setup the standard options based upon the mode
 * (IrisGL/OpenGL).  If VR_OVERRIDE_CPPS is defined don't change
 * anything.  Trust the user completely.  Use this with care.  The
 * code does not support every permutation of options.  However, the
 * code should call a NO_SUPPORT_* macro anytime an attempt is made to
 * utilize a feature/mode combination that won't work.
 */

#ifndef VR_OVERRIDE_CPPS

/* IrisGL standard setup */

#ifdef  VR_IRISGL

#ifdef  VR_KONA
NO_SUPPORT_WITH(VR_FEAT_IRISGL, VR_MODE_IMPACT);
#endif

#ifdef  VR_VENICE
#define VR_INTERLEAVE		/* Use interleaved textures */
#undef  VR_TEXOBJS		/* Don't use OpenGL texobjs */
#define VR_AUXBUFFER		/* Use off-screen accelerated buffer */
#define VR_TLUTS		/* Use texture lookup tables */
#undef  VR_SUBTEX		/* Don't use subtexture loads */
#define VR_STEREO		/* Allow use of stereo buffers */
#define VR_MERGING		/* Allow volume merging */
#define VR_MATTING		/* Allow volume matting */
#define VR_SHADING		/* Allow volume shading */
#endif

#ifdef  VR_IMPACT
NO_SUPPORT_WITH(VR_FEAT_IRISGL, VR_MODE_IMPACT);
#endif

#endif


/* OpenGL standard setup */

#ifdef  VR_OPENGL

#ifdef  VR_KONA
#undef  VR_INTERLEAVE		/* Don't use interleaved textures */
#define VR_TEXOBJS		/* Use OpenGL texobjs */
#undef  VR_AUXBUFFER		/* Don't use off-screen accelerated buffer */
#define VR_TLUTS		/* Use texture lookup tables */
#define VR_SUBTEX		/* Use subtexture loads */
#define VR_STEREO		/* Allow use of stereo buffers */
#define VR_MERGING		/* Don't allow volume merging */
#undef  VR_MATTING		/* Don't allow volume matting */
#undef  VR_SHADING		/* Don't allow volume shading */
#endif

#ifdef  VR_VENICE
#undef  VR_INTERLEAVE		/* Don't use interleaved textures */
#define VR_TEXOBJS		/* Use OpenGL texobjs */
#undef  VR_AUXBUFFER		/* Don't use off-screen accelerated buffer */
#define VR_TLUTS		/* Use texture lookup tables */
#undef  VR_SUBTEX		/* Use subtexture loads */
#define VR_STEREO		/* Allow use of stereo buffers */
#define VR_MERGING		/* Don't allow volume merging */
#undef  VR_MATTING		/* Don't allow volume matting */
#undef  VR_SHADING		/* Don't allow volume shading */
#endif

#ifdef  VR_IMPACT
#undef  VR_INTERLEAVE		/* Don't use interleaved textures */
#define VR_TEXOBJS		/* Use OpenGL texobjs */
#undef  VR_AUXBUFFER		/* Don't use off-screen accelerated buffer */
#define VR_TLUTS		/* Use texture lookup tables */
#define VR_SUBTEX		/* Use subtexture loads */
#define VR_STEREO		/* Allow use of stereo buffers */
#define VR_MERGING		/* Don't allow volume merging */
#undef  VR_MATTING		/* Don't allow volume matting */
#undef  VR_SHADING		/* Don't allow volume shading */
#endif

#define COLOR_TO_OGL(color)     ((((color)>> 0) & 0xff) / 255.0), \
                                ((((color)>> 8) & 0xff) / 255.0), \
                                ((((color)>>16) & 0xff) / 255.0), \
                                ((((color)>>24) & 0xff) / 255.0)
#endif

#endif


#endif
