/************************************************************************/
/*									*/
/*	Copyright Pittsburgh Supercomputing Center 1987, 1988, 1990	*/
/*	All Rights Reserved						*/
/*	Author Joel Welling						*/
/*			    						*/
/*      CGMGEN.H version 4.0                                            */
/*                                                                      */
/************************************************************************/

/* Storage lengths for device driver name, picture name, and file name */
#define maxdevnamelength 20
#define maxpicnamelength 256
#define maxfnamelength 256
/* 
  CGM metafile states: 
	0=uninitialized, or after 'end metafile'
	1= after 'begin metafile' or 'end picture'
	2= after 'begin picture'
	3= after 'begin picture body'
*/

typedef struct driver_struct {
  char devnam[maxdevnamelength];         /* device name */
  char fname[maxfnamelength];     /* output file name */
  int open;                       /* true if device open */
  int cgmstate;                   /* current state of this device */
  int pgnum;                      /* current page number of this device */
  int mag;                        /* for use by text emulator */
  float xpxl_scale, ypxl_scale;   /* coordinate scale factors */
  float xpxl_shift, ypxl_shift;   /* coordinate shift factors */
  float pxl_vdc;                  /* device pixels per VDC unit */
  struct mf_d_struct g1;          /* class 1 attributes */
  struct pic_d_struct g2,d2;      /* class 2 attributes (global and default) */
  struct control_struct g3,d3;    /* class 3 attributes (global and default) */
  struct attrib_struct g5,d5;     /* class 5 attributes (global and default) */
  int (*delim[Delim_Size])();	  /* delimiter functions */
  int (*mfdesc[MfDesc_Size])();	  /* metafile descriptor functions */
  int (*pdesc[PDesc_Size])();	  /* page descriptor functions */
  int (*mfctrl[Control_Size])();  /* mf control functions */
  int (*gprim[GPrim_Size])();	  /* graphical primitives */
  int (*attr[Att_Size])();	  /* the attribute functions */
  int (*escfun[Esc_Size])();	  /* the escape functions */
  int (*extfun[Ext_Size])();	  /* the external functions */
  int (*ctrl[Delim_Size])();	  /* external controller functions */
  struct info_struct dev_info;    /* device information */
  struct driver_struct *next, *prev; /* to construct linked list of these */
  
} driver_info;

extern driver_info *cgm_current_driver;
