/*
### handle events from phase space window ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>

void phase_handle_event(canvas, event, arg)
Canvas          canvas;
Event          *event;
caddr_t         arg;
{
	static int r_x, r_y, r_xnew, r_ynew, r_tmp;
	static int e_x_tmp,e_y_tmp;
	int i, e_x, e_y,e_id, e_down,e_ctrl_down,e_shift_down;
	double win_xsize, win_ysize,x_scaled, y_scaled;
	extern Menu main_menu;
	extern Pixwin *pw;
	extern Pixfont *boldfont24,*boldfont;
	extern int stop,record_on,cur_color,region_index,clipping,text_input_mode,more_digits_on;
	extern int mdim1,mdim0,mdim1_init,mdim0_init;
	extern int l_margin,xwidth,ycanvas,b_margin,ywidth;
	extern int n_displayed_data1,n_displayed_data0,segment_count1,segment_count0;
	extern int p_l_margin,p_b_margin,p_xwidth,p_ywidth;
	extern int slide_mode,n_stored_data1,n_stored_data0,n_stored_data0_save,n_stored_data1_save,rescale,var_cur_index[],param_cur_index[];
	extern int var_dim,func_dim,param_dim,full_dim;
	extern int forward_toggle,continue_toggle,my_colormap_size;
        extern int *data0_color,*data1_color,**data2_color;
	extern double *win_var_i,*win_var_f,*win_var_i_old,*param,*all_min,*all_max;
        extern double **data0_x,**data1_x,**data2_x;
	extern char string[];

	e_down = event_is_down(event);
	e_id = event_id(event);
	if(e_down && e_id != LOC_MOVE ){
		e_ctrl_down = event_ctrl_is_down(event);
		e_shift_down = event_shift_is_down(event);
		if(e_ctrl_down != 0)
			e_ctrl_down = 1;
		if(e_shift_down != 0)
			e_shift_down = 1;
		e_x = event_x(event);
		e_y = event_y(event);
		if(!event_is_ascii(event)){
			e_x_tmp = e_x;
			e_y_tmp = e_y;
		}
		else if(text_input_mode) {
			sprintf(string,"%c",e_id);
			if(slide_mode)
				pw_text(pw,e_x_tmp,e_y_tmp,PIX_SRC | PIX_COLOR(cur_color),(Pixfont *)boldfont24,string);
			else
				pw_text(pw,e_x_tmp,e_y_tmp,PIX_SRC | PIX_COLOR(cur_color),(Pixfont *)boldfont24,string);
				/*
				pw_text(pw,e_x_tmp,e_y_tmp,PIX_SRC | PIX_COLOR(cur_color),(Pixfont *)boldfont,string);
				*/
			e_x_tmp += 10;
		}
		if(e_id == MS_LEFT || e_id == MS_MIDDLE || e_id == MS_RIGHT || e_id == LOC_DRAG ){
			region_index = (int) which_region(e_x,e_y);
		}
	}
	else {
		return;
	}

	/* menu */
	if(!e_ctrl_down && !e_shift_down && e_id == MS_RIGHT){
		menu_show(main_menu,canvas,event,0);
		/* Temporary fix for a loss of a white screen cursor on the
		black background in the phase space box */
		load_colormap(1);
		return;
	}

	if(e_shift_down && e_id == MS_RIGHT){
		all_reset();
		if (region_index==1){
			sun_to_space_coord(&x_scaled,&y_scaled,e_x,e_y,1);
			win_var_i[var_cur_index[0]]= all_min[var_cur_index[0]] + x_scaled * (all_max[var_cur_index[0]] - all_min[var_cur_index[0]]);
			win_var_i[var_cur_index[1]] = all_min[var_cur_index[1]] + y_scaled * (all_max[var_cur_index[1]] - all_min[var_cur_index[1]]);
		}
		main_refresh();
		return;
	}

	/* get the color from the colormap strip */
	if(e_id == MS_LEFT && region_index == -2 ) {
		all_reset();
		cur_color = (int) get_color(e_x,e_y);
		all_refresh();
		return;
	}

	if (!rescale && e_ctrl_down && e_id == MS_MIDDLE ) {
		all_reset();
		if(region_index==-2){
			clear_region(region_index);
			draw_title_label(1);
			draw_axis_label(1);
		}
		else if(region_index == 1){
			clear_region(region_index);
			draw_all_objects(1);
			show_colormap();
			n_stored_data1_save = n_stored_data1;
			n_displayed_data1 = 0;
			n_stored_data1 = 0;
			segment_count1 = 0;
			if(mdim1 > mdim1_init){
				mdim1 = mdim1_init;
				data1_x = (double **) realloc_main_data(mdim1,full_dim);
				if(!stop){
					sprintf(string,"data1: Memory reallocation done! new_dim = %d\n",mdim1);
					system_mess_proc(0,string);
				}
			}
		}
		all_refresh();
		return;
	}

	/* new forward or backward orbits */
	if (!rescale && !e_ctrl_down  && e_id == MS_LEFT){
		all_reset();

		/* Forward or backward orbits from a mouse input */
		if (region_index==1){
			sun_to_space_coord(&x_scaled,&y_scaled,e_x,e_y,1);
			win_var_i[var_cur_index[0]]= all_min[var_cur_index[0]] + x_scaled * (all_max[var_cur_index[0]] - all_min[var_cur_index[0]]);
			win_var_i[var_cur_index[1]] = all_min[var_cur_index[1]] + y_scaled * (all_max[var_cur_index[1]] - all_min[var_cur_index[1]]);
			segment_count1++;
			if (!e_shift_down) {
				forward_toggle = TRUE;
				compute_orbit(forward_toggle);
			} else {
				forward_toggle =  FALSE;
				compute_orbit(forward_toggle);
			}
		}
		main_refresh();
		return;
	}

	if(!rescale && !e_shift_down && e_id == MS_MIDDLE){
		(void) continue_proc();
		return;
	}

	if (!rescale && !e_ctrl_down && e_shift_down && e_id == MS_MIDDLE ) {
		all_reset();
		/* redisplay the message area only */
		if(region_index == -2){
			draw_all_objects(1);
			show_colormap();
		}
		/* redisplay the message area and all data */
		else if(region_index == -1){
			redisplay_data(region_index);
			show_colormap();
		}
		/* redisplay phase space data */
		else if(region_index == 1){
			redisplay_data(region_index);
		}
		return;
	}


	if(!rescale && e_ctrl_down && !e_shift_down && e_id == MS_RIGHT ) {
		system_mess_proc(0,"Phase space selected!");
		all_reset();
		return;
	}
	/* enter a rescaling mode */
	if ((rescale || e_ctrl_down) && e_id == MS_LEFT  ) {
		if(region_index != 1)
			return;
		all_reset();
		if(e_ctrl_down)
			rescale = 1- rescale;
		if(rescale)
			frame_header_proc(1,"[Rescaling On]");
		else
			frame_header_proc(1,"[Rescaling Off]");
		box(pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		r_x = e_x;
		r_y = e_y;
		r_xnew = r_x;
		r_ynew = r_y;
		box(pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		return;
	}
	/* show the rubberband box for the rescaled region */
	if (rescale && e_id == LOC_DRAG ) {
		box(pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		r_xnew = e_x;
		r_ynew = e_y;
		box(pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size - 1,1);
		return;
	}
	/* rescaling action and exit rescaling mode */
	if (rescale && e_id == MS_MIDDLE ) {
		box(pw,r_x, r_y, r_xnew - r_x, r_y - r_ynew, my_colormap_size-1,1);
		all_reset();
		if (r_x > r_xnew) {
			r_tmp = r_xnew;
			r_xnew = r_x;
			r_x = r_tmp;
		}
		if (r_y < r_ynew) {
			r_tmp = r_ynew;
			r_ynew = r_y;
			r_y = r_tmp;
		}

		if(region_index==1){
			win_xsize = all_max[var_cur_index[0]] - all_min[var_cur_index[0]];
			win_ysize = all_max[var_cur_index[1]] - all_min[var_cur_index[1]];
			if(!e_shift_down) {
				all_max[var_cur_index[0]] = all_min[var_cur_index[0]] + win_xsize * (r_xnew - l_margin) / (double) xwidth;
				all_min[var_cur_index[0]] += win_xsize * (r_x - l_margin) / (double) xwidth;
				all_max[var_cur_index[1]] = all_min[var_cur_index[1]] + win_ysize * ((ycanvas - r_ynew) - b_margin) / (double) ywidth;
				all_min[var_cur_index[1]] += win_ysize * ((ycanvas - r_y) - b_margin) / (double) ywidth;
			}
			else {
				all_min[var_cur_index[0]] -= win_xsize * (r_x - l_margin) / (r_xnew - r_x);
				all_max[var_cur_index[0]] = all_min[var_cur_index[0]] + win_xsize * xwidth / (r_xnew - r_x);
				all_min[var_cur_index[1]] -= win_ysize * ((ycanvas - r_y) - b_margin) / (r_y - r_ynew);
				all_max[var_cur_index[1]] = all_min[var_cur_index[1]] + win_ysize * ywidth / (r_y - r_ynew);
			}
			redisplay_data(region_index);
		}

		r_xnew = r_x;
		r_ynew = r_y;
		rescale = 0;
		frame_header_proc(1,"[Rescaling Off]");
		main_refresh();
		return;
	}

	(void) handle_function_keys(1,e_id);
}
