/*
### free model dependent dynamically allocated memories except main data variables and mixed variables ###
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>

void free_model_init()
{
	void free_dvector(),free_svector(),free_dmatrix();
	extern int var_dim,full_dim,func_dim,param_dim,all_dim;
	extern int var_dim_max,full_dim_max,func_dim_max,param_dim_max,all_dim_max;
	extern double *var_i,*var_polar_i,*var_min,*var_max,*var_polar_min,*var_polar_max;
	extern double *v,*t_v,*t_vf,*t_va,*xoffset,*int_yscal,*period_len;
	extern double *win_var_i,*win_var_f,*win_var_i_old;
	extern double *func,*func_i,*func_f,*func_min,*func_max,*func_min_top,*func_max_top;
	extern double *all_min,*all_max,*all_min_top,*all_max_top;
	extern double *param,*param_min,*param_max,*param_min_top,*param_max_top;
	extern char **var_label,**var_polar_label,***param_label,**func_label,**win_var_label,**all_label;
	extern Panel_item *param_item,*var_i_item,*func_i_item,*func_f_item,*all_min_item,*all_max_item,*int_yscal_item;

	free_dvector(var_i,0,var_dim -1);
	free_dvector(var_polar_i,0,var_dim-1);
	free_dvector(var_min,0,var_dim-1);
	free_dvector(var_max,0,var_dim-1);
	free_dvector(var_polar_min,0,var_dim-1);
	free_dvector(var_polar_max,0,var_dim-1);

	free_dvector(win_var_i,0,var_dim -1);
	free_dvector(win_var_i_old,0,var_dim -1);
	free_dvector(win_var_f,0,var_dim -1);

	free_dvector(func,0,func_dim-1);
	free_dvector(func_i,0,func_dim-1);
	free_dvector(func_f,0,func_dim-1);
	free_dvector(func_min,0,func_dim-1);
	free_dvector(func_max,0,func_dim-1);

	free_dvector(all_min,0,full_dim+param_dim-1);
	free_dvector(all_max,0,full_dim+param_dim-1);
	free_dvector(all_min_top,0,full_dim+param_dim-1);
	free_dvector(all_max_top,0,full_dim+param_dim-1);

	free_dvector(param,0,param_dim-1);
	free_dvector(param_min,0,param_dim-1);
	free_dvector(param_max,0,param_dim-1);
	free_dvector(param_min_top,0,param_dim-1);
	free_dvector(param_max_top,0,param_dim-1);

	free_dvector(period_len,0,full_dim+param_dim-1);

	free_dvector(v,0,full_dim-1);
	free_dvector(t_v,0,full_dim-1);
	free_dvector(t_vf,0,full_dim-1);
	free_dvector(t_va,0,full_dim+param_dim-1);

	free_svector(all_label,0,all_dim_max-1);
	free_svector(win_var_label,0,all_dim_max-1);
	free_svector(func_label,0,func_dim_max-1);
	free_svector(param_label,0,param_dim_max -1);
	free_svector(var_label,0,var_dim_max-1);
	free_svector(var_polar_label,0,var_dim_max-1);

	/*
	free(all_label);
	free(win_var_label);
	free(func_label);
	free(param_label);
	free(var_label);
	free(var_polar_label);
	*/

	free_dvector(int_yscal,0,var_dim-1);
	free_dvector(xoffset,0,var_dim-1); 

	free(param_item);
	free(var_i_item);
	free(func_i_item);
	free(func_f_item);
	free(all_min_item);
	free(all_max_item);
	free(int_yscal_item);
}
