/*
### clear a region of phase, parameter, combined space canvas ###
------------------------------------------------------------------------------------
r_index: 0: clear parameter space
	1: clear phase space
	2: clear aux space
	3: title and message area
	4: message area only
	-1: clear the entire phase space canvas area
*/

#include <suntool/sunview.h>
#include <suntool/canvas.h>
clear_region(r_index)
int r_index;
{
	int i;

	extern int aux_max,*aux_on,*aux_win_mode;
	extern int aux_l_margin,aux_ycanvas,aux_b_margin,aux_ywidth,aux_xwidth;
	extern Pixwin **aux_pw;

	extern Canvas canvas,param_canvas;
	extern Pixwin *pw,*param_pw;
	extern short param_window_show;
	extern int xwindow,ycanvas,l_margin, b_margin,y_message,y_line_height,xwidth,ywidth;
	extern int p_l_margin,p_b_margin,p_xwidth,p_ywidth,p_ycanvas;

	switch (r_index) {
	case -2:
		/* all canvas */
		pw_writebackground(pw, 0, 0, window_get(canvas, CANVAS_WIDTH), window_get(canvas, CANVAS_HEIGHT), PIX_CLR);
		break;
	case -1:
		/* all canvas */
		pw_writebackground(pw, 0, 0, window_get(canvas, CANVAS_WIDTH), window_get(canvas, CANVAS_HEIGHT), PIX_CLR);
		break;
	case 0:
		/* parameter space box */
		if(param_window_show==1){
			pw_writebackground(param_pw, 0,0,window_get(param_canvas,CANVAS_WIDTH),window_get(param_canvas,CANVAS_HEIGHT), PIX_CLR);
		}
		break;
	case 1:
		/* phase space box */
		pw_writebackground(pw, l_margin - 5, ycanvas - b_margin - ywidth -5, xwidth + 10, ywidth + 10, PIX_CLR);

		for(i=0;i<aux_max;i++){
			if(aux_on[i] && aux_win_mode[i]==0)
				pw_writebackground(aux_pw[i], aux_l_margin - 5, aux_ycanvas - aux_b_margin - aux_ywidth - 5, aux_xwidth+10, aux_ywidth+10, PIX_CLR);
		}

		break;

	case 3:
		/* Title label, colormap, and message area */
		pw_writebackground(pw, 0, 0, xwindow, ycanvas - b_margin - ywidth - 1, PIX_CLR);
		break;
	case 4:
		/* message area only */
		pw_writebackground(pw, 0, 0, xwindow, y_message+4*y_line_height+10, PIX_CLR);
		break;
	default:
		break;
	}
}
