/*
### procedure for printing a postscript graphic file ###
*/

#include <stdio.h>

void print_ps_proc(print_region)
int print_region;
{
	static print_count = 0;
	int i,j,ix,iy;
	char line[160],line2[160];
	double xtmin,xtmax,ytmin,ytmax;
	extern FILE *ffp, *fopen();
	extern int stop,aux_win_i,large_system_on;
	extern int n_stored_data1,n_stored_data0,n_stored_data2,var_cur_index[],param_cur_index[],**aux_cur_index,*aux_win_mode;
	extern int ds_class,model,param_dim,var_dim,func_dim,full_dim;
	extern int int_algorithm,draw_all,polar_coord,i_step,i_start,i_max;
	extern int section_index,linear_interpolation,n_displayed_data1,n_displayed_data0,polar_section;
	extern double *param,*all_min,*all_max,*win_var_i,*all_min,*all_max;
	extern double time_step,*func_i,*func_f,section_constant;
	extern double **aux_x_min,**aux_x_max;
	extern char *title_label,**all_label,**param_label,full_path[],dir_name[];
	extern char lstring[],lstring2[],preproc_label[],graph_label[],lpr_label[];
        extern int *data0_color,*data1_color,*data2_color;
        extern double **data0_x,**data1_x,**data2_x;

	stop = 0;
	print_count++;
	all_reset();
	sprintf(full_path,"%s/tmp.print%d",dir_name,print_count);
	ffp = fopen(full_path, "w");
	if(ffp == NULL){
		sprintf(lstring,"Cannot open file %s!",full_path);
		system_mess_proc(1,lstring);
		fclose(ffp);
		return;
	}
	/* maximum is n_stored_data in n_stored_data panel */
	/* This choice ensures the correct printing of rescaled data */
	if(print_region ==1 ){
		for (i = 0; i < n_stored_data1; i++) {
			fprintf(ffp, "%%XC%d %.14lg %.14lg\n", data1_color[i], data1_x[var_cur_index[0]][i], data1_x[var_cur_index[1]][i]);
			if(stop) {
				fclose(ffp);
				return;
			}		
		}
	}
	else if(print_region ==0 ){
		for (i = 0; i < n_stored_data0; i++) {
			fprintf(ffp, "%%XC%d %.14lg %.14lg\n", data0_color[i], data0_x[param_cur_index[0]][i], data0_x[param_cur_index[1]][i]);
			if(stop) {
				fclose(ffp);
				return;
			}		
		}
	}
	else if(print_region ==2){
		if(aux_win_mode[aux_win_i]==0){
			for (i = 0; i < n_stored_data1; i++) {
				fprintf(ffp, "%%XC%d %.14lg %.14lg\n", data1_color[i], data1_x[aux_cur_index[aux_win_i][0]][i], data1_x[aux_cur_index[aux_win_i][1]][i]);
				if(stop) {
					fclose(ffp);
					return;
				}		
			}
		}
		else {
			for (i = 0; i < n_stored_data2; i++) {
				fprintf(ffp, "%%XC%d %.14lg %.14lg\n", data2_color[i], data2_x[aux_cur_index[aux_win_i][0]][i], data2_x[aux_cur_index[aux_win_i][1]][i]);
				if(stop) {
					fclose(ffp);
					return;
				}		
			}
		}
	}
	fclose(ffp);

	if(print_region==1){
		ix = var_cur_index[0];
		iy = var_cur_index[1];
		xtmin = all_min[ix];
		xtmax= all_max[ix];
		ytmin = all_min[iy];
		ytmax = all_max[iy];
	}
	else if(print_region==0){
		ix = full_dim+param_cur_index[0];
		iy = full_dim+param_cur_index[1];
		xtmin = all_min[ix];
		xtmax= all_max[ix];
		ytmin = all_min[iy];
		ytmax = all_max[iy];
	}
	else if(print_region==2){
		ix = aux_cur_index[aux_win_i][0];
		iy = aux_cur_index[aux_win_i][1];
		xtmin = aux_x_min[ix][aux_win_i];
		xtmax = aux_x_max[ix][aux_win_i];
		ytmin = aux_x_min[iy][aux_win_i];
		ytmax = aux_x_max[iy][aux_win_i];
	}

	sprintf(full_path,"%s/tmp.header%d",dir_name,print_count);
	ffp = fopen(full_path,"w");
	if(ffp == NULL){
		system_mess_proc(1,"print: Temporary header file cannot be opened!");
		stop = 1;
		return;
	}
	/* first line of header */
	fprintf(ffp,"%s,cl=%d,mo=%d,pd=%d,xd=%d,fd=%d,pj=[%s,%s]\n",
		title_label, ds_class,model,param_dim, var_dim,func_dim,
		all_label[ix], all_label[iy]);
	if(print_region==1 || print_region==2){
		/* second line of a header */
		sprintf(line,"P=[");
		strcpy(line2,line);
		if(!large_system_on){
			for (i=0;i<param_dim;i++) {
				sprintf(line,"%s%lg,",line2, param[i]);
				if((int) strlen(line) > 100){
					sprintf(line2,"%s,...",line);
					fprintf(ffp,"%s\n",line2);
					sprintf(line,"");
					break;
				}
				else {
					strcpy(line2,line);
				}
			}
		}
		else {
			/* handle large system case */
		}
		sprintf(line, "%s]",line2);
		fprintf(ffp,"%s\n",line);

		/* line 3 of a header */
		sprintf(line,"Wx=[");
		strcpy(line2,line);
		if(!large_system_on){
			for (i=0;i<var_dim;i++) {
				sprintf(line,"%s%lg,",line2,win_var_i[i]);
				if((int) strlen(line) > 100){
					sprintf(line2,"%s,...",line);
					fprintf(ffp,"%s\n",line2);
					sprintf(line,"");
					break;
				}
				else
					strcpy(line2,line);
			}
		}
		else {
			/* handle the large system case */
		}
		sprintf(line,"%s]",line2);
		fprintf(ffp,"%s\n",line);

		/* line 4 of a header */
		fprintf(ffp,"nd=%d,it=[%d,%d,%d],dt=%lg,pol_sec=%d,sec_idx=%d,sec_c=%lg,int_op=%d\n",
			n_displayed_data1,i_start,i_max,i_step,time_step,
			polar_section,section_index,section_constant,linear_interpolation);
	}
	else if(print_region==0){
		/* line 4 of a header */
		fprintf(ffp,"nd=%d,it=[%d,%d,%d],dt=%lg,pol_sec=%d,sec_idx=%d,sec_c=%lg,int_op=%d\n",
			n_displayed_data1,i_start,i_max,i_step,time_step,
			polar_section,section_index,section_constant,linear_interpolation);
	}
	else {
		system_mess_proc(1,"This region index is not valid!");
		stop = 1;
		return;
	}
	fclose(ffp);

	sprintf(lstring,"(%s < %s/tmp.print%d | %s -x %lg %lg -y %lg %lg -f %s/tmp.header%d | %s -g ; echo Print %d queued.) &",
		preproc_label,dir_name,print_count,graph_label, xtmin,xtmax,ytmin,ytmax,dir_name,print_count,lpr_label, print_count);

	if(print_region==0) {
		sprintf(lstring2,"Printing param space [job=%d] ...\n",print_count);
		system_mess_proc(0,lstring2);
	}	
	else if(print_region==1){
		sprintf(lstring2,"Phase space print [job=%d] start...\n", print_count);
		system_mess_proc(0,lstring2);
	}
	else if(print_region==2){
		sprintf(lstring2,"Aux space [%d] print [job=%d] start...\n",aux_win_i,print_count);
		system_mess_proc(0,lstring2);
	}
	if(system(lstring) == 127){
		sprintf(lstring2,"Shell cannot be executed!");
		system_mess_proc(1,lstring2);
		return;
	}
}
