/*
### create a help window ###
*/

#include <suntool/sunview.h>
#include <suntool/textsw.h>
#include <suntool/panel.h>

void create_help_windows()
{
	void help_quit_proc(),help_option_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,help_frame;
	extern Panel help_panel;
	extern Textsw help_textsw;
	extern Textsw_status help_status; 
	extern Pixfont *boldfont;
	extern Panel_item help_quit_item,help_option_item;
	extern short help_panel_show;
	extern int panel_colormap_on;
	extern int help_option;
	extern char string[],help_dir[];
	
	/* Turn on the flag */	
	if(help_panel_show){
		window_set(help_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		help_panel_show = 1;

	px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH)/2;
	py = (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) /2;
	/* Create help frame */
	help_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    "help",
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_HEIGHT, 400,
		WIN_WIDTH, 650,
		WIN_FONT, boldfont,
		0);
	if(help_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		help_panel_show = 0;
		return;
	}
	/* Create Panel */
	help_panel = window_create(help_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(help_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_help_windows();
		return;
	}
	/* Create panel items */
	help_quit_item= panel_create_item(help_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(help_panel, "Quit", 4, boldfont),
		PANEL_NOTIFY_PROC, help_quit_proc,
		0);
	help_option_item= panel_create_item(help_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Topic: ",
		PANEL_CHOICE_STRINGS,
			"About kaos",
			"Mouse usage",
			"Using Function Keys",
			"Demonstration Examples",
			"Getting familiar with Sunview panel items",
			"kaos panels",
			"Command line arguments",
			"kaos data format",
			"Batching jobs",
			"Printing",
			"Interrupt",
			"Rescaling a box size",
			"Description of built-in dynamical systems",
			0,
		PANEL_VALUE, help_option,
		PANEL_NOTIFY_PROC, help_option_proc,
		0);

	window_fit_height(help_panel);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(help_panel,WIN_PIXWIN),"help_panel_cms");

        sprintf(string,"%s/online_help.0",help_dir);
        help_textsw = window_create(help_frame, TEXTSW,
		0);
	if(help_textsw == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_help_windows();
		return;
	}
	window_set(help_textsw,
                TEXTSW_STATUS, &help_status,
                TEXTSW_FILE,string,
                TEXTSW_FIRST,0,
                0);
        if(help_status == TEXTSW_STATUS_CANNOT_OPEN_INPUT){
                sprintf(string,"Help file (%s/%d) does not exist!\n",help_dir,help_option);
                system_mess_proc(1,string);
        }       
	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(help_textsw,WIN_PIXWIN),"help_textsw_cms");
}
