/*
Compute Jacobian and value of nonlinear eq (f^r(x) - x - xoffset)
by finite difference method
-----------------------------
NOTE:	nonlinear equations are not handled in periodic coords
Input:	r=period of an orbit, n=phase space dimension,
	x[n],x2[n] = coords of two current guesses
Output:	alpha[n][n]=DF(x) (Jacobian), beta[n]=F(x)
*/

void usrfun3(x,x2,alpha,beta,r,n)
double *x,*x2,**alpha,*beta;
int r,n;
{
	int i,k;
	extern int enable_period;
	extern double time,*t_va,*t_vf,*xoffset;

	/* time is set to 0: Fix this later for other problems */
	time = 0;
	/* xoffset need to be installed later */
	for(i=0;i<n;i++) xoffset[i] = 0;

	/* F(x) */
	for(i=0;i<n;i++) t_vf[i] = x[i];
	fode_user(t_vf,time,r,n);
	/* solve F(x)=0 if r=0 otherwise x(r * T + t) - x(t) */
	if(r==0)
		for(i=0;i<n;i++) t_va[i] = t_vf[i] - xoffset[i];
	else
		for(i=0;i<n;i++) t_va[i] = t_vf[i] - x[i] - xoffset[i];

	/* DF(x) by finite difference */
	for(k=0;k<n;k++){
		for(i=0;i<n;i++) t_vf[i] = x[i];
		t_vf[k] = x2[k];
		/* r=0: t_vf= f(x), r>=1: t_vf = t_vf(time+T*r) */
		fode_user(t_vf,time,r,n);
		/* For equilibrium, dist = f(x) = 0 */
		if(r==0) {
			/* no offset */
		}
		/* For periodic orbits, dist = f^r(x) - x - xoffset */
		else {
			for(i=0;i<n;i++){
				if(i==k)
					t_vf[i] -= (x2[i] + xoffset[i]);
				else
					t_vf[i] -= (x[i] + xoffset[i]);
			}
		}
		for(i=0;i<n;i++) alpha[i][k] = (t_vf[i]-t_va[i])/(x2[k]-x[k]);
	}

	for(i=0;i<n;i++)beta[i]=t_va[i];
}
