/*
----------------------------------------------------------------------
     Compute a set of manifolds for saddle equilibria of ODE
----------------------------------------------------------------------
     compute manifolds of ANY given set of hyperbolic fixed points
     with eigenvalues and eigenvectors
     iskip : number of skips between each data
Input:	sevec[n][n]: eigenvectors for n eigenvalues
	seval[n]: eigenvalues of an equilibrium
	xe[n]: coords of an equilibrium
	mu: # of maximum steps along unstable manifold
	ms: # of maximum steps along stable manifold
	muf : # of finer division of the unstable manifold
	msf : # of finer division of the stable manifold
	iskip: # of skips before drawing
	delman: initial distance from an equilibrium 
	n: phase space dimension
	r: unused, always set to 0 within the subroutine (kept to retain the
	same syntax as trkman_map.c)
----------------------------------------------------------------------
NOTE:	-Only works for r=0; (equilibrium point of ODE)
	-Internal variable: man_index: -1=complex, 0=unstable, 1=stable
----------------------------------------------------------------------
*/
#include "../include/x11r2_kaos_def.h"

#define RK4 1	/* Runge-Kutta integrator */
#define DELFRAC 0.1
void trkman_ode(sevec,seval,xe,r,ms,mu,msf,muf,iskip,delman,n)
int r,ms,mu,msf,muf,iskip,n;
double **sevec,**seval,*xe,delman;
{
	int i,ic,jc,mc,mend,man_index,icnt,color;
	double fabs(),t_step,delx,*x,*xp,*x1,*x2,*dvector();
	extern int stop,int_algorithm,dot_size;
	extern double time,time_step;
	extern char string[];

	r=0; /* r should be 0 */
	x1 = dvector(0,n-1);
	x2 = dvector(0,n-1);
	x = dvector(0,n-1);
	xp = dvector(0,n-1);

	for(ic=0;ic<n;ic++){	
		if(seval[ic][1]!=0) /* if complex eigenvalue quit*/
			man_index = -1;
		else {
			if(seval[ic][0]>0){
				man_index = 0;
				color = Blue;
			}
			else {
				man_index = 1;
				color = Red;
			}
		}
		if(man_index== 0){
			t_step = time_step/muf; /* temporary time step */
			mend = mu * muf;
		}
		else if(man_index == 1){
			t_step = - time_step/msf;
			mend = ms * msf;
		}

		sprintf(string,"Computing manifold for ev[%d]...",ic);
		printf("%s\n",string);
		printf("(Ev=%g %g)\n",seval[ic][0],seval[ic][1]);
		printf("(Evec %d =%g %g)\n",ic,sevec[ic][0],sevec[ic][1]);

		for(jc=0;jc<2;jc++){
			if(man_index==0){
				printf("Unstable manfold for ev[%d]...\n",ic);
			}
			else if(man_index==1){
				printf("Stable manfold for ev[%d]...\n",ic);
			}
			if(jc==0){
				for(i=0;i<n;i++) x[i] = xe[i]+delman*sevec[ic][i];
			}
			else {
				for(i=0;i<n;i++) x[i] = xe[i]-delman*sevec[ic][i];
			}
			icnt=0;
			for(mc=0;mc<mend;mc++){
				for(i=0;i<n;i++){
					delx=(x[i]-xp[i])/seval[ic][0];
					x2[i]=x[i]+delx;
					x1[i]=x1[i]- DELFRAC*delx;
				}
				/*use Runge-Kutta 4th order */

				int_onestep(x1,x2,x,&time,t_step,n,RK4);
				for(i=0;i<n;i++){
					xp[i] = x[i];
					x[i] = x1[i];
				}

				if((icnt % iskip)==0){
					(void) draw_record_pwf(x1,color,-1,dot_size,0,1);
				}
				icnt++;
				if(stop){
					goto done;
				}
			}
		}
	}
done:
	(void) free_dvector(x1,0,n-1);
	(void) free_dvector(x2,0,n-1);
	(void) free_dvector(x,0,n-1);
	(void) free_dvector(xp,0,n-1);
}
