/* Order eigenvalues in decreasing order in magnitude */
#include "../modellib/class_kaos_def.h"

#define DELTAX 1.e-7
fp_get_evinfo(type,eval,evec,x,r,n)
int *type,r,n;
double **eval,**evec,*x;
{
	int i,j,*iv1,*ivector(),ierr;
	double fabs(),sqrt(),**alpha,*beta,*x2,*dvector(),**dmatrix();
	double *eval_r,*eval_i,**evectors,*fv1,**a;
	extern int model,mapping_on,fderiv_on;

	x2 = dvector(0,n-1);
	beta = dvector(0,n-1);
	alpha = dmatrix(0,n-1,0,n-1);
	eval_r = dvector(1,n);
	eval_i = dvector(1,n);
	evectors = dmatrix(1,n,1,n);
	a = dmatrix(1,n,1,n);
	iv1=ivector(1,10000);
	fv1 = dvector(1,10000);

	for(i=0;i<n;i++) x2[i] = x[i]+DELTAX;
	if(mapping_on){
		if(fderiv_on){
			usrfun(x,alpha,beta,r,n);
		}
		else{
			usrfun2(x,x2,alpha,beta,r,n);
		}
		/* need this since alpha = D(f^r(x)-x) = Df^r(x) - I */
		for(i=0;i<n;i++) alpha[i][i] += 1.;
	}
	else {
		usrfun3(x,x2,alpha,beta,r,n);
	}
	if(n==1){
		eval[0][0] = alpha[0][0];
		eval[0][1] = 0;
		evec[0][0] = 1;
	}
	else {
		for (i=0;i<n;i++)
		  for (j=0;j<n;j++)
		     a[i+1][j+1] = alpha[i][j];
		ierr=rg(n,n,a,eval_r,eval_i,1,evectors,iv1,fv1);
		for(i=0;i<n;i++){
			eval[i][0] = eval_r[i+1];
			eval[i][1] = eval_i[i+1];
			for(j=0;j<n;j++)
			   evec[i][j] = evectors[i+1][j+1];
		}
	}

	/* get a type of a periodic orbit from eigenvalues */
	fp_get_type(type,eval,n);

	(void) free_dvector(eval_r,1,n);
	(void) free_dvector(eval_i,1,n);
	(void) free_dvector(fv1,1,n);
	(void) free_imatrix(iv1,1,n);
	(void) free_dmatrix(evectors,1,n,1,n); 
	(void) free_dmatrix(a,1,n,1,n); 
	(void) free_dvector(beta,0,n-1);
	(void) free_dvector(x2,0,n-1);
	(void) free_dmatrix(alpha,0,n-1,0,n-1);
}
