/*
### Driver for computing periodic orbits of a given period ###

Note: All computation in primary coordinates
*/

#include "../modellib/class_kaos_def.h"

fp_compute()
{
	int i,j,k,kc,n,color,fp_type,s_type,ndid,duplicate_found;
	static int ii=1;
	double fabs(),sum,xerr,time,*x1,*x2,*xt,*xo,**evec,**eval,*dvector(),**dmatrix();
	extern int stop,var_dim,ir,symbol_size,fp_show_toggle,fp_display_option,fp_go_option,fp_algorithm,polar_coord,sqzex_maxsq;
	extern int cur_color,polar_coord,mapping_on,model,enable_period;
        extern int n_stored_fp,mdim_fp,mdim_fp_init,mdim_fp_crit,mdim_fp_step,n_mc,sqzex_maxsq,fi_maxsq;
	extern double mc_eps,sqzex_eps,sqzex_epsf,*period_len,*win_var_i,*all_max,*all_min,*param;
        extern char string[],string2[];
	extern int *fp_period;
	extern double **fp_x,***fp_eval,***fp_evec,*fp_xerr;
	extern int (*f_p)();

        
	stop = 0;
	n=var_dim;
	x1 = dvector(0,n-1);
	x2 = dvector(0,n-1);
	xt = dvector(0,n-1);
	xo = dvector(0,n-1);
	eval = dmatrix(0,n-1,0,1);
	evec = dmatrix(0,n-1,0,n-1);

	/* ir: period of an orbit */
        if(fp_go_option==0){
                n_mc=1;		/* # of Newton try = 1 using a Mouse input*/
        }

	if(!mapping_on) {
		if(ir !=0) {
			system_mess_proc(1,"Period>0 not implemented yet! Set period=0.");
			ir = 0;
		}
	}
	else {
		if(ir ==0){
			system_mess_proc(1,"Period=0 is not acceptable. Change period in the periodic orbit window (Period>0).");
			goto done;

		}
	}
	sprintf(string,"Period=%d",ir);
	system_mess_proc(0,string);

        /* Monte Carlo computation of all fixed points */

	srandom(ii++);
	if(fp_algorithm==0)
		system_mess_proc(0,"Starting Monte-Carlo Newton search...");
	else
		system_mess_proc(0,"Starting Monte-Carlo Secant search...");
	for(kc=0;kc<n_mc;kc++){
		/* get initial conditions from windows */
		if(fp_go_option == 0){
			for(i=0;i<n;i++) x1[i] = win_var_i[i];
		}
		else {
			for(i=0;i<n;i++){
				x1[i] = (double) (random() & 0777777) / 0777777;
				x1[i] = all_min[i] + x1[i] * (all_max[i] - all_min[i]);
			}
		}
		/* all computation in enclidean coords */
		from_window_variables(xo,x1,polar_coord);

		if(fp_algorithm==0){
			mnewt(xo,sqzex_maxsq,n,ir,sqzex_eps,sqzex_epsf,&xerr,&ndid);
		}
		else {
			msecant(xo,sqzex_maxsq,n,ir,sqzex_eps,sqzex_epsf,&xerr,&ndid);
		}
		if(stop==1){
			goto done;
		}
		if(xerr < sqzex_eps) {
			for(i=0;i<n;i++) x1[i] = xo[i];
			/* eliminate duplicates */
			duplicate_found=0;
			for(k=0;k<n_stored_fp;k++) {
				for(i=0;i<n;i++)xt[i] = x1[i] - fp_x[i][k];
				if(enable_period)
					dist_periodic(x2,xt,n);
				else
					for(i=0;i<n;i++)x2[i] = xt[i];
					
				sum =0;
				for(i=0;i<n;i++) sum += fabs(x2[i]);
				if(sum < mc_eps) {
					duplicate_found=1;
					break;
				}
				/* test for other members of a periodic orbit*/
				if(mapping_on) {
					for(i=1;i<ir;i++){
						(int) f_p(x2,1,x1,param,time,n);
						for(j=0;j<n;j++) x1[j] = x2[j];
						for(j=0;j<n;j++)xt[j] = x1[j] - fp_x[j][k];
						if(enable_period)
							dist_periodic(x2,xt,n);
						else
							for(i=0;i<n;i++)x2[i] = xt[i];
						sum =0;
						for(j=0;j<n;j++) sum += fabs(x2[j]);
						if(sum < mc_eps) {
							duplicate_found=1;
							break;
						}
					}
					if(duplicate_found)
						break;
				}
				else {
					/* ode version need to be installed */
				}
			}

			if(duplicate_found){
        			/* Print distinguished fixed points */
				printf("Dup PO: Per=%d NDid=%d X=(",ir,ndid); 
				for(i=0;i<n;i++) printf("%g,",xo[i]);
				printf("),Err=%g\n",xerr); 
			}
			else {
        			/* Print distinguished fixed points */
				printf("New PO: Per=%d NDid=%d X=(",ir,ndid); 
				for(i=0;i<n;i++) printf("%g,",xo[i]);
				printf("),Err=%g\n",xerr); 
				/* record data */
				for(i=0;i<n;i++) fp_x[i][n_stored_fp]=xo[i];
				fp_xerr[n_stored_fp] = xerr;
				fp_period[n_stored_fp] = ir;
				if(n_stored_fp >= mdim_fp-1) {
					if(mdim_fp < mdim_fp_crit)
						mdim_fp *= 2;
					else
						mdim_fp += mdim_fp_step;
					realloc_fp_data();
				}

				(void) cycle_color(&cur_color);
				(void) draw_record_pwf(xo,cur_color,4,5,1,0);
				(void) draw_record_pwf(xo,cur_color,4,5,1,0);
				if(fp_display_option==1){
					/* record_on = 0: do not record
					copies of a periodic orbit */
					if(ir>1) {
						for(i=0;i<n;i++) x1[i] = xo[i];
						(void) draw_record_other_pwf(x1,ir,cur_color,4,5,1,0);
						for(i=0;i<n;i++) x1[i] = xo[i];
						(void) draw_record_other_pwf(x1,ir,cur_color,4,5,1,0);
					}
				}

				/* get eigen info */
				fp_get_evinfo(&fp_type,eval,evec,xo,ir,n);
				/* record all eigenvalues */
				for(i=0;i<n;i++){
					for(j=0;j<2;j++) fp_eval[i][j][n_stored_fp] = eval[i][j];
				}

				/* record only saddle eigenvectors only (temporary)*/
				if(fp_type==0){
					for(i=0;i<n;i++){
						for(j=0;j<n;j++) fp_evec[i][j][n_stored_fp] = evec[i][j];
					}
				}
				/* get label, color and symbol_type for each
				fixed point type */
				fp_get_attributes(string,&color,&s_type,fp_type);
				(void) draw_record_pwf(xo,color,s_type,symbol_size,1,0);
				if(fp_display_option==1){
					/* record_on = 0: do not record
					copies of a periodic orbit */
					if(ir>1) {
						for(i=0;i<n;i++) x1[i] = xo[i];
						(void) draw_record_other_pwf(x1,ir,color,s_type,symbol_size,1,0);
					}
				}

				printf("   Type=%s,EVal=",string);
 				for(j=0;j<n;j++) printf(" (%g, %g)",fp_eval[j][0][n_stored_fp],fp_eval[j][1][n_stored_fp]);
				printf("\n");
				/* reset panel_item */
				for(j=0;j<n;j++) x1[j]=fp_x[j][n_stored_fp];
 				to_window_variables(win_var_i,x1,polar_coord);
				n_stored_fp++;
			}

		}
		else {
			printf("Bad PO: Per=%d NDid=%d,Err=%g\n",ir,ndid,xerr);
		}
		cur_color++;
	}

done:
	system_mess_proc(0,"Done!");
	(void) free_dvector(x1,0,n-1);
	(void) free_dvector(x2,0,n-1);
	(void) free_dvector(xt,0,n-1);
	(void) free_dvector(xo,0,n-1);
	(void) free_dmatrix(eval,0,n-1,0,1);
	(void) free_dmatrix(evec,0,n-1,0,n-1);
}
