/*
### create a dimension window ###
*/

#include <suntool/sunview.h>
#include <suntool/panel.h>

void create_dims_windows()
{
	void dims_quit_proc(),dims_go_proc(),dims_analyze_proc();
	void dims_type_option_proc(),dims_algorithm_option_proc();
	int i,ipanel_row=0,px,py;
	extern Frame frame,dims_frame,tser_frame;
	extern Panel dims_panel;
	extern Pixfont *boldfont;
	extern Panel_item dims_quit_item,dims_go_item,dims_analyze_item;
	extern Panel_item dims_type_option_item,dims_algorithm_option_item;
	extern Panel_item dims_scale_max_item,dims_scale_factor_item;
	extern Panel_item dims_lsf_start_item,dims_lsf_end_item;
	extern short dims_panel_show,tser_panel_show;
	extern int panel_colormap_on;
	extern int dims_type_option,dims_algorithm_option;
	extern int dims_lsf_start,dims_lsf_end;
	extern int dims_scale_max;
	extern double dims_scale_factor;
	extern char string[];
	
	/* Turn on the flag */	
	if(dims_panel_show){
		window_set(dims_frame,WIN_SHOW,TRUE,0);	
		return;
	}
	else
		dims_panel_show = 1;

	if(tser_panel_show){
		px = (int) window_get(tser_frame,WIN_X);
		py = (int) window_get(tser_frame,WIN_Y) + (int) window_get(tser_frame,WIN_HEIGHT) +100;
	}
	else {
		px = (int) window_get(frame,WIN_X) + (int) window_get(frame,WIN_WIDTH)/2;
		py = (int) window_get(frame,WIN_Y) + (int) window_get(frame,WIN_HEIGHT) /2 +100;
	}
	/* Create tser frame */
	dims_frame = window_create(frame,FRAME,
		FRAME_NO_CONFIRM,       TRUE,
		FRAME_LABEL,    "dimensions",
		FRAME_SHOW_LABEL,       TRUE,
		WIN_SHOW,       TRUE,
		WIN_X,  px,
		WIN_Y,  py,
		WIN_FONT, boldfont,
		0);
	if(dims_frame == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		dims_panel_show = 0;
		return;
	}
	/* Create Panel */
	dims_panel = window_create(dims_frame, PANEL,
		WIN_X, 0,
		WIN_Y, 0,
		WIN_FONT, boldfont,
		0);
	if(dims_panel == NULL) {
		system_mess_proc(1,"No more windows. Clean up some windows to make room.");
		(void) destroy_dims_windows();
		return;
	}
	/* Create panel items */
	dims_quit_item= panel_create_item(dims_panel, PANEL_BUTTON,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_LABEL_IMAGE, panel_button_image(dims_panel, "Quit", 5, boldfont),
		PANEL_NOTIFY_PROC, dims_quit_proc,
		0);
	dims_go_item= panel_create_item(dims_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(dims_panel, "Go", 5, boldfont),
		PANEL_NOTIFY_PROC, dims_go_proc,
		0);
	dims_analyze_item= panel_create_item(dims_panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(dims_panel, "Analyze", 7, boldfont),
		PANEL_NOTIFY_PROC, dims_analyze_proc,
		0);
	dims_type_option_item= panel_create_item(dims_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Type: ",
		PANEL_CHOICE_STRINGS,
			"Fractal dimension",
			"Correlation exponent",
			"Information dimension",
			"Pointwise dimension",
			"User dimension",
			0,
		PANEL_VALUE, dims_type_option,
		PANEL_NOTIFY_PROC, dims_type_option_proc,
		0);
	dims_algorithm_option_item= panel_create_item(dims_panel, PANEL_CYCLE,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		PANEL_LABEL_STRING, "Algorithm: ",
		PANEL_CHOICE_STRINGS,
			"Box algorithm",
			"User algorithm A",
			"User algorithm B",
			0,
		PANEL_VALUE, dims_algorithm_option,
		PANEL_NOTIFY_PROC, dims_algorithm_option_proc,
		0);

	sprintf(string, "%d", dims_scale_max);
	dims_scale_max_item = panel_create_item(dims_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_LABEL_STRING, "# Scaling:",
		0);
	sprintf(string, "%lg", dims_scale_factor);
	dims_scale_factor_item = panel_create_item(dims_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 9,
		PANEL_LABEL_STRING, "Scale Factor:",
		0);

	sprintf(string, "%d", dims_lsf_start);
	dims_lsf_start_item= panel_create_item(dims_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_LABEL_STRING, "LSF Start:",
		0);
	sprintf(string, "%d", dims_lsf_end);
	dims_lsf_end_item = panel_create_item(dims_panel, PANEL_TEXT,
		PANEL_LABEL_Y, ATTR_ROW(ipanel_row++),
		PANEL_LABEL_X, ATTR_COL(0),
		PANEL_VALUE, string,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_LABEL_STRING, "LSF End:",
		0);
	window_fit(dims_panel);
	window_fit(dims_frame);

	if(panel_colormap_on)
		init_panel_colormap((Pixwin *) window_get(dims_panel,WIN_PIXWIN),"dims_panel_cms");
}
