/*
### 3-dim array memory allocation ###
*/

double ***dtmatrix(nvl,nvh,nrl,nrh,ncl,nch)
int nvl,nvh,nrl,nrh,ncl,nch;
{
	int i,j,k;
	double ***m;
	void free_vtmatrix();

	m = (double ***) malloc((unsigned) (nvh - nvl + 1) * sizeof(double **));
	if(!m) {
		system_mess_proc(1,"dtmatrix: memory allocation failure.");
		return(0);
	}
	else {
		m -= nvl;
	}
	
	for(i=nvl;i<=nvh;i++){

		m[i] = (double **) malloc((unsigned) (nrh - nrl + 1) * sizeof(double *));
		if(!m[i]) {
			system_mess_proc(1,"dtmatrix: memory allocation failure.");
			free_dtmatrix(m,nvl,i-1,nrl,nrh,ncl,nch);
			return(0);
		}
		else {
			m[i] -= nrl;
		}
	
		for(j=nrl;j<=nrh;j++){
			m[i][j] = (double *) malloc((unsigned) (nch - ncl + 1) * sizeof(double));
			if(!m[i][j]) {
				system_mess_proc(1,"dtmatrix: memory allocation failure.");
				for(k=nrl;k<j;k++) {
					free(m[i][k]+ncl);
				}
				free(m[i]+nrl);
				free_dtmatrix(m,nvl,i-1,nrl,nrh,ncl,nch);
				return(0);
			}
			else {
				m[i][j] -= ncl;
			}
		}
	}
	return(m);
}
