


MinneView(l)        Geometry Center Programs         MinneView(l)



NAME
     MinneView - interactively display geometry

SYNOPSIS
     MinneView [ +-a (concave) ] [ +-b (bbox) ] [ +-d (debug) ] [
     +-e  (edges)  ]  [  +-f  (faces)  ]  [  -g groupfile ] [ ] [
     -i {r|t|z}] [ -i {l|k}] [ -l lightfile ] [ -m materialfile ]
     [  +-n  (flip  normals) ] [ -s {0|1|2} (shading) ] [ -w xmin
     xmax ymin ymax ] [ -# {0|1|2}(normalization) ]  [ -B { back-
     groundimage  |  R,G,B} ] [ -D meshsize ] [ -F fullscreen ] [
     -H {0|1|2}  (Euclidian|Hyperbolic|InHyperbolic)  ]  [  back-
     ground  ]  [  -M sharedmemfile ] [ +-P (draw normals) ] [ -S
     {0|1} (Tektronix stereo|Crosseyed stereo) ] [ -W (free  win-
     dow) ] [ -C camerafile ] [ -E shadingrate ] [ -L lightfile ]
     [ -O objectfile ] [ -R imagefile ] [ -U (render > .tif) ]  [
     -V viewfile ] [ -Z windowsize ] [ model ]

DESCRIPTION
     MinneView is an interactive program to display 3-dimensional
     geometric  objects  on  an  Iris.   Objects  can  be  moved,
     rotated, viewed in stereo, and  rendered  as  wire-frame  or
     solids with a variety of shading models.

     Objects can be supplied in several forms  --  actually,  any
     form  supported  by  the  Object  Oriented  Graphics Library
     (OOGL).

     Major Pixar ChapReyes ASCII disk file formats are  accepted,
     namely  MESHes (rectangular-grid meshes with optional colors
     & normals), QUADs  and  POLYs  (batches  of  quadrilaterals,
     optional colors&normals), and BBPs (bicubic Bezier patches).
     [See   man   5   PR_Format   if   your   MANPATH    includes
     /u/pixar/chreyes/man.]   Some  other object formats may also
     be  read  from  disk  files:  Lincoln  (binary)  format  for
     polyhedral  surfaces,  a BEZuvn extension to BBP's, allowing
     other patch polynomial degrees  and  homogeneous  (rational)
     splines,  a VECT format for collections of points and lines,
     a GROUP format for  a  collection  of  transformations  (4x4
     matrices)  to  be  applied to an arbitrary other object. The
     LIST format is simply a list of objects of any of  the  OOGL
     formats.

     Assorted sample object files live in the data  subdirectory.
     Contributions are welcome.

     Objects can  also  be  imported  from  memory,  shared  with
     another  program  running  on  the  same  Iris.   The  other
     ("client") program constructs an object in shared memory, in
     the  form  expected  by OOGL. MinneView displays the current
     contents of the selected shared memory object, tracking  its
     evolution  as  the  client  program changes it.  You can run
     multiple copies of MinneView for different views of the same



             Last change: $Date: 90/09/14 02:55:39 $            1






MinneView(l)        Geometry Center Programs         MinneView(l)



     object.   Multiple  objects  may  coexist  in  shared memory
     simultaneously.

FEATURES
     MinneView is primarily mouse  driven.   Click-and-drag  with
     left  or  middle  mouse  buttons  (equivalently) control the
     object while the right mouse button selects  menus.   Nearly
     all menu functions can also be invoked with keyboard keys.

     As a preview  of  the  detailed  explanations  below,  major
     features  are  summarized here.  The program is still evolv-
     ing, so some items are liable to change.

     - Movie loops
          If fed multiple disk files, MinneView can display  them
          individually  (selecting  with keyboard or mouse) or in
          sequence, rocking back and forth or looping forward  or
          backward.

     - NTSC video (for videotape recording)
          On Irises (like riemann) with a  genlock  board,  which
          can  run  their displays at NTSC rate (standard TV for-
          mat), MinneView can switch to/from that format and also
          position  the  window to fit in the smaller NTSC screen
          area -- useful for video recording.  The normal display
          is unusable when displaying in NTSC mode.

     - Stereo
          Two stereo modes are provided.  One (preferable)  works
          on  Irises  (like  riemann)  with the Tektronix liquid-
          crystal  shutter   display,   viewed   with   circular-
          polarizing  glasses.  The other works on any Iris -- it
          splits the window, showing a pair  of  images  suitable
          for cross-eyed viewing.

     - Viewfinder
          Besides MinneView's normal state which lets you rotate,
          translate  or  scale the object, there's a "viewfinder"
          mode where a display resembling a  camera's  viewfinder
          is  superimposed  on the object.  In this mode you con-
          trol the camera rather than the object --  its  spatial
          position,  viewing  direction, field-of-view angle, and
          stereo parallax can be adjusted.

     - Hard Copy
          MinneView can save its screen image  as  an  SGI-format
          file.   Tools  are  available  to convert SGI images to
          PostScript, to 3M printer format, and others.

     - Renderman Frames
          MinneView can save its  screen  image  as  a  Renderman
          Interface Bytestream file.



             Last change: $Date: 90/09/14 02:55:39 $            2






MinneView(l)        Geometry Center Programs         MinneView(l)



COMMAND LINE ARGUMENTS
     Brackets [ ] denote optional items and  braces { } denote  a
     required  choice.  -M option), model is the name of the OOGL
     object in shared memory.

     If multiple files names  are  supplied,  MinneView  displays
     each one as it's loaded; it can then be asked to display any
     of them or to  make  an  animation  by  displaying  them  in
     sequence.   This  feature  does  not  work when using shared
     memory.

OPTIONS
     model
          Names one or  more  disk  file(s)  each  containing  an
          object  in  any  of  the  forms  accepted  by  the OOGL
          library, or if shared memory is being used (see the

     -l  lightfile
          Specify files created by medit which determine lighting
          properties (color, brightness and positioning).

     -m  materialfile
          Specify files created by the program medit which deter-
          mine material properties (color, shininess etc.).

          Default material  and  lighting  files  are  read  from
          ~/.medit.mat  and ~/.medit.lgt respectively.  MinneView
          will create these files with reasonable default  values
          if they do not exist.

          Material and lighting files can't be respecified  while
          MinneView  is  running; however, those files are polled
          for changes every time the cursor enters the  MinneView
          window.  Thus you can be running medit, change material
          and lighting parameters, and see the effect immediately
          just by moving the mouse into the MinneView window.

     -w xmin xmax
          Places the initial window at the given  screen  coordi-
          nates.  The window can be later be moved and resized.

     -wxsize,ysize
          Gives the window that size (in  pixels);  the  user  is
          prompted to place it.

     -w xsize,ysize@xmin,ymin
          Places  the  initial  window  at  xmin,ymin  with  size
          xsize,ysize.  Equivalent to -w xmin xmin+xsize-1

          If no -w is specified, MinneView pops up 400x400  pixel
          window  cursor.   Merely clicking & releasing leftmouse
          causes a 400x400 window to appear at that position.   A



             Last change: $Date: 90/09/14 02:55:39 $            3






MinneView(l)        Geometry Center Programs         MinneView(l)



          window  larger than 400x400 can be obtained by pressing
          leftmouse and dragging (downward &  rightward)  to  the
          desired  size,  then  releasing leftmouse.  The initial
          window cannot be made smaller than 400x400,  though  it
          can  still be resized to any size after the real window
          has appeared.

     -B  imagefile
          Displays that file (which must be an SGI-format  image)
          as  the  background  for displayed objects, rather than
          the default pale blue.  This reduces performance signi-
          ficantly  since  the  image  must  be  redrawn for each
          frame.

     -B  red,green,blue
          Sets the MinneView background color.  You supply  three
          numbers  (for red, green, blue) in the range 0..1, e.g.
          -B .3,.2,0 gives dull yellow.

     -M[sharedmemfile]
          Specifies that model is  an  object  to  be  read  from
          shared memory, where it has been or is being created by
          some other application.  That application  specifies  a
          shared  memory "area" for the object (resembling a file
          name,  normally  /tmp/MVmem)  and  a  ``symbol''   name
          attached  to  the  object  (since  multiple objects may
          coexist in a single shared-memory area).

          MinneView polls the shared memory symbol  periodically.
          The  display  tracks  any  changes  which  the creating
          application makes in the shared object.

          To display a shared object,  you  tell  MinneView  that
          it's  in  shared  memory (with -M), which shared-memory
          area to use (since it defaults to /tmp/MVmem, -M  alone
          will do), and the name of the symbol.

          For example, the tutorial program meshsample creates  a
          shared-memory  symbol called mesh.  It uses the default
          /tmp/MVmem  shared-memory  area.   To  make   MinneView
          display  the  evolving mesh, use ``MinneView -M mesh'',
          or equivalently, ``MinneView -M/tmp/MVmem mesh''.

          Movie  looping  is  not  available  when  displaying  a
          shared-memory object; only one object may be specified.

     -N   Enables NTSC mode, on Irises equipped  with  a  Genlock
          board.   This  sets  the  Iris video drivers to produce
          output in the standard television format, suitable  for
          video  recording.   The high-resolution Iris monitor is
          useless while NTSC mode is enabled. MinneView automati-
          cally restores the normal display mode upon exit.



             Last change: $Date: 90/09/14 02:55:39 $            4






MinneView(l)        Geometry Center Programs         MinneView(l)



          Since only the lower left 640x480 pixels of the  screen
          are  displayed in NTSC format, -N also causes MinneView
          to position its window there (unless overridden with  -
          w).

          It's also possible to toggle between  NTSC  and  normal
          display modes while within MinneView.

          If the Iris does not contain a Genlock board, using  -N
          yields a warning message.

     -Wlinewidth


     The other command line options are the same as the  interac-
     tive  keyboard  commands  described  below. The command line
     options are in curly braces on the far right.

RUNNING MINNEVIEW
     When MinneView is first started,  an  image  of  the  object
     appears  in  the  middle of the window.  Rotate the image by
     holding down and dragging with the left mouse button.

     Rotation, translation and  zoom  can  all  give  the  object
     ``inertia.''  As  the  object  is being moved, let go of the
     mouse button while the  mouse  is  still  moving.   The  the
     object  will continue moving until it is directed some other
     way by dragging with the left mouse button.

     The right mouse button calls up a hierarchy of menus.   Each
     of the submenus is described in the following sections.  All
     of the menu items except for  example  files  have  keyboard
     equivalents.   They  are  listed  in  square brackets to the
     right of the item.  Corresponding command line  options  are
     listed  in  curly  braces  to  the  right  of  the  keyboard
     equivalents. Pressing the key is the same as selecting  that
     menu item.

  Top Level Menu
     Status  [=]
          Prints data about the object  being  viewed,  including
          the  object  name, window size, bounding box dimensions
          and data about the transformation.

     Quit  [Q]
          Exits the program.

  Rendering Menu
     These options control the appearance of the object.

     Flip Normals  [n] {+-n}
          Flips the direction of the normals of each  surface  in



             Last change: $Date: 90/09/14 02:55:39 $            5






MinneView(l)        Geometry Center Programs         MinneView(l)



          the  object.  This effects the lighting.  If the object
          appears to be solid or almost solid black, try flipping
          the normals.

     Flip Face Drawing  [f] {+-f}
          Toggles back and forth between drawing the object  with
          and  without  faces.  (If  the  faces are not drawn the
          object is rendered as a wire frame.)  Default  is  face
          drawing on.

     Flip Edge Drawing  [e] {+-e}
          Toggles drawing  the  outlines  of  each  face  of  the
          object.  The edges are drawn with either narrow or wide
          lines depending on how the Wide Lines toggle  was  set.
          Edge drawing is automatically turned on if face drawing
          is turned off.  (Otherwise there would  be  nothing  on
          the  screen.)   Similarly, face drawing is turned on if
          edge drawing is turned off.  Default  is  edge  drawing
          off.

     Flip Bounding Box Drawing  [b] {+-b}
          Toggles between drawing the bounding box and not  draw-
          ing it.  In Euclidean space, the bounding box is a cube
          that bounds  the  object.   In  Hyperbolic  space,  the
          bounding  box  is  the  sphere at infinity.  Default is
          bounding box drawing on.

     The next three options control the  shading  model  used  to
     render the object.

     Constant Shading  [c] {-s 1}
          In the Constant shading mode, the color of each face is
          computed using the position and color of the face along
          with the position and color of the lights.  The  entire
          face is then rendered with that color.  Default is con-
          stant shading.

     Gouraud Shading  [g] {-s 0}
          The color is computed at each vertex of a face and then
          interpolated  across  the face.  This gives a much more
          smooth and realistic rendering of  the  object  at  the
          expense  of  increasing  the time it takes to draw each
          frame.

     Constant Coloring  [C] {-s 2}
          No lighting model is used.  Instead, each face is given
          a  constant  color  that  does not change.  This option
          only works as well as the IRIS hardware, which seems to
          vary with machine and object type.

     Flip Transparent  [T]
          Toggles  between  rendering  the   object   opaque   or



             Last change: $Date: 90/09/14 02:55:39 $            6






MinneView(l)        Geometry Center Programs         MinneView(l)



          partially transparent.  Default is transparent off.

     Flip Hyperbolic  [H] or [{0|1|2} H] {-H[0|1|2]}
          Toggles between rendering the object  in  Euclidean  or
          hyperbolic  space.   Typing  ``2H''  places  you inside
          hyperbolic space and ``H'' leaves you outside of it. In
          both  modes  the  bounding  box  becomes  a  hyperbolic
          sphere. In the Inside Hyperbolic  mode  the  viewfinder
          camera  cannot  leave  the  bounding hyperbolic sphere.
          See also  the  WhereIsIt?   entry  below.   Default  is
          hyperbolic off.

     Wide Lines  [W] or [n W] {-Wn}
          Toggles between using wide or narrow lines when drawing
          edges  and  bounding  boxes.  Wide lines show up better
          when video taping the image.  A number typed before the
          ``W''  specifies the width of the lines.  The lines are
          not anti-aliased.  Default is line width  1  (narrowest
          possible).

     Draw Normals  [+-n B] {+-P}
          Toggle between drawing the object with and without nor-
          mals.  The  normals  are  shown as white lines from the
          object's vertices. The default length of the normals is
          derived  from  the size of the bounding box. The length
          of the normals is scalable:  a  positive  number  typed
          before  the  ``B''  multiplies  the base length by that
          number and a negative number divides the length by that
          number.  For example, ``-5B'' will make the normals 1/5
          as long as they would have been. The width of the lines
          is  controlled  by  the  Wide Lines option.  Default is
          draw normals off.

     Mesh Size  [M] or [n M] {-D n}
          Parametric surface patches (BEZes and BBPs)  are  diced
          up  into  meshes  in  A  number  typed before the ``M''
          specifies the new mesh  size.  Large  mesh  sizes  give
          sluggish performance.

     Full Screen  [F] {-F}
          Toggle the size of the  MinneView  window  between  the
          entire  screen  and  what  it  was previously. If it is
          specified as a command line option the  window  returns
          to  a  400x400  pixel  window  in  the  lower left hand
          corner.  Default is full screen off.

     Cursor Drawing  [x]
          Toggles between drawing the cursor as a red  arrow  and
          leaving it invisible.  Default is cursor drawing on.

     Concave Polygons  [a] {a}
          Toggles between guaranteeing concave polygons are drawn



             Last change: $Date: 90/09/14 02:55:39 $            7






MinneView(l)        Geometry Center Programs         MinneView(l)



          correctly,  which is slower,  and assuming polygons are
          nonconcave,  which  is  faster.   Default  is   concave
          polygons off.

  Viewing Menu
     If MinneView is in the hyperbolic mode,  all  the  following
     transformations  are  hyperbolic  isometries,  not Euclidean
     transformations.

     Rotate  [r]
          After selecting Rotate, dragging the mouse in the  win-
          dow  with  the  left  button  held down will rotate the
          object.  The default mode at the beginning  of  a  Min-
          neView session is rotate.

     Translate  [t]
          After selecting Translate, dragging the  mouse  in  the
          window  with  the  left button held down will translate
          the object.

     Zoom  [z]
          After selecting Zoom, dragging the mouse in the  window
          with  the left button held down will zoom in and out on
          the object.

     View Finder  [v]
          Toggles between normal and view finder mode.

          The view finder divides  the  window  into  five  major
          areas:  One  along  each  side  plus one in the middle.
          Dragging the left mouse button in each of  these  areas
          has  a  different  effect.   Intuitively, the effect is
          that of standing in a long rectangular box, and looking
          out through the narrow end at the scene.

          Each area along the side is a side of  the  box.   When
          you drag the mouse in an area, you are grabbing the box
          you are in and dragging it in a direction  parallel  to
          the  side.  This gives you an intuitive and easily con-
          trolled means of translating the camera position.

          The two lines in the center  of  the  viewport  labeled
          ``L'' and ``R'' are explained in the entry for Stereo.

     Stereo  [s] {-S 0}
          Toggles between displaying the image in stereo and mono
          vision.   A  Tektronix stereoscopic monitor is required
          to view stereo.  Be sure the  LCD  shutter  is  on  the
          screen  and  you  are  wearing  the  special  polarized
          glasses.

          When the screen is switched into the stereo  mode,  the



             Last change: $Date: 90/09/14 02:55:39 $            8






MinneView(l)        Geometry Center Programs         MinneView(l)



          image  is  displayed  in vivid 3-D and all the controls
          and menus work as before.  If the image looks  flat  or
          garbled,  try flipping the Depth Rev switch on the base
          of the monitor.

          Two parameters  can  be  changed  to  control  the  3-D
          effect:  Eye  separation  and the angle of convergence.
          Both can be changed in the viewport  mode  by  dragging
          the two lines labeled ``L'' and ``R.''  The eye separa-
          tion is changed by clicking on the bottom of the  lines
          with  the left mouse button and dragging left or right.
          The convergence angle is changed by clicking on the top
          of  the lines and dragging left or right.  Experimenta-
          tion is usually required to get  the  best  effect  for
          different objects.

     Crosseyed Stereo  [S] {-S 1}
          Toggles between normal  viewing  and  crosseyed  stereo
          mode.   In  crosseyed  stereo  mode,  two images of the
          object are displayed side-by-side.   You  can  see  the
          images in 3-D by looking at the space between the image
          and letting your eyes drift out of  focus  so  the  two
          images merge into one.  This takes some practice.

          The advantage of this option is that  special  hardware
          is  not  required.  The disadvantages are that it takes
          some work to use and the 3-D effect is not as striking.

     Normalize  [#][n#]
          Controls how successive objects (in a  movie  loop,  or
          read from shared memory) are scaled to fit the standard
          unit box.  Sometimes when a new object is  loaded  into
          shared  memory  or  a new example file is selected from
          the menu, the ``size'' of the object may be  wrong  for
          the  window.   Either  the  object will be too small to
          see, or it will seem so big that it won't  fit  on  the
          screen.   The  Normalize item causes MinneView to scale
          the object so it fits comfortably in the window.

     WhereIsIt?  [w]
          Sometimes the object can move past the edge of the win-
          dow  while translating or zooming and be very difficult
          to find again.  Selecting WhereIsIt? cancels all  rota-
          tions,  translations  and zooms and then re-centers the
          object in the middle of the window.

          In hyperbolic mode, this command can position the  cam-
          era  in  one of two different ways depending on how the
          mode was entered.  If the hyperbolic mode  was  entered
          by  typing  ``H'' or selecting Flip Hyperbolic from the
          menu, WhereIsIt? works just as described and the camera
          is positioned outside of the sphere at infinity looking



             Last change: $Date: 90/09/14 02:55:39 $            9






MinneView(l)        Geometry Center Programs         MinneView(l)



          in.  If the  hyperbolic  mode  was  entered  by  typing
          ``2H'', all the transformations are reset as before but
          the camera is positioned in the middle  of  the  sphere
          looking  out. If WhereIsIt? leaves the camera too close
          to the object  upon  returning  to  normal  space  from
          hyperbolic  space, select Normalize and then WhereIsIt?
          .

     Reload Example Files  [X]
          The example files submenu is updated to include any new
          files  that have been entered into the directory speci-
          fied by GEOM_PATH (default data).

  Save Menu
     The items under this menu save data about the current  image
     to  a  file.  This gives the ability to (among other things)
     use MinneView to quickly  set  up  the  transformations  for
     viewing  an  object  in  a particular way and then exporting
     them to a production-quality renderer to  create  the  final
     image.

     Except for the Iris Frame item, all viewing data is  written
     in  .rib  (Renderman Interface Bytestream) format for export
     to a Renderman renderer.

     Composite filenames are used when the item is  invoked  from
     the keyboard or the menu. They are of the form base####.rib,
     where #### starts at 0000 and  is  autoincremented  whenever
     the particular item is selected.  "Base" depends on the par-
     ticular item.  If the item is called from the command line a
     filename must be specified after the flag.

     Rman Frame  [R] {-R imagefile}
          Saves everything about the current frame to a .rib file
          that is complete and ready to render. The base filename
          is MV####.rib.

     Files created by the next 5 items are fragments that can  be
     pieced together to form complete .rib files.

     Rman Lights  [L]  {-L lightfile}
          Saves the current lighting and material information  to
          a  .rib file.  This is the information changed by medit
          from ~/.medit.lgt and ~/.medit.mat

     Rman Camera  [A] {-C camerafile}
          Saves the current camera information to  a  .rib  file.
          The  field-of-view,  changable from the viewfinder, and
          the frame aspect ratio, determined by the size  of  the
          MinneView  window, are saved here.  The Rman Windowsize
          item  is  also  saved  here.   The  base  filename   is
          cam####.rib.



             Last change: $Date: 90/09/14 02:55:39 $           10






MinneView(l)        Geometry Center Programs         MinneView(l)



     Rman Transform  [V] {-V viewfile}
          Saves the current viewing transform  to  a  .rib  file.
          The  viewing  transform  is a 4x4 matrix that specifies
          all of the rotations, translations and zooms,  and  all
          viewfinder  changes  except  for field-of-view, from an
          interactive MinneView session.  The  base  filename  is
          transform####.rib.

     Rman Object  [O] {-O objectfile}
          Saves the OOGL object(s) in the current frame to a .rib
          file.  The base filename is object####.rib.

     Rman Header  [G] {-G headfile}
          Saves the current header information to  a  .rib  file.
          The Rman Shadingrate and the Rman display as .tif items
          are saved here.  The base filename is head####.rib.

     Rman Shadingrate  [nE] {-E n}
          Shadingrate is the  number  of  pixels  that  Renderman
          shades  at  once.  Small values from around .25 to 10.0
          yield precise pictures but increase the rendering time.
          Large values from around 64.0 to 256.0 give cruder pic-
          tures but greatly  improve  the  rendering  time.   The
          default is 1.0.

     Rman Windowsize  [nZ] {-Z n}
          The Rman Windowsize  item  controls  the  size  of  the
          Renderman  window, which is constrained by the shape of
          the MinneView window. The number supplied is used as  a
          base  -- if the frame aspect ratio is >= 1.0 the window
          is number*ratio x number pixels. If  the  frame  aspect
          ratio is < 1.0 the window is number x number/ratio pix-
          els.  Note that the bigger the  window  the  longer  it
          takes to render.  The default value is 256 pixels.

     Rman display as .tif [U]  {U}
          The default  is  off.  "Render  <filename>"  will  then
          render  directly to the screen. If Rman display as .tif
          is on, the image will be rendered  into  a  .tif  file,
          which  can be quickly displayed with the command tiffgt
          or sent  to  a  video  recorder.   Rendering  can  take
          minutes for simple pictures and hours for complex ones.
          A  file  named  base.rib  will  produce  a  file  named
          base.tif.

     Draw Background  [K] {K}
          The background in the Renderman file is actually a  big
          patch  painted  the  background  color  (default blue).
          Draw Background toggles between including this patch in
          the  Renderman  file  and leaving it out, which gives a
          black background. A .tif background image can be merged
          with the Renderman .tif image if the patch is left out.



             Last change: $Date: 90/09/14 02:55:39 $           11






MinneView(l)        Geometry Center Programs         MinneView(l)



     Iris Frame > MV.sgi  [I]
          Dumps an image of the window in SGI format to the  file
          MV.sgi.   This  image  can be displayed with the ipaste
          command on an Iris.

  Looping Menu
     This menu only appears if multiple files were listed as com-
     mand line arguments to MinneView.  It is used to control the
     looping through the different objects to produce  an  anima-
     tion.

     Stop  [h]
          Stops flipping through the different objects.

     Loop  [l]
          Loop  through  each  object,  creating  an   animation.
          Starts  over with the first object when the last object
          is reached.

     Rock  [k]
          Loop  through  each  object,  creating  an   animation.
          Repeats  the sequence of flipping from the first object
          to the last and then backwards from  the  last  to  the
          first.

     Mouse  [m]
          Causes the frame shown to be controlled by the dragging
          with the left mouse button.

     Step Forward
          Single-step forward to the next object.

     Step Backwards
          Single-step backwards to the previous object.

     Faster
          Increase the speed of the looping.

     Slower
          Decrease the speed of the looping.

  Example Files Menu
     This menu is a list of sample geometry files.  Selecting one
     will bring that item onto the screen.

     MinneView will search for these files in the directory  data
     unless  the  environment  variable  GEOM_PATH is defined, in
     which case it will look in the directory named by that vari-
     able.

BUGS




             Last change: $Date: 90/09/14 02:55:39 $           12






MinneView(l)        Geometry Center Programs         MinneView(l)



     Parametric surface patches are incorrectly shaded on  Irises
     running TurboGraphics (like fenchel).

AUTHORS
     MinneView was originally written by Pat Hanrahan.  Extensive
     additions were made by other members of the Geometry Comput-
     ing Group, especially by Stuart  Levy,  Charlie  Gunn,  Mark
     Meuer, and Tamara Munzner.

     This manual page was written by Stuart Levy and  Mark  Meuer
     and updated by Tamara Munzner and Mark Phillips.

SEE ALSO
     medit (1) - a  program  for  controlling  the  material  and
     lighting properties.

     stuff (1) - a program for writing objects into shared memory
     so MinnView can display them

     render (1) - the command to display Renderman files.

     A Guide to Using MinneView and OOGL - Gives an  overview  of
     the Object Oriented Graphics Library that MinneView is built
     on and explains how to write shared memory programs  to  run
     with MinneView.

     MinneView and Renderman - Notes on differences  between  the
     MinneView  image and the Renderman image.  Also notes on how
     to make videotapes using MinneView and Renderman.

     OOGLformats - A reference on OOGL file formats.
























             Last change: $Date: 90/09/14 02:55:39 $           13



