/*
 * Uses "stuff" to send a binary-format QUAD object to MinneView.
 *
 * For visible results, run
 *   MinneView -M itt &
 * while this program is running.
 *
 * To display (in ASCII format) the object placed in shared memory, use
 *   stuff -o itt
 *
 * For details of binary formats for other OOGL objects, see the
 * "oogl.man" document or "man 5 oogl".
 */

#include <stdio.h>
#include <math.h>

/*
 * struct cvert has the arrangment of a binary-format CQUAD vertex.
 * The fields are ordered just as in the ASCII format:
 * first the space coordinates, then the four-component color.
 * Note that all are floats, not doubles.
 */
struct cvert {
    float x,y,z;
    float r,g,b,a;
};

main()
{
    int i, N=1000;
    int k;
    double t=0.0, dt= 0.1;
    FILE *f;
    struct cvert cquad[4];

    f = popen("stuff itt", "w");

    for(i=1 ; i < N ; i++)
    {
	fprintf(f, "CQUAD BINARY\n");

	/* This CQUAD object contains two quads, so */
	/* write the integer 2 before all the quad data. */
	putw(2, f);

	/*
	 * Prepare a quad structure.
	 *
	 * There's no equivalent to putw() for float's, so we must load
	 * them into some sort of array or structure, then fwrite() that
	 * out.  Writing large chunks is more efficient, which is
	 * probably the point of using binary format anyway.
	 */
	cquad[0].x = -1.0; cquad[0].y = -1.0; cquad[0].z = sin(t);
	cquad[0].r = 1.0; cquad[0].g = 0.0; cquad[0].b = 0.0; cquad[0].a = 1.0;

	cquad[1].x = 1.0; cquad[1].y = -1.0; cquad[1].z = sin(t);
	cquad[1].r = 0.0; cquad[1].g = 1.0; cquad[1].b = 0.0; cquad[1].a = 1.0;

	cquad[2].x = 1.0; cquad[2].y = 1.0; cquad[2].z = sin(t);
	cquad[2].r = 0.0; cquad[2].g = 1.0; cquad[2].b = 0.0; cquad[2].a = 1.0;

	cquad[3].x = -1.0; cquad[3].y = 1.0; cquad[3].z = sin(t);
	cquad[3].r = 1.0; cquad[3].g = 0.0; cquad[3].b = 0.0; cquad[3].a = 1.0;

	/*
	 * Write the quad data.
	 */
	fwrite((char *)cquad, 4*sizeof(struct cvert), 1, f);

	/*
	 * Now prepare and write the second quad structure.
	 */
	cquad[0].x = -1.0; cquad[0].y = -1.0; cquad[0].z = -sin(t);
	cquad[0].r = 0.0; cquad[0].g = 1.0; cquad[0].b = 0.0; cquad[0].a = 1.0;

	cquad[1].x = 1.0; cquad[1].y = -1.0; cquad[1].z = -sin(t);
	cquad[1].r = 0.0; cquad[1].g = 0.0; cquad[1].b = 1.0; cquad[1].a = 1.0;

	cquad[2].x = 1.0; cquad[2].y = 1.0; cquad[2].z = -sin(t);
	cquad[2].r = 0.0; cquad[2].g = 0.0; cquad[2].b = 1.0; cquad[2].a = 1.0;

	cquad[3].x = -1.0; cquad[3].y = 1.0; cquad[3].z = -sin(t);
	cquad[3].r = 0.0; cquad[3].g = 1.0; cquad[3].b = 0.0; cquad[3].a = 1.0;

	fwrite((char *)cquad, 4*sizeof(struct cvert), 1, f);

	/*
	 * NOTE: This code could have been written to write both (or any
	 * number of) quads at once, or to write one vertex at a time.
	 * All that matters is that we *must* eventually write exactly
	 * the number of quads promised above with putw().
	 */

	/*
	 * Delimit object for "stuff" to see.
	 */
	fprintf(f, ";");
	fflush(f);

        t += dt;

	/*
	 * sginap(N) is an Iris-specific system call. Sleep 10/100 = .1 second.
	 */
	sginap(10);
    }

    pclose(f);
    exit(0);
}

