/*	SCCS Id: @(#)vault.c	3.0	88/10/25
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

#include "hack.h"
#include "vault.h"

STATIC_DCL boolean FDECL(in_vault,(int,int));
STATIC_DCL struct monst *NDECL(findgd);

#ifdef OVLB

static boolean FDECL(clear_fcorr, (struct monst *,BOOLEAN_P));
static void FDECL(restfakecorr,(struct monst *));
static boolean FDECL(in_fcorridor, (struct monst *,int,int));

static boolean
clear_fcorr(grd, forceshow)
register struct monst *grd;
register boolean forceshow;
{
	register int fcx, fcy, fcbeg;
	register struct rm *crm;
	register struct monst *mtmp = (struct monst *)0;

	while((fcbeg = EGD(grd)->fcbeg) < EGD(grd)->fcend) {
		fcx = EGD(grd)->fakecorr[fcbeg].fx;
		fcy = EGD(grd)->fakecorr[fcbeg].fy;
		if(!in_fcorridor(grd, u.ux, u.uy) && EGD(grd)->gddone)
			forceshow = TRUE;
		if((u.ux == fcx && u.uy == fcy) || 
		   (!forceshow && cansee(fcx,fcy))) return(FALSE);
		if(mtmp = m_at(fcx,fcy)) {
			if(mtmp->isgd) return(FALSE);
			else if(!in_fcorridor(grd, u.ux, u.uy)) {
			    rloc(mtmp);
			    if(mtmp->mpeaceful) You("hear a muffled yelp.");
			}
		}
		crm = &levl[fcx][fcy];
		crm->typ = EGD(grd)->fakecorr[fcbeg].ftyp;
		if(!crm->typ) crm->seen = 0;
		newsym(fcx,fcy);
		if(cansee(fcx,fcy)) prl(fcx,fcy);
		EGD(grd)->fcbeg++;
	}
	return(TRUE);
}

static void
restfakecorr(grd) 
register struct monst *grd;
{
	/* it seems he left the corridor - let the guard disappear */
	if(clear_fcorr(grd, FALSE)) mongone(grd);
}

boolean
grddead(grd)				/* called in mon.c */
register struct monst *grd;
{
	register boolean dispose = clear_fcorr(grd, TRUE);

	if(!dispose) {
		remove_monster(grd->mx, grd->my);
		place_monster(grd, 0, 0);
		EGD(grd)->ogx = grd->mx;
		EGD(grd)->ogy = grd->my;
		dispose = clear_fcorr(grd, TRUE);
	}
	return(dispose);
}

static boolean
in_fcorridor(grd, x, y)
register struct monst *grd;
int x, y; 
{
	register int fci;

	for(fci = EGD(grd)->fcbeg; fci < EGD(grd)->fcend; fci++)
		if(x == EGD(grd)->fakecorr[fci].fx &&
				y == EGD(grd)->fakecorr[fci].fy)
			return(TRUE);
	return(FALSE);
}

STATIC_OVL
struct monst *
findgd() {

	register struct monst *mtmp;

	for(mtmp = fmon; mtmp; mtmp = mtmp->nmon)
	    if(mtmp->isgd && EGD(mtmp)->gdlevel == dlevel)
		return(mtmp);
	return((struct monst *)0);
}

#endif /* OVLB */
#ifdef OVL0

STATIC_OVL
boolean
in_vault(x, y)
int x, y;
{
    register int roomno = inroom(x, y);

    if(roomno < 0) return(FALSE);
    return(rooms[roomno].rtype == VAULT);
}

void
invault() {

#ifdef BSD_43_BUG
    int dummy;		/* hack to avoid schain botch */
#endif
    struct monst *guard;

    if(!in_vault(u.ux, u.uy)) {
	u.uinvault = 0;
	return;
    }

    guard = findgd();
    if(++u.uinvault % 30 == 0 && !guard) { /* if time ok and no guard now. */
	char buf[BUFSZ];
	register int x, y, dd, gx, gy;

	/* first find the goal for the guard */
	for(dd = 1; (dd < ROWNO || dd < COLNO); dd++) {
	  for(y = u.uy-dd; y <= u.uy+dd; y++) {
	    if(y < 0 || y > ROWNO-1) continue;
	    for(x = u.ux-dd; x <= u.ux+dd; x++) {
	      if(y != u.uy-dd && y != u.uy+dd && x != u.ux-dd)
		x = u.ux+dd;
	      if(x < 0 || x > COLNO-1) continue;
	      if(levl[x][y].typ == CORR) goto fnd;
	    }
	  }
	}
	impossible("Not a single corridor on this level??");
	tele();
	return;
fnd:
	gx = x; gy = y;

	/* next find a good place for a door in the wall */
	x = u.ux; y = u.uy;
	while(levl[x][y].typ == ROOM) {
		register int dx,dy;

		dx = (gx > x) ? 1 : (gx < x) ? -1 : 0;
		dy = (gy > y) ? 1 : (gy < y) ? -1 : 0;
		if(abs(gx-x) >= abs(gy-y))
			x += dx;
		else
			y += dy;
	}

	/* make something interesting happen */
	if(!(guard = makemon(&mons[PM_GUARD], x, y))) return;
	guard->isgd = 1;
	guard->mpeaceful = 1;
	EGD(guard)->gddone = 0;
	EGD(guard)->ogx = x;
	EGD(guard)->ogy = y;
	EGD(guard)->gdlevel = dlevel;
	EGD(guard)->vroom = inroom(x, y);
	EGD(guard)->warncnt = 0;

	if(!cansee(guard->mx, guard->my)) {
		mongone(guard);
		return;
	}

	reset_faint();			/* if fainted - wake up */
	pline("Suddenly one of the Vault's guards enters!");
	pmon(guard);
	stop_occupation();		/* if occupied, stop it *now* */
	do {
		pline("\"Hello stranger, who are you?\" - ");
		getlin(buf);
	} while (!letter(buf[0]));

	if(!strcmp(buf, "Croesus") || !strcmp(buf, "Kroisos")) {
		verbalize("Oh, yes, of course.  Sorry to have disturbed you.");
		mongone(guard);
		return;
	}
	clrlin();
	verbalize("I don't know you.");
	if(!u.ugold)
	    verbalize("Please follow me.");
	else {
	    verbalize("Most likely all that gold was stolen from this vault.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       