#ifndef SECT_H
#define SECT_H 


	/* sector types (must agree with order in dchr, empglb.c) */
#define	SCT_WATER	0       /* basics */
#define	SCT_MOUNT	1
#define	SCT_SANCT	2
#define	SCT_WASTE	3
#define	SCT_RURAL	4
#define	SCT_CAPIT	5
#define	SCT_URAN	6
#define	SCT_PARK	7
#define	SCT_ARMSF	8       /* industries */
#define	SCT_AMMOF	9
#define	SCT_MINE	10
#define	SCT_GMINE	11
#define	SCT_HARBR	12
#define	SCT_WAREH	13
#define	SCT_AIRPT	14
#define	SCT_AGRI	15
#define	SCT_OIL		16
#define	SCT_LIGHT	17
#define	SCT_HEAVY	18
#define	SCT_FORTR	19      /* military/scientific */
#define	SCT_TECH	20
#define	SCT_RSRCH	21
#define	SCT_NUKE	22
#define	SCT_LIBR	23
#define	SCT_HIWAY	24      /* communications */
#define	SCT_RADAR	25
#define	SCT_WETHR	26
#define	SCT_BHEAD	27
#define	SCT_BSPAN	28
#define	SCT_BANK	29      /* financial */
#define	SCT_REFINE	30	/* refinery */
#define SCT_ENLIST	31	/* enlistment center */

#define	SCT_MAXDEF	31	/* highest sector type in header files */

#define	MAXSCTV 32
#define MAXU	4

#define S_MAR		bit(0)	/* martial law declared */

#define CIV 0
#define MIL 1
#define UNC 2
#define FOOD 3
#define SHEL 4
#define GUN 5
#define PET 6
#define IRON 7
#define DUST 8
#define BAR 9
#define OIL 10
#define LCM 11
#define HCM 12
#define RAD 13

#define NUMCOMS RAD + 1

struct	sctstr {
	int	sct_x;		/* x coord of sector */
	int	sct_y;		/* y coord of sector */
	char	sct_type;	/* sector type */
	char	sct_newtype;	/* for changing designations */
	int	sct_effic;	/* 0% to 100% */
	int	sct_mobil;	/* mobility units */
	char	sct_loyal;	/* updates until civilans "converted" */
	int	sct_terr;	/* territory id # of sector */
	int	sct_work;	/* pct of civ actually working */
	int	sct_min;	/* ease of mining ore */
	int	sct_gmin;	/* amount of gold ore */
	int	sct_fertil;	/* fertility of soil */
	int	sct_oil;	/* oil content */
	int	sct_uran;	/* uranium ore content */
	char    dist_path[10];	/* sector distribution deliver path */
	int     dist_x;         /* xcoord of dist. site */
	int     dist_y;         /* ycoord of dist. site */
	int     coms[NUMCOMS];  /* array to hold commodity data */
	char    del[NUMCOMS];   /* array to hold delivery data */
	int     cut[NUMCOMS];   /* array to hold cutoff data */
	int     thrs[NUMCOMS];  /* array to hold threshold data */
};

#define UNKNOWN -1

typedef struct sctlst  {
  struct sctstr *data;
  struct sctlst *neighbor[6];
  struct sctlst *next; /* chain in linked list */
/* struct sctlst  *prev; chain to previous sect, not currently used */
  struct sctlst *aux; /* auxiliary pointer, USE WITH CAUTION */
  union {
    void *p; /* miscellanious pointer, USE WITH CAUTION */
    int   d; /* in case you want an int instead */
  } spec;
} sctlst_t;



#endif
