#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "sect.h"

main()
{
    FILE    *fp, *fopen();
    int     sectf, x, n;
    struct sctstr *sp;
    struct sctstr world[WORLD_Y*(WORLD_X/2)];
    char    *sprintf(), buf[80];

    if ((fp=fopen("sector.ascii", "r")) == (FILE *)0){
        fprintf(stderr,"Cannot open sector.ascii!\n");
        exit(-1);
    }

    sp = world;
    for(x=0;x<((WORLD_X/2)*WORLD_Y);x++,sp++)
        read_sector(sp, fp);
    fclose(fp);

    unlink(sprintf(buf,"%s/sector",DATADIR));
    sectf = open(sprintf(buf,"%s/sector",DATADIR), O_WRONLY|O_CREAT, 0);
    n=write(sectf, world, ((WORLD_X/2)*WORLD_Y*sizeof(struct sctstr)));
    close(sectf);

    printf("Writing %s/sector\n",DATADIR);
    printf("wrote %d bytes out of %d!\n",n,((WORLD_X/2)*WORLD_Y*sizeof(struct sctstr)));
}

read_sector(sp, fp)
struct sctstr *sp;
FILE *fp;
{
    int x, y;
    float f;

    fscanf(fp,"%d",&x);
    sp->sct_x = (coord)x;
    fscanf(fp,"%d",&x);
    sp->sct_y = (coord)x;
    fscanf(fp,"%d",&x);
    sp->sct_own = (natid)x;
    sp->sct_own = 0;
    fscanf(fp,"%d",&x);
    sp->sct_type = (u_char)x;
    fscanf(fp,"%d",&x);
    sp->sct_effic = (u_char)x;
    sp->sct_effic = 0;
    fscanf(fp,"%d",&x);
    sp->sct_mobil = (u_char)x;
    sp->sct_mobil = 0;
    fscanf(fp,"%d",&x);
    sp->sct_loyal = (u_char)x;
    sp->sct_loyal = 0;
    fscanf(fp,"%d",&x);
    sp->sct_terr = (u_char)x;
    sp->sct_terr = 0;
    fscanf(fp,"%d",&x);
    sp->sct_distpath = (long)x;
    sp->sct_distpath = 0;
    fscanf(fp,"%d",&x);
    sp->sct_elev = (short)x;
    sp->sct_elev = 0;
    fscanf(fp,"%d",&x);
    sp->sct_avail = (short)x;
    sp->sct_avail = 0;
    fscanf(fp,"%d",&x);
    sp->sct_fill = (short)x;
    sp->sct_fill = 0;
    fscanf(fp,"%d",&x);
    sp->sct_work = (u_char)x;
    sp->sct_work = 0;
    fscanf(fp,"%d",&x);
    sp->sct_flags = (u_char)x;
    sp->sct_flags = 0;
    fscanf(fp,"%d",&x);
    sp->sct_newtype = (u_char)x;
    fscanf(fp,"%d",&x);
    sp->sct_min = (u_char)x;
    sp->sct_min = 0;
    fscanf(fp,"%d",&x);
    sp->sct_gmin = (u_char)x;
    sp->sct_gmin = 0;
    fscanf(fp,"%d",&x);
    sp->sct_fertil = (u_char)x;
    sp->sct_fertil = 0;
    fscanf(fp,"%d",&x);
    sp->sct_oil = (u_char)x;
    sp->sct_oil = 0;
    fscanf(fp,"%d",&x);
    sp->sct_uran = (u_char)x;
    sp->sct_uran = 0;
    fscanf(fp,"%d",&x);
    sp->sct_oldown = (natid)x;
    sp->sct_oldown = 0;
    fscanf(fp,"%d",&x);
    sp->sct_nv = (u_char)x;
    sp->sct_nv = 0;

    for (y=0;y<MAXSCTV;y++){
        fscanf(fp,"%d",&x);
        sp->sct_vtype[y] = (u_char)x;
        sp->sct_vtype[y] = 0;
        }

    for (y=0;y<MAXSCTV;y++){
        fscanf(fp,"%d",&x);
        sp->sct_vamt[y] = 0;
        sp->sct_vamt[y] = (u_short)x;
        }
};
