#ifndef lint
static char *RCSid = "$Header: /u/dhay/stan/kent/update/RCS/main.c,v 1.1 91/03/19 23:39:18 dhay Exp Locker: dhay $";
#endif

/*
 * update.c
 *
 * Update scheduler
 *
 * Dave Pare, 1994
 */

#include "misc.h"
#include "player.h"
#include "keyword.h"
#include "lwp.h"

struct lwpSem	*update_sem;

int	update_pending;

extern	void update_main();
extern	void update_wait();

/*ARGSUSED*/
void
update_sched(argc, argv)
	int	argc;
	s_char	**argv;
{
	extern	int s_p_etu;
	extern	int etu_per_update;
	extern	int adj_update;
	time_t	delta;
	s_char	*kw;
	int	hour[2];
	int	secs_per_update;
	time_t	now;

	update_sem = lwpCreateSem(0);
	update_pending = 0;
	lwpCreate(PP_SCHED, update_wait, 8192, 0, 0, 0);
	time(&now);
	(void) gamehours(now, hour);
	if (kw = kw_find("s_p_etu"))
		kw_parse(CF_VALUE, kw, &s_p_etu);
	if (kw = kw_find("etu_per_update"))
		kw_parse(CF_VALUE, kw, &etu_per_update);
	if (kw = kw_find("adj_update"))
		kw_parse(CF_VALUE, kw, &adj_update);
	while (1) {
		time(&now);
		now += adj_update;
		secs_per_update = etu_per_update * s_p_etu;
		delta = secs_per_update - (now % secs_per_update);
		logerror("Next update in %d seconds", delta);
		/* sleep until update is scheduled to go off */
		lwpSleepUntil(now + delta + 1);
		time(&now);
		if (!gamehours(now, hour)) {
			logerror("No update permitted (hours restriction)");
			continue;
		}
		if (!updatetime(&now)) {
			logerror("No update wanted");
			continue;
		}
		if (updates_disabled()) {
			logerror("Updates disabled...skipping update");
			continue;
		}
		lwpSignal(update_sem);
	}
	/*NOTREACHED*/
}

/*ARGSUSED*/
void
update_wait(argc, argv)
	int	argc;
	s_char	**argv;
{
	struct	player *p;
	int	running;
	time_t	now;
	struct	player *dp;

	while (1) {
		lwpWait(update_sem);
		running = 0;
		update_pending++;
		for (p = player_next(0); p != 0; p = player_next(p)) {
			if (p->state != PS_PLAYING)
				continue;
			if (p->running) {
				p->aborted = 1;
				lwpWakeupFd(p->proc);
				running++;
			}
		}
		time(&now);
		if (running) {
			/* sleep a few, wait for aborts to take effect */
			lwpSleepUntil(now + 2);
		}
		/* 
		 * we rely on the fact that update's priority is the highest
		 * in the land so it can finish before it yields.
		 */
		dp = player_new(0, 0);
		lwpCreate(PP_UPDATE, update_main, 0x40000, 0, 0, dp);
		update_pending = 0;
	}
	/*NOTREACHED*/
}
