#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/mtch.c,v 1.1 89/05/17 20:51:59 mr-frog Exp $";
#endif

/*
 * mtch.c
 *
 * Matching operations on structures and commands.
 *
 * XXX These routines gamble that structures are all longword-aligned.
 * If this is not true, they will BREAK!
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "com.h"
#include "deity.h"
#include "match.h"

/*
 * find a matching integer from a member of a structure.
 * Inspired by stmtch above.
 */
int
intmatch(value, ptr, size)
	register int value;
	register int *ptr;
	int     size;
{
	register int i;

	size /= sizeof(*ptr);
	for (i=0; *ptr; i++, ptr += size)
		if (value == *ptr)
			return i;
	return -1;
}

/*
 * find a matching command from coms[].  Return status is:
 *  >= 0: match found, value is array entry in coms[]
 */
int
comtch(command, coms, comstat, god)
	register s_char *command;
	struct	comstr *coms;
	int	comstat;
	int	god;
{
	register struct comstr *com;
	register int status;
	register int i;

	if (command == 0 || *command == 0)
		return M_NOTFOUND;
	status = M_NOTFOUND;
	for (com=coms; com->c_form != 0; com++) {
		if ((com->c_permit & comstat) != com->c_permit && !god)
			continue;
		if ((i = mineq(command, com->c_form)) == ME_MISMATCH)
			continue;
		if (i == ME_EXACT)
			return com - coms;
		/* partial */
		if (status != M_NOTFOUND)
			return M_NOTUNIQUE;
		status = com - coms;
	}
	return status;
}
