static char *RCSid = "$Header: init_nats.c,v 1.3 90/03/19 10:49:02 mr-frog Exp $";

/*
 * init_nats.c
 *
 * initialize country and nation file stuff.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "file.h"
#include "deity.h"

int
init_nats()
{
	struct	natstr *np;

	if ((np = getnatp(player->cnum)) == 0)
		return -1;
	player->nstat = np->nat_stat;
	player->god = np->nat_stat & STAT_GOD;
	player->map = ef_ptr(EF_MAP, player->cnum);
	if (np->nat_money <= 0)
		player->broke = 1;
	else {
		player->nstat |= MONEY;
		player->broke = 0;
	}
	if (nat_cap(np->nat_btu) < 0)
		return -1;
	return 0;
}

int
nat_cap(btu)
	int	btu;
{
	extern	int s_p_etu;
	extern	int max_btus;
	extern	float btu_build_rate;
	struct	sctstr sect;
	struct	natstr *np;
	double	d;
	double	civ;
	int	delta;

	np = getnatp(player->cnum);
	if (!getsect(np->nat_xcap, np->nat_ycap, &sect)) {
		logerror("can't read %s's cap @ %d,%d",
			np->nat_cnam, np->nat_xcap, np->nat_ycap);
		return -1;
	}
	if ((player->nstat & NORM) == NORM) {
		if (player->owner && (sect.sct_type == SCT_CAPIT ||
		    sect.sct_type == SCT_MOUNT ||
		    sect.sct_type == SCT_SANCT))
			player->nstat |= CAP;
		else
			player->nstat &= ~CAP;
	}
	delta = 0;
	if ((player->nstat & CAP) || player->god) {
		d = (double) (player->curup - np->nat_date) / s_p_etu;
		if (d > 336.0)
			d = 336.0;
		civ = getvar(V_CIVIL, (caddr_t)&sect, EF_SECTOR);
		if (civ > 999)
			civ = 999;
		if ((sect.sct_effic) && (sect.sct_type != SCT_MOUNT))
			delta=roundavg(((d*civ)*sect.sct_effic)*btu_build_rate);
		else /* Assume 1/2% efficiency minimum */
			delta=roundavg((d/2.0*civ)*btu_build_rate);
		if (player->god)
			delta = max_btus - btu;
		if (delta + btu > max_btus)
			delta = max_btus - btu;
		if (btu > max_btus)
			delta = max_btus - btu;
#ifdef BLITZ
                delta = max_btus - btu;
#endif

		if (delta > 0) {
			/* set date if BTUs made */
			np->nat_btu += delta;
			np->nat_date = player->curup;
		}
		if (btu > max_btus)
			np->nat_btu = max_btus;
	} else {
		/* set date if no cap */
		np->nat_date = player->curup;
	}
	putnat(np);
	return 0;
}
