#ifndef lint
static char *RCSid = "$Header: edit.c,v 1.53 90/03/19 11:00:39 mr-frog Exp $";
#endif /* not lint */

/*
 * edit.c
 *
 * David Muir Sharnoff
 *
 * This command NEEDS TO BE REDONE.
 * Updated for threads, Aug 94, Chad Zabel
 */

#include <stdio.h>
#include <ctype.h>
#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"
#include "file.h"
#include "plane.h"
#include "ship.h"
#include "land.h"

#define END -1
static	prnat();
static	prplane();
static	prland();
static	prship();
static	prsect();
static	noise();
static	benefit();
	

/*
 * format: give c <amt> <commod> <sect>
 */
edit()
{
	extern	int shp_maxno;
	extern	int m_m_p_d;
	struct	sctstr sect;
	struct	plnstr plane;
	struct	shpstr ship;
	struct	lndstr land;
	s_char	*what;
	s_char	*ptr;
	s_char	*thing;
	int	num;
	int	arg;
	int	err;
	coord	x, y;
	float	farg;
	natid	nat;
	struct	natstr	*np;
	s_char	buf[1024];
 	s_char  ewhat;     /* saves information from the command line
			      for use later on. 			*/
  

	if ((what = getstarg(player->argp[1],
		"Edit What (country, land, ship, plane, nuke, unit)? ", buf)) == 0) 
		return RET_SYN;
	ewhat = what[0]; 
	switch (ewhat) {
	case 'l':
		if (!(ptr = getstarg(player->argp[2], "Sector : ", buf)))
			return RET_FAIL;
		if (!sarg_xy(ptr, &x, &y))
			return RET_FAIL;
		if (!getsect(x, y, &sect))
			return RET_FAIL;
		break;
	case 'c':
		if ((num = natarg(player->argp[2], "Country number? ")) < 0)
			return RET_SYN;
		nat = (natid) num;
		np = getnatp(nat);
		break;
	case 'p':
		if ((num = onearg(player->argp[2], "Plane number? ")) < 0)
			return RET_SYN;
		if (!getplane(num, &plane))
			return RET_SYN;
		break;
	case 's':
		if ((num = onearg(player->argp[2], "Ship number? ")) < 0)
			return RET_SYN;
		if (!getship(num, &ship))
			return RET_SYN;
		break;
	case 'u':
		if ((num = onearg(player->argp[2], "Unit number? ")) < 0)
			return RET_SYN;
		if (!getland(num, &land))
			return RET_SYN;
		break;
	case 'n':
		pr("Not implemented yet.\n");
		break;
	default:
		pr("huh?\n");
		return RET_SYN;
	}
	if (player->argp[3] == 0) {
		switch (ewhat) {
		case 'l':
			prsect(&sect);
			break;
		case 'c':
			prnat(nat);
			break;
		case 'p':
			prplane(&plane);
			break;
		case 's':
			prship(&ship);
			break;
		case 'u':
			prland(&land);
			break;
		}
	} else if (player->argp[4] != 0)
		(void) strcat (player->argp[3], player->argp[4]);
	if (!(ptr = getstarg(player->argp[3], "%c xxxxx -- thing value : ", buf))) {
		return RET_SYN;
	}
	for (;;) {
		if ((err = getin(&thing, &ptr, &arg)) != RET_OK) {
			if (err == END) {
				switch (ewhat) {
				case 'c':
					prnat(nat);
					break;
				case 'l':
					prsect(&sect);
					break;
				case 's':
					prship(&ship);
					break;
				case 'u':
					prland(&land);
					break;
				case 'p':
					prplane(&plane);
					break;
				}
				break;
			} else
				return err;
		}
		switch (ewhat) {
		case 'c':
			farg = atof(ptr);
			if ((err = docountry(thing[0], arg, ptr, farg, nat, np))
								    != RET_OK)
				return err;
			break;
		case 'l':
			if ((err = doland(thing[0], arg, &sect)) != RET_OK)
				return err;
			if (!putsect(&sect))
				return RET_FAIL;
			break;
		case 's':
			if ((err = doship(thing[0], arg, ptr, &ship)) != RET_OK)
				return err;
			if (!putship(ship.shp_uid, &ship))
				return RET_FAIL;
			break;
		case 'u':
			farg = atof(ptr);
			if ((err = dounit(thing[0], arg, ptr, &land))
				!= RET_OK)
				return err;
			if (!putland(land.lnd_uid, &land))
				return RET_FAIL;
			break;
		case 'p':
			if ((err = doplane(thing[0], arg, ptr, &plane))
								    != RET_OK)
				return err;
			if (!putplane(plane.pln_uid, &plane))
				return RET_FAIL;
			break;
		}
		if (err != RET_OK)
			break;
		else
			ptr = 0;
	}
	return RET_OK;
}

static
benefit(who, good) 
	natid	who;
	int	good;
{
	who = 0; /* Disabled. Who wants to tell the players anything? --ts */

	if (good) {
		if (who)
			nreport(player->cnum, N_AIDS, who, 1);
	} else {
		if (who)
			nreport(player->cnum, N_HURTS, who, 1);
	}
}

static
noise(sptr, public_amt, name, old, new)
	struct	sctstr *sptr;
	int	public_amt;
	s_char	*name;
	int	old, new;
{
	s_char p[100];

	pr("%s of %s changed from %d to %d%\n",
		name, xyas(sptr->sct_x, sptr->sct_y, player->cnum), old, new);
	if (public_amt) 
		(void) sprintf(p, "changed from %d to %d", old, new);
	else
		(void) sprintf(p, "%s", (old<new ? "increased":"decreased"));
	if (sptr->sct_own)
		wu(player->cnum, sptr->sct_own,
			"%s in %s was %s by an act of %s\n",
			    name, xyas(sptr->sct_x, sptr->sct_y, sptr->sct_own),
			    p, cname(player->cnum));
	benefit(sptr->sct_own, (old < new));
}

static
prsect(sect) 
	struct	sctstr *sect;
{
	pr("X coord <X>: %d\t",sect->sct_x);
	pr("Y coord <Y>: %d\n",sect->sct_y);
	pr("X dist coord: %d\t",sect->sct_dist_x);
	pr("Y dist coord: %d\n",sect->sct_dist_y);
#ifdef	FALLOUT
	pr("  sect       own  oo eff mob min gld frt oil urn wrk lty  che plg ptime fall avail\n");
	pr("things:        o   O   e   m   i   g   f   c   u   w   l    x   p     t    F     a\n");
#else
	pr("  sect       own  oo eff mob min gld frt oil urn wrk lty  che plg ptime fall avail\n");
	pr("things:        o   O   e   m   i   g   f   c   u   w   l    x   p     t    a\n");
#endif	FALLOUT
	prxy("%4d,%-4d", sect->sct_x, sect->sct_y, player->cnum);
#ifdef	FALLOUT
	pr(" %c%c %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %4d %3d %5d %4d %5d\n",
#else
	pr(" %c%c %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %4d %3d %5d %5d\n",
#endif	FALLOUT
		dchr[sect->sct_type].d_mnem,
		(sect->sct_newtype == sect->sct_type) ? ' ' :
			 dchr[sect->sct_newtype].d_mnem,
		sect->sct_own, sect->sct_oldown,
		sect->sct_effic, sect->sct_mobil,
		sect->sct_min, sect->sct_gmin,
		sect->sct_fertil, sect->sct_oil, sect->sct_uran,
		sect->sct_work, sect->sct_loyal,
		getvar(V_CHE, (s_char *)sect, EF_SECTOR),
		getvar(V_PSTAGE, (s_char *)sect, EF_SECTOR),
		getvar(V_PTIME, (s_char *)sect, EF_SECTOR),
#ifdef	FALLOUT
		getvar(V_FALLOUT, (s_char *)sect, EF_SECTOR),
#endif	FALLOUT
		sect->sct_avail);

	pr(" Mines <M>: %d\n", getvar(V_MINE, (s_char *)sect, EF_SECTOR));
}


static
prnat(n) 
	natid	n;
{
	struct natstr *np;

	if ((np = getnatp(n)) == 0)
		return;
	pr("Country #: %2d\n", n);
	pr("Name <n>: %-20s\t", np->nat_cnam);
	pr("Login: %d\n", np->nat_login);
	pr("Representative <r>: %-20s\n", np->nat_pnam);
	pr("BTUs <b>: %3d\t\t\t", np->nat_btu);
	pr("Reserves <m>: %5d\n", np->nat_reserve);
	pr("Capital <c>: %s\t\t", xyas(np->nat_xcap, np->nat_ycap, player->cnum));
	pr("Origin <o>: %3s\n", xyas(np->nat_xorg, np->nat_yorg, player->cnum));
	pr("Status <s>: 0x%x\t\t\t", np->nat_stat);
	pr("Min Used <u>: %3d\n", np->nat_minused);
	pr("Technology <T>: %.2f\t\t", np->nat_level[NAT_TLEV]);
	pr("Research <R>: %.2f\n", np->nat_level[NAT_RLEV]);
	pr("Education <E>: %.2f\t\t", np->nat_level[NAT_ELEV]);
	pr("Happiness <H>: %.2f\n", np->nat_level[NAT_HLEV]);
	pr("Money <M>: $%6d\n", np->nat_money);
	pr("Telegrams <t>: %6d\n", np->nat_tgms);
#ifdef DEMANDUPDATE
	pr("Updates missed <U>: %d\n", np->nat_missed);
#endif /* DEMANDUPDATE */
}

static
prplane(plane)
	struct plnstr *plane;
{
	pr("UID <U>: %d\t\t", (int)plane->pln_uid);
	pr("Owner <O>: %d\t\t", (int)plane->pln_own);
	pr("Location <l>: %s\n", xyas(plane->pln_x, plane->pln_y, player->cnum));
	pr("Efficiency <e>: %d\t", (int)plane->pln_effic);
	pr("Mobility <m>: %d\n", (int)plane->pln_mobil);
	pr("Tech <t>: %d\t\t", plane->pln_tech);
	pr("Wing <w>: %c\n", plane->pln_wing);
	pr("Attack <a>: %d\t\t", plane->pln_att);
	pr("Defense <d>: %d\n", plane->pln_def);
#ifdef	ORBIT
	pr("Range <r>: %d\t\t", plane->pln_range);
	pr("Flags <f>: %d\n", plane->pln_flags);
#else
	pr("Range <r>: %d\n", plane->pln_range);
#endif	ORBIT
	pr("Ship <s>: %d\n", plane->pln_ship);
}

static
prland(land)
	struct lndstr *land;
{
	int	vec[I_MAX+1];
	struct lchrstr *lcp;

	lcp = &lchr[land->lnd_type];
	pr("UID <U>: %d\n", (int)land->lnd_uid);
	pr("Owner <O>: %d\n", (int)land->lnd_own);
	pr("Location <L>: %s\n", xyas(land->lnd_x, land->lnd_y, player->cnum));
	pr("Efficiency <e>: %d\t", (int)land->lnd_effic);
	pr("Mobility <M>: %d\n", (int)land->lnd_mobil);
	pr("Tech <t>: %d\t\t", land->lnd_tech);
	pr("Army <a>: %c\n", land->lnd_army);
	pr("Attack: %f\t", lcp->l_att);
	pr("Defense: %f\n", lcp->l_def);
	pr("Fortification <F>: %d\t", land->lnd_harden);
	pr("Fuel <B>: %d\n", land->lnd_fuel);
        count_land_planes(land);
	pr("Xlight planes <X>: %d\n", land->lnd_nxlight);
	pr("Ship <S>: %d\t\t", land->lnd_ship);
	pr("Radius <P>: %d\n", land->lnd_rad_max);
	pr("Retreat percentage <Z>: %d\n", (int)land->lnd_retreat);
	pr("Retreat path <R>: '%s'\t\tRetreat Flags <W>: %d\n",land->lnd_rpath,(int)land->lnd_rflags);
	getvec(VT_ITEM, vec, (s_char *)land, EF_LAND);
	pr("civ mil  uw food shl gun  pet  irn  dst  oil  lcm  hcm rad\n");
	pr("  c   m   u    f   s   g    p    i    d    o    l    h   r\n");
	pr("%3d", vec[I_CIVIL]);
	pr("%4d", vec[I_MILIT]);
	pr("%4d", vec[I_UW]);
	pr("%5d", vec[I_FOOD]);
	pr("%4d", vec[I_SHELL]);
	pr("%4d", vec[I_GUN]);
	pr("%5d", vec[I_PETROL]);
	pr("%5d", vec[I_IRON]);
	pr("%5d", vec[I_DUST]);
	pr("%5d", vec[I_OIL]);
	pr("%5d", vec[I_LCM]);
	pr("%5d", vec[I_HCM]);
	pr("%4d", vec[I_RAD]);
	pr("\n");
}

static
prship(ship)
	struct shpstr *ship;
{
	int	vec[I_MAX+1];
	struct natstr *natp;

	if ((natp = getnatp(ship->shp_own)) == 0)
		return;
#ifdef	SHIPNAMES
	pr("%s (#%d) %s %s(#%d)\n", natp->nat_cnam, (int)ship->shp_own,
				mchr[ship->shp_type].m_name, ship->shp_name,
				ship->shp_uid);
#else
	pr("%s (#%d) %s #%d\n", natp->nat_cnam, (int)ship->shp_own,
				mchr[ship->shp_type].m_name, ship->shp_uid);
#endif	SHIPNAMES
	pr("UID <U>: %d\n", (int)ship->shp_uid);
	pr("Owner <O>: %d\t\t\t", (int)ship->shp_own);
	pr("Location <L>: %s\n", xyas(ship->shp_x, ship->shp_y, player->cnum));
	pr("Tech <T>: %d\t\t\t", ship->shp_tech);
	pr("Efficiency <E>: %d\n", (int)ship->shp_effic);
	pr("Mobility <M>: %d\t\t\t", (int)ship->shp_mobil);
	pr("Fleet <F>: %c\n", ship->shp_fleet);
        count_planes(ship);
	pr("Helos <H>: %d\n", (int)ship->shp_nchoppers);
	pr("Xlight planes <X>: %d\n", (int)ship->shp_nxlight);
	pr("Planes <P>: %d\n", (int)ship->shp_nplane);
        count_units(ship);
	pr("Units <Y>: %d\n", (int)ship->shp_nland);
#ifdef FUEL
	pr("Fuel <B>: %d\n", (int)ship->shp_fuel);
#endif /* FUEL */
	pr("Retreat path <R>: '%s'\t\tRetreat Flags <W>: %d\n",ship->shp_rpath,(int)ship->shp_rflags);
	getvec(VT_ITEM, vec, (s_char *)ship, EF_SHIP);
	pr("civ mil  uw food shl gun  pet  irn  dst  oil  lcm  hcm rad\n");
	pr("  c   m   u    f   s   g    p    i    d    o    l    h   r\n");
	pr("%3d", vec[I_CIVIL]);
	pr("%4d", vec[I_MILIT]);
	pr("%4d", vec[I_UW]);
	pr("%5d", vec[I_FOOD]);
	pr("%4d", vec[I_SHELL]);
	pr("%4d", vec[I_GUN]);
	pr("%5d", vec[I_PETROL]);
	pr("%5d", vec[I_IRON]);
	pr("%5d", vec[I_DUST]);
	pr("%5d", vec[I_OIL]);
	pr("%5d", vec[I_LCM]);
	pr("%5d", vec[I_HCM]);
	pr("%4d", vec[I_RAD]);
	pr("\n");
}

errcheck(num, max)
	int	num, max;
{
	if (num < 0)
		return(0);
	else if (num > max)
		return(max);
	return (num);
}

getin(what, p, arg)
	s_char	**what, **p;
	int	*arg;
{
	s_char	buf[1024];

	if (!(*what = getstarg(*p, "%c xxxxx -- thing value : ", buf))) {
		return RET_SYN;
	}
	if (**what == '\0')
		return END;
	while(isspace(**what))
		++what;
	*p = *what + 1;
	while(isspace(**p))
		++(*p);
	*arg = atoi(*p);
	return RET_OK;
}


doland(op, arg, sect)
	s_char	op;
	int	arg;
	struct	sctstr *sect;
{
	natid	newown, oldown;
	int	new, old;
	switch (op) {
	case 'o':
		if (arg < 0)
			return RET_SYN;
		newown = (natid) errcheck(arg, MAXNOC-1);
		pr("Owner of %s changed from %s (#%d) to %s (#%d).\n",
			xyas(sect->sct_x, sect->sct_y, player->cnum),
			cname(sect->sct_own),
			sect->sct_own, cname(newown), newown);
		if (sect->sct_own) {
			wu(player->cnum, sect->sct_own, 
				"Sector %s lost to deity intervention\n", 
				xyas(sect->sct_x, sect->sct_y, sect->sct_own));
		}
		benefit(sect->sct_own, 0);
		sect->sct_own = newown;
		if (newown) {
			wu(player->cnum, newown,
			"Sector %s gained from deity intervention\n",
			xyas(sect->sct_x, sect->sct_y, sect->sct_own));
		}
		benefit(newown, 1);
		break;
	case 'O':
		if (arg < 0)
			return RET_SYN;
		oldown = (natid) errcheck(arg, MAXNOC-1);
		pr("Old player->owner of %s changed from %s (#%d) to %s (#%d).\n",
			xyas(sect->sct_x, sect->sct_y, player->cnum),
			cname(sect->sct_oldown),
			sect->sct_oldown, cname(oldown), oldown);
		sect->sct_oldown = oldown;
		break;
	case 'e':
		new = errcheck(arg, 100);
		noise(sect, 1, "Efficiency", (int) sect->sct_effic, new);
		sect->sct_effic = (u_char) new;
		break;
	case 'm':
		new = errcheck(arg, 255);
		noise(sect, 1, "Mobility", (int) sect->sct_mobil, new);
		sect->sct_mobil = (u_char) new;
		break;
	case 'i':
		new = errcheck(arg, 127);
		noise(sect, 1, "Iron ore content", (int) sect->sct_min, new);
		sect->sct_min = (u_char) new;
		break;
	case 'g':
		new = errcheck(arg, 127);
		noise(sect, 1, "Gold content", (int) sect->sct_gmin, new);
		sect->sct_gmin = (u_char) new;
		break;
	case 'f':
		new = errcheck(arg, 127);
		noise(sect, 1, "Fertility", (int) sect->sct_fertil, new);
		sect->sct_fertil = (u_char) new;
		break;
	case 'c':
		new = errcheck(arg, 127);
		noise(sect, 1, "Oil content", (int) sect->sct_oil, new);
		sect->sct_oil = (u_char) new;
		break;
	case 'u':
		new = errcheck(arg, 127);
		noise(sect, 1, "Uranium content", (int) sect->sct_uran, new);
		sect->sct_uran = (u_char) new;
		break;
	case 'w':
		new = errcheck(arg, 100);
		noise(sect, 1, "Workforce percentage",
			(int) sect->sct_work, new);
		sect->sct_work = (u_char) new;
		break;
	case 'l':
		new = errcheck(arg, 127);
		pr("Loyalty of %s changed from %d to %d%%\n",
			xyas(sect->sct_x, sect->sct_y, player->cnum),
			sect->sct_loyal, new);
		sect->sct_loyal = (u_char) new;
		break;
	case 'x':
		old = getvar(V_CHE, (s_char *)sect, EF_SECTOR);
		new = errcheck(arg, 65536);
		pr("Guerillas in %s changed from %d to %d%\n",
			xyas(sect->sct_x, sect->sct_y, player->cnum), old, new);
		putvar(V_CHE, new, (s_char *)sect, EF_SECTOR);
		break;
	case 'p':
		old = getvar(V_PSTAGE, (s_char *)sect, EF_SECTOR);
		new = errcheck(arg, PLG_EXPOSED);
		pr("Plague stage of %s changed from %d to %d%\n",
			xyas(sect->sct_x, sect->sct_y, player->cnum), old, new);
		putvar(V_PSTAGE, new, (s_char *)sect, EF_SECTOR);
		break;
	case 't':
		old = getvar(V_PTIME, (s_char *)sect, EF_SECTOR);
		new = errcheck(arg, 64);
		pr("Plague time of %s changed from %d to %d%\n",
			xyas(sect->sct_x, sect->sct_y, player->cnum), old, new);
		putvar(V_PTIME, new, (s_char *)sect, EF_SECTOR);
		break;
#ifdef	FALLOUT
	case 'F':
		old = getvar(V_FALLOUT, (s_char *)sect, EF_SECTOR);
		new = errcheck(arg,999);
		pr("Fallout for sector %s changed from %d to %d\n",
		       xyas(sect->sct_x, sect->sct_y, player->cnum), old, new);
		putvar(V_FALLOUT, new, (s_char *)sect, EF_SECTOR);
		break;
#endif	FALLOUT
	case 'a':
		new = errcheck(arg, 999);
		noise(sect, 1, "Available workforce", (int) sect->sct_avail,
			new);
		sect->sct_avail = new;
		break;
	case 'M':
		putvar(V_MINE, arg, (s_char *)sect, EF_SECTOR);
		pr("Mines changed to %d\n",arg);
		break;
	case 'X':
		sect->sct_x = arg;
		break;
	case 'Y':
		sect->sct_y = arg;
		break;
	default:
		pr("huh? (%c)\n",op);
		return RET_SYN;
	}
	return RET_OK;
}



docountry(op, arg, p, farg, nat, np)
	s_char	op;
	int	arg;
	s_char	*p;
	float	farg;
	natid	nat;
	struct	natstr *np;
{
	extern  int m_m_p_d;
	coord	newx, newy;
	switch (op) {
	case 'n':
		pr("Country name changed from %s to %s\n", np->nat_cnam, p);
		strncpy(np->nat_cnam, p, sizeof(np->nat_cnam)-1);
		break;
	case 'r':
		pr("Country representative changed from %s to %s\n",
							np->nat_pnam, p);
		strncpy(np->nat_pnam, p, sizeof(np->nat_pnam)-1);
		break;
	case 't':
		np->nat_tgms = arg;
		break;
	case 'b':
		arg = errcheck(arg, 1024);
		pr("BTU's changed from %d to %d\n", np->nat_btu, arg);
		np->nat_btu = arg;
		break;
	case 'm':
		benefit(nat, np->nat_reserve < arg);
		pr("Military Reserves changed from %d to %d\n",
			np->nat_reserve, arg);
		if (np->nat_stat == STAT_NORM)
			wu(player->cnum, nat,
			    "Military Reserves changed from %d to %d by divine intervention.\n", 
			    np->nat_reserve, arg);
		np->nat_reserve = arg;
		break;
	case 'c':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		pr("Capitol coordinates changed from %s to %s\n",
			xyas(np->nat_xcap, np->nat_ycap, player->cnum),
			xyas(newx, newy, player->cnum));
		np->nat_xcap = newx;
		np->nat_ycap = newy;
		break;
	case 'o':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		pr("Origin coordinates changed from %s to %s\n",
			xyas(np->nat_xorg, np->nat_yorg, player->cnum),
			xyas(newx, newy, player->cnum));
		np->nat_xorg = newx;
		np->nat_yorg = newy;
		break;
	case 's':
		np->nat_stat = (s_char)errcheck(arg, STAT_NEW);
		break;
	case 'u':
		arg = errcheck(arg, m_m_p_d);
		pr("Number of minutes used changed from %d to %d.\n",
			np->nat_minused, arg);
		np->nat_minused = arg;
		break;
	case 'M':
		pr("Money changed from %d to %d\n",np->nat_money, arg);
		wu(player->cnum, nat,
		    "Money changed from %d to %d by divine intervention.\n",
			np->nat_money, arg);
		np->nat_money = arg;
		break;
	case 'T':
		pr("Tech changed from %.2f to %.2f.\n",
			np->nat_level[NAT_TLEV], farg);
		np->nat_level[NAT_TLEV] = farg;
		break;
	case 'R':
		pr("Research changed from %.2f to %.2f.\n",
			np->nat_level[NAT_RLEV], farg);
		np->nat_level[NAT_RLEV] = farg;
		break;
	case 'E':
		pr("Education changed from %.2f to %.2f.\n",
			np->nat_level[NAT_ELEV], farg);
		np->nat_level[NAT_ELEV] = farg;
		break;
	case 'H':
		pr("Happiness changed from %.2f to %.2f.\n",
			np->nat_level[NAT_HLEV], farg);
		np->nat_level[NAT_HLEV] = farg;
		break;
#ifdef DEMANDUPDATE
	case 'U':
		np->nat_missed = arg;
		break;
#endif /* DEMANDUPDATE */
	default:
		pr("huh? (%c)\n",op);
		break;
	}
	putnat(np);
	return RET_OK;
}


doship(op, arg, p, ship)
	s_char	op;
	int	arg;
	s_char	*p;
	struct	shpstr *ship;
{
	coord	newx, newy;

	newx = newy = 0;
	switch (op) {
	case 'R':
		bcopy(p,ship->shp_rpath,10);
		break;
	case 'W':
		ship->shp_rflags = arg;
		break;
	case 'H':
		ship->shp_nchoppers = arg;
		break;
	case 'X':
		ship->shp_nxlight = arg;
		break;
	case 'U':
		ship->shp_uid = arg;
		break;
	case 'O':
		if (ship->shp_own)
			wu(player->cnum, ship->shp_own,
#ifdef	SHIPNAMES
				"%s %s(#%d) taken from you by deity intervention!\n",
				mchr[ship->shp_type].m_name, ship->shp_name,
				ship->shp_uid);
#else
				"%s #%d taken from you by deity intervention!\n",
				mchr[ship->shp_type].m_name, ship->shp_uid);
#endif	SHIPNAMES
		if (arg && arg < MAXNOC) {
			wu(player->cnum, (natid)arg,
#ifdef	SHIPNAMES
			    "%s %s(#%d) given to you by deity intervention!\n",
			    mchr[ship->shp_type].m_name, ship->shp_name,
			    ship->shp_uid);
#else
			    "%s #%d given to you by deity intervention!\n",
			    mchr[ship->shp_type].m_name, ship->shp_uid);
#endif	SHIPNAMES
			ship->shp_own = (natid) arg;
		} else if (!arg) {
			ship->shp_effic = 0;
			ship->shp_own = (natid) 0;
		}
		break;
	case 'L':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		ship->shp_x = newx;
		ship->shp_y = newy;
		break;
	case 'T':
		ship->shp_tech = arg;
		break;
	case 'E':
		ship->shp_effic = errcheck(arg, 100);
		if (arg < 10) {
			ship->shp_effic = 0;
			ship->shp_own = (natid) 0;
		}
		break;
	case 'M':
		ship->shp_mobil = arg;
		break;
#ifdef FUEL
	case 'B':
		ship->shp_fuel = errcheck(arg, 255);
		break;
#endif /* FUEL */
	case 'F':
		if (p[0] == '~')
			ship->shp_fleet = ' ';
		else if (isalpha(p[0]))
			ship->shp_fleet = p[0];
		else {
			pr("%c: invalid fleet\n",p[0]);
			return RET_FAIL;
		}
		break;
	case 'Y':
		ship->shp_nland = errcheck(arg, 100);
		break;
	case 'P':
		ship->shp_nplane = errcheck(arg, 100);
		break;
	case 'c':
		if (!putvar(V_CIVIL, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
			break;
	case 'm':
		if (!putvar(V_MILIT, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'u':
		if (!putvar(V_UW, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'f':
		if (!putvar(V_FOOD, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
				return RET_FAIL;
			}
			break;
	case 's':
		if (!putvar(V_SHELL, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'g':
		if (!putvar(V_GUN, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'p':
		if (!putvar(V_PETROL, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
				return RET_FAIL;
			}
			break;
	case 'i':
		if (!putvar(V_IRON, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'd':
		if (!putvar(V_DUST, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'o':
		if (!putvar(V_OIL, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'l':
		if (!putvar(V_LCM, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'h':
		if (!putvar(V_HCM, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
				return RET_FAIL;
			}
			break;
	case 'r':
		if (!putvar(V_RAD, arg, (s_char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	default:
		pr("huh? (%c)\n",op);
		return RET_FAIL;
	}
	return RET_OK;
}

dounit(op, arg, p, land)
	s_char	op;
	int	arg;
	s_char	*p;
	struct	lndstr *land;
{
	coord	newx, newy;

	newx = newy = 0;
	switch (op) {
	case 'U':
		land->lnd_uid = arg;
		break;
	case 'O':
		if (land->lnd_own)
			wu(player->cnum, land->lnd_own,
			   "%s #%d taken from you by deity intervention!\n",
			   lchr[land->lnd_type].l_name, land->lnd_uid);

		if (arg && arg < MAXNOC) {
			wu(player->cnum, (natid)arg,
			    "%s #%d given to you by deity intervention!\n",
			    lchr[land->lnd_type].l_name, land->lnd_uid);
			land->lnd_own = (natid) arg;
		} else if (!arg) {
			land->lnd_effic = 0;
			land->lnd_own = (natid) 0;
		}
		break;
	case 'L':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		land->lnd_x = newx;
		land->lnd_y = newy;
		break;
	case 'e':
		land->lnd_effic = errcheck(arg, 100);
		if (arg < 10) {
			land->lnd_effic = 0;
			land->lnd_own = (natid) 0;
		}
		break;
	case 'M':
		land->lnd_mobil = arg;
		break;
	case 't':
		land->lnd_tech = arg;
		break;
	case 'a':
		if (p[0] == '~')
			land->lnd_army = ' ';
		else if (isalpha(p[0]))
			land->lnd_army = p[0];
		else {
			pr("%c: invalid army\n",p[0]);
			return RET_FAIL;
		}
		break;
	case 'F':
		land->lnd_harden = errcheck(arg, 255);
		break;
#ifdef FUEL
	case 'B':
		land->lnd_fuel = errcheck(arg, 255);
		break;
#endif /* FUEL */
	case 'X':
		land->lnd_nxlight = arg;
		break;
	case 'S':
		land->lnd_ship = arg;
		break;
	case 'P':
		land->lnd_rad_max = arg;
		break;
	case 'Z':
		land->lnd_retreat = arg;
		break;
	case 'R':
		bcopy(p,land->lnd_rpath,10);
		break;
	case 'W':
		land->lnd_rflags = arg;
		break;
	case 'c':
		if (!putvar(V_CIVIL, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land unit!\n");
			return RET_FAIL;
		}
			break;
	case 'm':
		if (!putvar(V_MILIT, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'u':
		if (!putvar(V_UW, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'f':
		if (!putvar(V_FOOD, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
				return RET_FAIL;
			}
			break;
	case 's':
		if (!putvar(V_SHELL, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'g':
		if (!putvar(V_GUN, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'p':
		if (!putvar(V_PETROL, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
				return RET_FAIL;
			}
			break;
	case 'i':
		if (!putvar(V_IRON, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'd':
		if (!putvar(V_DUST, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'o':
		if (!putvar(V_OIL, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'l':
		if (!putvar(V_LCM, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	case 'h':
		if (!putvar(V_HCM, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
			}
			break;
	case 'r':
		if (!putvar(V_RAD, arg, (s_char *)land, EF_LAND)) {
			pr("No room on land!\n");
			return RET_FAIL;
		}
		break;
	default:
		pr("huh? (%c)\n",op);
		return RET_FAIL;
	}
	return RET_OK;
}


doplane(op, arg, p, plane)
	s_char	op;
	int	arg;
	s_char	*p;
	struct	plnstr *plane;
{
	coord	newx, newy;

	switch (op) {
	case 'U':
		plane->pln_uid = arg;
		break;
	case 'l':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		plane->pln_x = newx;
		plane->pln_y = newy;
		break;
	case 'O':
		if (plane->pln_own)
			wu(player->cnum, plane->pln_own,
				"%s #%d taken from you by deity intervention!\n",
				plchr[plane->pln_type].pl_name, plane->pln_uid);
		if (arg && arg < MAXNOC) {
			plane->pln_own = (natid) arg;
			wu(player->cnum, plane->pln_own,
			    "%s #%d given to you by deity intervention!\n",
			    plchr[plane->pln_type].pl_name, plane->pln_uid);
		} else if (!arg) {
			plane->pln_effic = 0;
			plane->pln_own = (natid) 0;
		}
		break;
	case 'e':
		plane->pln_effic = errcheck(arg, 100);
		if (arg < 10) {
			plane->pln_effic = 0;
			plane->pln_own = (natid) 0;
		}
		break;
	case 'm':
		plane->pln_mobil = errcheck(arg, 255);
		break;
	case 't':
		plane->pln_tech = arg;
		break;
	case 'w':
		if (p[0] == '~')
			plane->pln_wing = ' ';
		else if (isalpha(p[0]))
			plane->pln_wing = p[0];
		else {
			pr("%c: invalid wing\n",p[0]);
			return RET_FAIL;
		}
		break;
	case 'a':
		plane->pln_att = (s_char) errcheck(arg, 127);
		break;
	case 'd':
		plane->pln_def = (s_char) arg;
		break;
	case 'r':
		plane->pln_range = (u_char) arg;
		break;
	case 's':
		plane->pln_ship = arg;
		break;
#ifdef	ORBIT
	case 'f':
		plane->pln_flags = arg;
		break;
#endif	ORBIT
	default:
		pr("huh? (%c)\n",op);
		return RET_FAIL;
	}
	return RET_OK;
}
