#ifndef lint
static char *RCSid = "$Header: boar.c,v 1.8 90/03/19 11:14:48 mr-frog Exp $";
#endif /* not lint */

/*
 * boar.c
 *
 * board an enemy ship
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "nat.h"
#include "retreat.h"
#include "ship.h"
#include "news.h"
#include "file.h"
#include "treaty.h"
#include "sect.h"
#include "xy.h"
#include "item.h"
#include "nsc.h"
#include "land.h"

boar()
{
	int	dshpno;		/* defending shipno */
	int	ashpno;		/* attacking shipno */
	int	amil;		/* # attacking mil */
	int	dmil;		/* # defending mil */
	int	pmil;		/* prize crew */
	natid	d_cnum;		/* defender player->cnum */
	coord	a_x;		/* attacker x */
	coord	a_y;		/* attacker y */
	int	a_mob;		/* attacker mob */
	coord	d_x;		/* defender x */
	coord	d_y;		/* defender y */
	int	acas;		/* attacker casualties */
	int	dcas, dtot;	/* defender casualties */
	int	dam;		/* damage from shipdef() */
	struct	shpstr aship;	/* attacking ship */
	struct	shpstr dship;	/* defending ship */
	double	aspeed;
	double	dspeed;
	double	hitchance=0.33;
	struct	sctstr asect;
	int	from_ship=0;
	s_char	*ptr;
	struct	nstr_item ni;
	struct	lndstr land;
	s_char	buf[1024];

	if ((ptr = getstarg(player->argp[1], "Victim ship #? ", buf)) == 0)
		return RET_SYN;
	if ((dshpno = atoi(ptr)) < 0 || !getship(dshpno, &dship)) {
		pr("No such ship\n");
		return RET_FAIL;
	}
	if ((ptr = getstarg(player->argp[2], "Boarding party from? ", buf)) == 0)
		return RET_SYN;
	getsect(dship.shp_x,dship.shp_y,&asect);
	if (asect.sct_type == SCT_HARBR){
		if (!issector(ptr)){
			if ((ashpno = atoi(ptr)) < 0 ||
				!getship(ashpno, &aship) ||
	    			aship.shp_own != player->cnum)
				return RET_FAIL;
			from_ship = 1;
		}
	}
	else{
		 if ((ashpno = atoi(ptr)) < 0 || !getship(ashpno, &aship) ||
	    		aship.shp_own != player->cnum)
			return RET_FAIL;
		from_ship=1;
	}
	getship(ashpno, &aship);
	getship(dshpno, &dship);
	d_cnum = dship.shp_own;
	if (!trechk(player->cnum, d_cnum, SEAATT))
		return RET_FAIL;
	d_x = dship.shp_x;
	d_y = dship.shp_y;
	if (from_ship){
		a_x = aship.shp_x;
		a_y = aship.shp_y;
	}else{
		a_x = asect.sct_x;
		a_y = asect.sct_y;
		if (asect.sct_own != player->cnum){
			pr("Victim ship not in a harbor you own!\n");
			return RET_FAIL;
		}
	}
	if (a_x != d_x || a_y != d_y) {
		pr("Not in same sector!\n");
		return RET_FAIL;
	}

	if (from_ship)
		amil = getvar(V_MILIT, (s_char *)&aship, EF_SHIP);
	else
		amil = getvar(V_MILIT, (s_char *)&asect, EF_SECTOR);
	if (amil == 0) {
		if (from_ship)
#ifdef	SHIPNAMES
		pr("No military on %s %s(#%d)\n",
		       mchr[aship.shp_type].m_name, aship.shp_name, ashpno);
#else
		pr("No military on %s #%d\n",
		       mchr[aship.shp_type].m_name, ashpno);
#endif	SHIPNAMES
		else
			pr("No mil in %s!\n",xyas(a_x,a_y,player->cnum));
		return RET_FAIL;
	}

	if (from_ship)
		a_mob = aship.shp_mobil;
	else
		a_mob = asect.sct_mobil;
	if (a_mob <= 0) {
		if (from_ship)
#ifdef	SHIPNAMES
		pr("%s %s(#%d) has no mobility!\n",
			mchr[aship.shp_type].m_name, aship.shp_name, ashpno);
#else
		pr("%s #%d has no mobility!\n",
			mchr[aship.shp_type].m_name, ashpno);
#endif	SHIPNAMES
		else
			pr("Sector %s has no mobility!\n",xyas(a_x,a_y,player->cnum));
		return RET_FAIL;
	}
	if (mchr[dship.shp_type].m_flags & M_SUB) {
		if (asect.sct_type != SCT_HARBR){
		pr("You can't board a submarine!\n");
		return RET_FAIL;
		}
	}

	if (from_ship){
	if ((dam = shipdef(player->cnum,d_cnum,seadef(aship.shp_type), a_x, a_y)) > 0) {
		if(d_cnum != 0)
#ifdef	SHIPNAMES
		wu(0, d_cnum, "Return fire did %d%% damage to %s %s(#%d)\n",
			dam, mchr[aship.shp_type].m_name, aship.shp_name,
			ashpno);
#else
		wu(0, d_cnum, "Return fire did %d%% damage to %s #%d\n",
			dam, mchr[aship.shp_type].m_name, ashpno);
#endif	SHIPNAMES
		shipdamage(&aship, dam);
		putship(ashpno, &aship);
		if (aship.shp_effic < SHIP_MINEFF) {
			if(d_cnum != 0)
			wu(0, d_cnum,
#ifdef	SHIPNAMES
				"Country #%d lost %s %s(#%d) trying to board %s %s(#%d)\n",
				player->cnum, mchr[aship.shp_type].m_name,
				aship.shp_name, ashpno,
				mchr[dship.shp_type].m_name, dship.shp_name,
				dshpno);
#else
				"Country #%d lost %s #%d trying to board %s #%d\n",
				player->cnum, mchr[aship.shp_type].m_name, ashpno,
				mchr[dship.shp_type].m_name, dshpno);
#endif	SHIPNAMES
			nreport(player->cnum, N_SHP_LOSE, d_cnum, 1);
			return RET_OK;
		}
	}
	}else{
	if ((dam = shipdef(player->cnum, d_cnum,
		landdef(asect.sct_type), a_x, a_y)) > 0) {
		if(d_cnum != 0)
		wu(0, d_cnum, "Return fire did %d%% damage to %s\n",
			dam, xyas(a_x,a_y, d_cnum));
		sectdamage(&asect, dam);
		putsect(&asect);
	}
	}
	if (from_ship)
		getship(ashpno, &aship);
	else
		getsect(a_x,a_y, &asect);
	getship(dshpno, &dship);
	if (from_ship && (dship.shp_mobil > 0)) {
		aspeed = mchr[aship.shp_type].m_speed *
			aship.shp_effic / 100.0;
		dspeed = mchr[dship.shp_type].m_speed * 
			dship.shp_effic / 100.0;
		aspeed = techfact(aship.shp_tech, 1.0) * aspeed;
		dspeed = techfact(dship.shp_tech, 1.0) * dspeed;
		aship.shp_mobil -= (int) (127.0 / aspeed);
		dship.shp_mobil -= (int) (127.0 / aspeed);
		if (aspeed < dspeed) {
			pr("Victim ship moves faster than you do!");
			pr("  You can't catch him!\n");
			if(dship.shp_own != 0)
			wu(0, dship.shp_own,
#ifdef	SHIPNAMES
				"%s (#%d) %s %s(#%d) failed to catch %s %s(#%d)\n",
				cname(aship.shp_own), aship.shp_own,
				mchr[aship.shp_type].m_name, aship.shp_name,
				ashpno, mchr[dship.shp_type].m_name,
				dship.shp_name, dshpno);
#else
				"%s (#%d) %s #%d failed to catch %s #%d\n",
				cname(aship.shp_own), aship.shp_own,
				mchr[aship.shp_type].m_name, ashpno,
				mchr[dship.shp_type].m_name, dshpno);
#endif	SHIPNAMES
			aship.shp_mission = 0;
			putship(ashpno, &aship);
			putship(dshpno, &dship);
			return RET_OK;
		}
	}
	dmil = getvar(V_MILIT, (s_char *)&dship, EF_SHIP);
	snxtitem_xy(&ni, EF_LAND, dship.shp_x, dship.shp_y);
	while (nxtitem(&ni, (s_char *)&land)){
		if (land.lnd_ship != dship.shp_uid)
			continue;
		dmil += total_mil(&land);
	}

	if (from_ship){
		amil = getvar(V_MILIT, (s_char *)&aship, EF_SHIP);
		pr("%d attempting to board ship #%d\n", amil, dshpno);
	}else{
		amil = getvar(V_MILIT, (s_char *)&asect, EF_SECTOR);
		pr("%s attempting to board ship #%d\n",
			xyas(a_x,a_y,player->cnum), dshpno);
	}
	acas = amil;
	dcas = dmil;
	if (from_ship) hitchance=0.33; else hitchance = 0.75;
	while (1) {
		if (chance(hitchance) || dmil <= 0) {
			pr("!");
			if (--dmil <= 0)
				break;
		} else { 
			pr("@");
			if (--amil <= 0)
				break;
		}
	}
	acas -= amil;
	dcas -= dmil;
	dtot = dcas;
	if (amil > 0) {
		struct mchrstr *vbase;

		pr("Boarding successful!\n");
		if (from_ship){
		if(d_cnum != 0)
#ifdef	SHIPNAMES
		wu(0, d_cnum,
			"Country #%d %s %s (#%d) boarded %s %s(#%d)\n",
			player->cnum, mchr[aship.shp_type].m_name, aship.shp_name,
			aship.shp_uid, mchr[dship.shp_type].m_name,
			dship.shp_name, dshpno);
#else
		wu(0, d_cnum, "Country #%d %s (#%d) boarded %s #%d\n", player->cnum,
			mchr[aship.shp_type].m_name, aship.shp_uid,
			mchr[dship.shp_type].m_name, dshpno);
#endif	SHIPNAMES
		}else{
		if(d_cnum != 0)
#ifdef	SHIPNAMES
		wu(0, d_cnum, "Country #%d harbor police boarded %s %s(#%d)\n", player->cnum,
			mchr[dship.shp_type].m_name, dship.shp_name, dshpno);
#else
		wu(0, d_cnum, "Country #%d harbor police boarded %s #%d\n", player->cnum,
			mchr[dship.shp_type].m_name, dshpno);
#endif	SHIPNAMES
		}
		nreport(player->cnum, N_BOARD_SHIP, d_cnum, 1);
		takeover_ship(&dship, player->cnum, 1);
		dship.shp_fleet = ' ';

		vbase = &mchr[dship.shp_type];
		pmil = min(amil / 2, vl_find(V_MILIT, vbase->m_vtype,
			vbase->m_vamt, (int) vbase->m_nv));
		amil -= pmil;
		pr("%d of your troops hold%s ship %d\n", pmil,
			splur(dmil != 1), dshpno);
		if (from_ship){
		pr("%d return%s to ship %d\n", amil, splur(amil != 1),
			ashpno);
		if (getvar(V_PSTAGE, (s_char *)&dship, EF_SHIP) == PLG_INFECT) {
			if (getvar(V_PSTAGE, (s_char *)&aship, EF_SHIP) == 0)
				putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&aship,
				       EF_SHIP);
		}
		else if (getvar(V_PSTAGE, (s_char *)&aship, EF_SHIP) ==
			 PLG_INFECT) {
			if (getvar(V_PSTAGE, (s_char *)&dship, EF_SHIP) == 0)
				putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&dship,
				       EF_SHIP);
		}
		}else{
		pr("%d return%s to sector %s\n", amil, splur(amil != 1),
			xyas(a_x,a_y,player->cnum));
		if (getvar(V_PSTAGE, (s_char *)&dship, EF_SHIP) == PLG_INFECT) {
			if (getvar(V_PSTAGE, (s_char *)&asect, EF_SECTOR) == 0)
				putvar(V_PSTAGE, PLG_EXPOSED, (s_char *)&asect,
				       EF_SECTOR);
		}
		}
	} else {
		pr("\nYou have been repelled...\n");
		if(d_cnum != 0)
		if (from_ship){
#ifdef	SHIPNAMES
		wu(0, d_cnum, "Country #%d %s %s(#%d) tried to board %s %s(#%d)\n",
			player->cnum, mchr[aship.shp_type].m_name, aship.shp_name,
			ashpno, mchr[dship.shp_type].m_name, dship.shp_name,
			dshpno);
#else
		wu(0, d_cnum, "Country #%d %s #%d tried to board %s #%d\n",
			player->cnum, mchr[aship.shp_type].m_name, ashpno,
			mchr[dship.shp_type].m_name, dshpno);
#endif	SHIPNAMES
		}else{
#ifdef	SHIPNAMES
		wu(0, d_cnum, "Country #%d tried to board %s %s(#%d)\n",
			player->cnum, mchr[dship.shp_type].m_name, dship.shp_name,
			dshpno);
#else
		wu(0, d_cnum, "Country #%d tried to board %s #%d\n",
			player->cnum, mchr[dship.shp_type].m_name, dshpno);
#endif	/* SHIPNAMES */
		}
		nreport(player->cnum, N_SHP_LOSE, d_cnum, 1);
                if (dship.shp_rflags & RET_BOARDED)
                        retreat_ship(&dship, 'u');

	}
	if (from_ship){
		putvar(V_MILIT, amil, (s_char *)&aship, EF_SHIP);
		aship.shp_mission = 0;
		putship(ashpno, &aship);
	}else{
		putvar(V_MILIT, amil, (s_char *)&asect, EF_SECTOR);
		putsect(&asect);
	}

	if ((dmil>0) && (dcas > getvar(V_MILIT, (s_char *)&dship, EF_SHIP))){
		dcas -= getvar(V_MILIT, (s_char *)&dship, EF_SHIP);
		putvar(V_MILIT, 0, (s_char *)&dship, EF_SHIP);
		while(dcas > 0){
			int	nunits;

			nunits=0;
			snxtitem_xy(&ni, EF_LAND, dship.shp_x, dship.shp_y);
			while (nxtitem(&ni, (s_char *)&land)){
				if (land.lnd_ship != dship.shp_uid)
					continue;
				nunits++;
				landdamage(&land, 1);
				putland(land.lnd_uid,&land);
				dcas--;
			}
			if (nunits==0)
				/* all units dead, stop giving casualties */
				dcas=0;
		}
	}else if (dmil > 0)
		putvar(V_MILIT, dmil, (s_char *)&dship, EF_SHIP);
	else
		putvar(V_MILIT, pmil, (s_char *)&dship, EF_SHIP);

	putship(dshpno, &dship);
	pr("Casualties :\nYours ... %d\n", acas);
	pr("Theirs .. %d\n", dtot);
	player->btused += roundavg((dtot + acas) * 0.15 + 0.5);
	pr("Papershuffling ... %d B.T.U\n", player->btused);
	return RET_OK;
}
