/*
 * player.h
 *
 * per-player information
 *
 * Dave Pare, 1994
 */

#include "queue.h"

struct player {
	struct qelem queue;
	struct lwpProc *proc;
	s_char	remhost[32];
	s_char	remuser[32];
	int	validated;
	natid	cnum;
	int	state;
	int	running;
	struct iop *iop;
	s_char	combuf[512];
	s_char	*argp[64];
	s_char	*condarg;
	long	lasttime;
	int	ncomstat;
	int	minleft;
	int	btused;
	int	visitor;
	int	god;
	int	owner;
	int	nstat;
	int	waiting;
	double  dolcost;
	int	broke;
	long	curup;                   /* used in calc of minutes used */
	int	ismission;
	int	aborted;
	int	bol;		/* XXX for pr */
#ifdef BLITZ
	long	blitz_time;
#endif /* BLITZ */
	char	*map;			/* pointer to in-mem map */
};

#define PS_INIT		0
#define PS_LOGIN	1
#define PS_PLAYING	2
#define PS_SHUTDOWN	3
#define PS_KILL		4

/* thread priorities */
#define PP_UPDATE	4
#define PP_SCHED	3
#define PP_PLAYER	2
#define PP_ACCEPT	2
#define PP_KILLIDLE	1

extern struct player *player;		/* current player's context */

void		player_login();
void		player_main();
struct player	*player_new();
struct player	*player_delete();
struct player	*player_next();
struct player	*player_find_other();
void		player_accept();
