#ifndef lint
static char *RCSid = "$Header: aircombat.c,v 1.1 89/12/14 13:28:06 jay Exp $";
#endif

/*
 * aircombat.c
 *
 * Deal with air to air combat
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "news.h"
#include "ship.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "nat.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include "path.h"

static	getilist();

#define	DOG_MAX		15
#define FLAK_MAX	15

		/*       -7    -6    -5    -4    -3    -2    -1    0 */
float dogtable[16] = {	0.10, 0.15, 0.28, 0.45, 0.60, 0.75, 0.82, 1.00,
			1.10, 1.25, 1.60, 1.90, 2.25, 3.00, 4.15, 5.50, };
float flaktable[16] = {	0.30, 0.30, 0.35, 0.40, 0.40, 0.45, 0.50, 0.50,
			0.50, 0.55, 0.60, 0.65, 0.70, 0.75, 0.80, 0.85, };

ac_encounter(bomb_list, esc_list, x, y, path, mission_flags)
	struct	qelem *bomb_list;
	struct	qelem *esc_list;
	coord	x;
	coord	y;
	char	*path;
	int	mission_flags;
{
	int	val;
	int	rel;
	int	dir;
	int	nats[MAXNOC];
	int	gotilist[MAXNOC];
	int	unfriendly[MAXNOC];
	int	overfly[MAXNOC];
	struct	qelem ilist[MAXNOC];
	int	civ, mil;
	struct	sctstr sect;
	double	evade;
	double	tlev;
	double	diff;
	struct	shpstr ship;
	struct	nstr_item ni;
	natid	cn;
	struct	natstr *over;

	bzero((char *)overfly, sizeof(overfly));
	bzero((char *)gotilist, sizeof(gotilist));
	bzero((char *)unfriendly, sizeof(unfriendly));
#ifdef	INCARRANGE
	unfriendly[0] = 1;
#endif	INCARRANGE
	for (cn=1; cn<MAXNOC; cn++) {
		rel = getrel(getnatp(cn), cnum);
		if (rel != HOSTILE && rel != AT_WAR)
			continue;
		if (cnum == cn)
			continue;
		unfriendly[cn]++;
	}
	if (mission_flags & PM_R) {
		if (mission_flags & P_S) {
			pr("\nSPY Plane report\n");
			prdate();
			sathead();
		} else {
			pr("\nReconnaissance report\n");
			prdate();
		}
	}
	pln_removedupes(bomb_list, esc_list);
	while ((dir = *path++) && !QEMPTY(bomb_list)) {
		if ((val = chkdir(dir, DIR_STOP, DIR_LAST)) == 0)
			break;
		/* XXX using xnorm is probably bad */
		x = xnorm(x + diroff[val][0]);
		y = ynorm(y + diroff[val][1]);
		getsect(x, y, &sect);
		over = getnatp(sect.sct_own);
		if (unfriendly[sect.sct_own])
			if (mission_flags & P_X) {
				/* Stealth */
				tlev = (mission_flags >> 16);
				diff = tlev - over->nat_level[NAT_TLEV];
				evade = 0.88 + 0.12 * diff / tlev;
				if (!chance(evade))
					ac_doflak(bomb_list, &sect);
			} else
				ac_doflak(bomb_list, &sect);
		/* mission planes aborted due to flak -- don't send escorts */
		if (QEMPTY(bomb_list))
			break;
		if (mission_flags & PM_R) {
			if (sect.sct_type == SCT_WATER)
				continue;
			if (mission_flags & P_S) {
				satdisp(&sect, (mission_flags&P_I)?10:50);
			} else {
				/* This is borrowed from lookout */
				if (owner)
					pr("Your ");
				else
					pr(fmt("%s (#%d) ", cname(sect.sct_own),
						sect.sct_own));
				pr(dchr[sect.sct_type].d_name);
#if	defined(BMAP) || defined(AUTONAV)
				setbigmap(sect.sct_x, sect.sct_y,
					dchr[sect.sct_type].d_mnem);
#endif
				pr(fmt(" %d%% efficient ",
					owner ? sect.sct_effic :
					round((int)sect.sct_effic,25)));
				civ = getvar(V_CIVIL, (char *)&sect, EF_SECTOR);
				mil = getvar(V_MILIT, (char *)&sect, EF_SECTOR);
				if (civ)
					pr(fmt("with %s%d civ ",
					    owner ? "" : "approx ",
					    owner? civ : round(civ, 25)));
				if (mil)
					pr(fmt("with %s%d mil ",
						owner ? "" : "approx ",
						owner? mil : round(mil, 25)));
				pr(fmt("@ %s\n", xyas(x, y, cnum)));
			}
		} else {
			pr(fmt("flying over %s at %s\n",
				dchr[sect.sct_type].d_name,
				xyas(x, y, cnum)));
#if	defined(BMAP) || defined(AUTONAV)
			setbigmap(sect.sct_x, sect.sct_y,
				dchr[sect.sct_type].d_mnem);
#endif
		}
#ifdef	INCARRANGE
		if (sect.sct_own == cnum)
#else
		if (sect.sct_own == 0 || sect.sct_own == cnum)
#endif	INCARRANGE
			continue;
		if (mission_flags & P_X) {
			/* Stealth */
			tlev = (mission_flags >> 16);
			diff = tlev - over->nat_level[NAT_TLEV];
			evade = 0.88 + 0.12 * diff / tlev;
			if (chance(evade))
				continue;
		}
		if (unfriendly[sect.sct_own] && !gotilist[sect.sct_own]) {
			getilist(&ilist[sect.sct_own], sect.sct_own);
			gotilist[sect.sct_own]++;
		}
		if ((rel = getrel(over, cnum)) == ALLIED)
			continue;
		overfly[sect.sct_own]++;
#ifdef	INCARRANGE
		if (sect.sct_own)
		{
#endif	INCARRANGE
		wu(0, sect.sct_own, fmt("%s planes spotted over %s",
			cname(cnum), xyas(x, y, sect.sct_own)));
		if (rel == NEUTRAL)
			continue;
#ifdef	INCARRANGE
		};
#endif	INCARRANGE
		ac_intercept(bomb_list, esc_list, &ilist[sect.sct_own],
			sect.sct_own, x, y);
	}
#if	defined(BMAP) || defined(AUTONAV)
	writebigmap();
#endif
	if (QEMPTY(bomb_list) && QEMPTY(esc_list))
		return;
	bzero((char *)nats, sizeof(nats));
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (char *)&ship)) {
		if (mchr[ship.shp_type].m_flags & M_SUB)
			continue;
		nats[ship.shp_own]++;
	}
	ac_shipflak(bomb_list, x, y);
	for (cn=1; cn<MAXNOC && !QEMPTY(bomb_list); cn++) {
		if (cnum == cn)
			continue;
		if (overfly[cn] > 0)
			nreport(cnum, N_OVFLY_SECT, cn, overfly[cn]);
		if (nats[cn] == 0)
			continue;
		wu(0, cn, fmt("%s planes spotted over ships in %s",
			cname(cnum), xyas(x, y, cn)));
		if (!unfriendly[cn])
			continue;
		if (!gotilist[cn]) {
			getilist(&ilist[cn], cn);
			gotilist[cn]++;
		}
		pr(fmt("Flying over %d #%d ships...\n", nats[cn], cn));
		/* This makes going for ships in harbors tough */
		ac_intercept(bomb_list, esc_list, &ilist[cn], cn, x, y);
	}
}

ac_intercept(bomb_list, esc_list, def_list, def_own, x, y)
	struct	qelem *bomb_list;
	struct	qelem *esc_list;
	struct	qelem *def_list;
	natid	def_own;
	coord	x;
	coord	y;
{
	register struct plnstr *pp;
	register struct plchrstr *pcp;
	int	gas;
	struct	plist *ip;
	int	icount;
	struct	shpstr ship;
	struct	sctstr sect;
	struct	qelem *next;
	struct	qelem *qp;
	struct	qelem int_list;
	char	*ptr;
	int	type;
	int	att_count;
#ifdef	SHIPINTER
	int	fromship;
#endif	SHIPINTER

	icount = 0;
	att_count = 0;
#ifdef	SHIPINTER
	fromship = 0;
#endif	SHIPINTER
	for (qp = bomb_list->q_forw; qp != bomb_list; qp = qp->q_forw)
		att_count++;
	for (qp = esc_list->q_forw; qp != esc_list; qp = qp->q_forw)
		att_count++;
	initque(&int_list);
	for (qp = def_list->q_forw; qp != def_list; qp = next) {
		next = qp->q_forw;
		ip = (struct plist *) qp;
		pp = &ip->plane;
		pcp = ip->pcp;
		if (pp->pln_range/2 < mapdist(x, y, pp->pln_x, pp->pln_y))
			continue;
		if (pp->pln_ship >= 0) {
			getship(pp->pln_ship, &ship);
			type = EF_SHIP;
			ptr = (char *) &ship;
#ifdef	INCARRANGE
			if (!def_own) {
			    int	range;

			    range = (int)(techfact(ship.shp_tech,
				(double) mchr[ship.shp_type].m_vrnge) *
				ship.shp_effic);
			    if (range < mapdist(x, y, pp->pln_x, pp->pln_y))
					continue;
			}
#endif	INCARRANGE
		} else {
			getsect(pp->pln_x, pp->pln_y, &sect);
			type = EF_SECTOR;
			ptr = (char *) &sect;
		}
		gas = getvar(V_PETROL, ptr, type);
		if (gas < max((pcp->pl_fuel/2),1)) {
			remque(qp);
			free((char *)qp);
			continue;
		}
		/* got one; delete from def_list, add to int_list */
		remque(qp);
		insque(qp, &int_list);
		pp->pln_mobil -= 10;
		putplane(pp->pln_uid, pp);
		putvar(V_PETROL, gas - max((pcp->pl_fuel/2),1), ptr, type);
		if (pp->pln_ship >= 0) {
#ifdef	SHIPINTER
			fromship++;
#endif	SHIPINTER
			putship(pp->pln_ship, &ship);
		}
		else
			putsect(&sect);
		icount++;
#ifdef	SHIPINTER
		if ((icount - fromship) > att_count)
#else
		if (icount > att_count)
#endif	SHIPINTER
			break;
	}
	if (icount == 0)
		return;
	pr(fmt("%d %s fighter%s rising to intercept!\n", icount,
		cname(def_own), icount == 1 ? " is" : "s are"));
	ac_airtoair(esc_list, &int_list, def_own);
	ac_airtoair(bomb_list, &int_list, def_own);
#ifdef	SHIPINTER
	for (qp = int_list.q_forw; qp != &int_list; qp = qp->q_forw) {
		ip = (struct plist *) qp;
		pp = &ip->plane;
		pcp = ip->pcp;
		if (pp->pln_ship >= 0) {
			getship(pp->pln_ship, &ship);
			type = EF_SHIP;
			ptr = (char *) &ship;
			pp->pln_mobil += 10;
			putplane(pp->pln_uid, pp);
			gas = getvar(V_PETROL, ptr, type);
			putvar(V_PETROL,gas + max((pcp->pl_fuel/2),1),ptr,type);
		}
	}
#endif	SHIPINTER
}

/*
 * air-to-air combat.
 * The interceptors aren't affected by efficiency loss; they
 * always engage at 1:1 odds.
 */
ac_airtoair(att_list, int_list, def_own)
	struct	qelem *att_list;
	struct	qelem *int_list;
	natid	def_own;
{
	register struct plist *attacker;
	register struct plist *interceptor;
	struct	qelem *att;
	struct	qelem *in;
	int	nplanes;
	int	adam;
	int	idam;
	int	more_att;
	int	more_int;
	char	*mesg;
	struct	qelem *att_next;
	struct	qelem *in_next;

	att = att_list->q_forw;
	in = int_list->q_forw;
	more_att = 1;
	more_int = 1;
	if (QEMPTY(att_list) || QEMPTY(int_list)) {
		more_att = 0;
		more_int = 0;
	}
	while (more_att || more_int) {
		in_next = in->q_forw;
		att_next = att->q_forw;
		attacker = (struct plist *) att;
		interceptor = (struct plist *) in;
		mesg = fmt("  %s intercepts %s", interceptor->pcp->pl_name,
			attacker->pcp->pl_name);
		pr(mesg); pr("\n");
		wu(0, def_own, mesg);
		adam = idam = 0;
		nplanes = attacker->plane.pln_effic;
		if (nplanes > interceptor->plane.pln_effic)
			nplanes = interceptor->plane.pln_effic;
		if (interceptor->plane.pln_att)
			adam = ac_dog(interceptor, attacker, nplanes);
		if (interceptor->pcp->pl_flags & P_M)
			idam = 100;
		else if (attacker->plane.pln_att)
			idam = ac_dog(attacker, interceptor,
				min(nplanes, attacker->plane.pln_effic));
		if (adam > 0)
			ac_planedamage(attacker, interceptor->plane.pln_own,
				adam, def_own);
		if (idam > 0)
			ac_planedamage(interceptor, attacker->plane.pln_own,
				idam, def_own);
#ifdef	SHIPINTER
		if ((in_next->q_back != in) || (interceptor->plane.pln_ship < 0))
#endif	SHIPINTER
			in = in_next;
		att = att_next;
		if (att == att_list) {
			more_att = 0;
			if (QEMPTY(att_list))
				more_int = 0;
			else
				att = att->q_forw;
		}
		if (in == int_list) {
			more_int = 0;
			if (QEMPTY(int_list))
				more_att = 0;
			else
				in = in->q_forw;
		}
	}
}

int
ac_dog(ap, dp, nplanes)
	register struct plist *ap;
	register struct plist *dp;
	int	nplanes;
{
	int	n;
	float	mult;
	int	diff;

	diff = (ap->plane.pln_att - dp->plane.pln_def) / 2;
	if ((ap->pcp->pl_flags & P_F) && ap->bombs == 0)
		diff++;
	if (ap->pcp->pl_flags & P_X)
		diff += 3;
	if ((dp->pcp->pl_flags & P_F) && dp->bombs == 0)
		diff--;
	if (dp->pcp->pl_flags & P_X)
		diff -= 3;
	if (diff > 8)
		mult = dogtable[DOG_MAX] * 1.33;
	else if (diff < -7)
		mult = dogtable[0] * 0.66;
	else {
		diff += 7;
		mult = dogtable[diff];
	}
	n = roll(33) * mult * nplanes / 100.0;
	if (n > 100)
		n = 100;
	return n;
}

/*
 * zap plane associated with plp.
 * Damaging country is "from", damage is "dam".
 * def_own is the country on the other side of the conflict from cnum.
 * The only time def_own != from is when the interceptor is getting damaged.
 *
 * NOTE: This routine removes the appropriate plane element from the
 * queue if it gets destroyed.  That means that the caller must assume
 * that the current queue pointer is invalid on return from the ac_planedamage
 * call.  (this has caused bugs in the past)
 */
ac_planedamage(plp, from, dam, def_own)
	struct	plist *plp;
	natid	from;
	int	dam;
	natid	def_own;
{
	register struct plnstr *pp;
	int	disp;
	char	*dmess;
	int	eff;
	char	*mesg;
	struct shpstr ship;

	disp = 0;
	pp = &plp->plane;
	eff = pp->pln_effic;
	if (dam <= 0)
		return;
	dmess = "";
	eff -= dam;
	if (eff < 0)
		eff = 0;
	if (eff < 10) {
		dmess = " -- shot down";
		disp = 1;
	} else if (chance((dam*4)/100.0)) {
		dmess = " -- aborted";
		disp = 2;
	}
	if ((plp->pcp->pl_flags & P_M) == 0) {
		mesg = fmt("    %s (#%d) takes %d%s.",
			plp->pcp->pl_name, pp->pln_uid, dam, dmess);
		pr(mesg); pr("\n");
		wu(0, def_own, mesg);
	}
	pp->pln_effic = eff;
	if (disp == 1) {
		if (from != 0 && (plp->pcp->pl_flags & P_M) == 0)
			nreport(from, N_DOWN_PLANE, pp->pln_own, 1);
		if (pp->pln_ship >= 0) {
		    getship(pp->pln_ship,&ship);
		    ship.shp_nplane--;
		    putship(pp->pln_ship,&ship);
		}
		pp->pln_own = 0;
		putplane(pp->pln_uid, pp);
		remque(&plp->queue);
		free((char *)plp);
	} else if (disp == 2) {
		putplane(pp->pln_uid, pp);
		remque(&plp->queue);
		free((char *)plp);
	} else
		putplane(pp->pln_uid, pp);
}

ac_doflak(list, from)
	struct	qelem *list;
	struct	sctstr *from;
{
	int	shell;
	int	gun;

	shell = getvar(V_SHELL, (char *)from, EF_SECTOR);
	gun = getvar(V_GUN, (char *)from, EF_SECTOR);
	if (gun == 0 || shell == 0)
		return;
	if (gun > shell*2)
		gun = shell*2;
	if (gun > 14)
		gun = 14;
	putvar(V_SHELL, shell - gun/2, (char *)from, EF_SECTOR);
	gun = 2.0 * tfact(from->sct_own, (double) gun);
	if (gun > 0) {
		pr(fmt("firing %d flak guns in %s...\n",
			gun, xyas(from->sct_x, from->sct_y, cnum)));
		wu(0, from->sct_own, fmt("firing %d flak guns in %s...",
			gun, xyas(from->sct_x, from->sct_y, from->sct_own)));
		ac_fireflak(list, from->sct_own, gun);
	}
}

ac_shipflak(list, x, y)
	struct	qelem *list;
	coord	x;
	coord	y;
{
	struct	nstr_item ni;
	struct	shpstr ship;
	struct	mchrstr *mcp;
	int	firing;
	int	gun;
	int	shell;
	int	rel;
	char	*msg;

	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (!QEMPTY(list) && nxtitem(&ni, (char *)&ship)) {
		if (ship.shp_own == 0 || ship.shp_own == cnum)
			continue;
		mcp = &mchr[ship.shp_type];
		if (mcp->m_flags & M_SUB)
			continue;
		rel = getrel(getnatp(ship.shp_own), cnum);
		if (rel != AT_WAR && rel != HOSTILE)
			continue;
		gun = min(getvar(V_GUN, (char *)&ship, EF_SHIP), mcp->m_glim);
		shell = getvar(V_SHELL, (char *)&ship, EF_SHIP);
		if (gun == 0 || shell == 0)
			continue;
		firing = (int) (techfact(ship.shp_tech, (double)gun) * 4.0);
#ifdef	SHIPNAMES
		msg = fmt("firing %d flak guns from %s %s(#%d)...",
			firing, mcp->m_name, ship.shp_name, ship.shp_uid);
#else
		msg = fmt("firing %d flak guns from %s #%d...",
			firing, mcp->m_name, ship.shp_uid);
#endif	SHIPNAMES
		pr(msg); pr("\n");
		wu(0, ship.shp_own, msg);
		ac_fireflak(list, ship.shp_own, firing);
		putvar(V_SHELL, shell - 1, (char *)&ship, EF_SHIP);
		putship(ni.cur, &ship);
	}
}

/*
 * Called from shipflak and doflak.
 */
ac_fireflak(list, from, guns)
	struct	qelem *list;
	natid	from;
	int	guns;
{
	extern	double flakscale;
	register struct plnstr *pp;
	struct	plist *plp;
	int	n;
	float	mult;
	int	diff;
	struct	qelem *qp;
	struct	qelem *next;

	for (qp = list->q_forw; qp != list; qp = next) {
		/*
		 * fighters don't get shot at by flak
		 * non-tactical bombers are harder to hit with flak.
		 * ('Cause they're not dive-bombing?)
		 */
		next = qp->q_forw;
		plp = (struct plist *) qp;
		pp = &plp->plane;
		diff = guns - pp->pln_def;
		if ((plp->pcp->pl_flags & P_T) == 0)
			diff--;
		if (plp->pcp->pl_flags & P_X)
			diff -= 2;
		if (diff > 8)
			mult = flaktable[FLAK_MAX] * 1.33;
		else if (diff < -7)
			mult = flaktable[0] * 0.66;
		else {
			diff += 7;
			mult = flaktable[diff];
		}
		mult *= flakscale;
		n = (int) ((roll(8) + 2) * mult);
		if (n > 100)
			n = 100;
		ac_planedamage(plp, from, (int)(n * pp->pln_effic / 100.0),
			from);
	}
}

/*
 * Get a list of planes available for interception duties.
 */
static
getilist(list, own)
	struct	qelem *list;
	natid	own;
{
	register struct plchrstr *pcp;
	struct	plnstr plane;
	struct	shpstr ship;
	struct	sctstr sect;
	struct	nstr_item ni;
	int	type;
	char	*ptr;
	struct	plist *ip;

	initque(list);
	snxtitem_all(&ni, EF_PLANE);
	while (nxtitem(&ni, (char *)&plane)) {
#ifdef	INCARRANGE
		if (own && (plane.pln_own != own))
#else
		if (plane.pln_own != own)
#endif	INCARRANGE
			continue;
		pcp = &plchr[plane.pln_type];
		if ((pcp->pl_flags & P_F) == 0)
			continue;
		if (plane.pln_mobil <= 0)
			continue;
		if (plane.pln_effic < 40)
			continue;
#ifdef	INCARRANGE
		if (!own) {
			int	rel;

			rel = getrel(getnatp(plane.pln_own), cnum);
			if (rel != HOSTILE && rel != AT_WAR)
				continue;
			if (cnum == plane.pln_own)
				continue;
		}
#endif	INCARRANGE
		if (plane.pln_ship >= 0) {
			if (!getship(plane.pln_ship, &ship) ||
#ifdef	SHIPSAM
			    ((((mchr[ship.shp_type].m_flags & M_FLY) == 0) ||
			    (pcp->pl_flags & P_M)) &&
			    !((mchr[ship.shp_type].m_flags & M_MSL) &&
			    (pcp->pl_flags & P_M))) ||
#else
			    (mchr[ship.shp_type].m_flags & M_FLY) == 0 ||
#endif	SHIPSAM
			    ship.shp_own != plane.pln_own)
				continue;
			ptr = (char *)&ship;
			type = EF_SHIP;
		} else {
			getsect(plane.pln_x, plane.pln_y, &sect);
			ptr = (char *)&sect;
			type = EF_SECTOR;
			if (sect.sct_effic < 60 && (pcp->pl_flags & P_V) == 0)
				continue;
		}
		if (getvar(V_PETROL, ptr, type) < max((pcp->pl_fuel/2),1))
			continue;
		/* got one! */
		ip = (struct plist *) malloc(sizeof(*ip));
		ip->state = P_OK;
		ip->bombs = 0;
		ip->misc = 0;
		ip->pcp = &plchr[plane.pln_type];
		bcopy((char *)&plane, (char *)&ip->plane, sizeof(plane));
		insque(&ip->queue, list);
	}
}

#ifdef	ABM

/*
 * Get a list of nuclear interceptors (not including sats).     
 *
 * Alex Shatsky (lex@ucscb.ucsc.edu)
 *
 * liberally borrowed from getilist.
 */
static
getirvlist(list, own)
	struct	qelem *list;
	natid	own;
{
	register struct plchrstr *pcp;
	struct 	plnstr plane;
	struct 	shpstr ship;
	struct 	sctstr sect;
	struct	nstr_item ni;
	int	type;
	char	*ptr;
	struct	plist *irv;

	initque (list);
	snxtitem_all (&ni, EF_PLANE);
	while (nxtitem (&ni, (char *)&plane)) {
#ifdef	BETTERABM
		if (plane.pln_own == 0)
			continue;
		
		if (getrel(getnatp(plane.pln_own), own) == ALLIED)
			continue;
#else
		if (plane.pln_own != own)
			continue;
#endif	BETTERABM
		pcp = &plchr[plane.pln_type];
 		if ((pcp->pl_flags & P_N) == 0)
			continue;
		/* Ignore satellites */
		if (!(pcp->pl_flags & P_O) == 0)
			continue;
		if (plane.pln_mobil <= 0)
			continue;
		if (plane.pln_effic < 100)
			continue;
		if (plane.pln_ship >= 0) {
			if (!getship(plane.pln_ship, &ship) ||
			    (mchr[ship.shp_type].m_flags & M_MSL) == 0 ||
			    ship.shp_own != plane.pln_own)
				continue;
			ptr = (char *)&ship;
			type = EF_SHIP;
		} else {
			getsect (plane.pln_x, plane.pln_y, &sect);
			ptr = (char *)&sect;
			type = EF_SECTOR;
		}
		if (getvar(V_PETROL, ptr, type) < max((pcp->pl_fuel/2),1))
			continue;
		/* got a valid interceptor */
		irv = (struct plist *) malloc(sizeof(*irv));
		irv->state = P_OK;
		irv->bombs = 0;
		irv->misc = 0;
		irv->pcp = &plchr[plane.pln_type];
		bcopy((char *)&plane, (char *)&irv->plane, sizeof(plane));
		insque(&irv->queue, list);
	}
}

/*
 * Attempt to intercept an incoming warhead.  Return 1 if warhead is 
 * successfully destroyed.
 * This really should not allow the safe targeting of unowned adjoining
 * sectors (water, etc.), but it does.
 *
 * Alex Shatsky (lex@ucscb.ucsc.edu)
 */
short
rv_intercept(x, y, bombown)
	coord 	x;
	coord	y;
	natid	bombown;
{
	register struct plnstr *pp;
	register struct plchrstr *pcp;
	register struct plist *interceptor;
	struct	sctstr  sect;
	struct	natstr  *over;
	struct	qelem	*irvlist;
	struct	qelem	foo;
	struct	qelem	int_list;
	struct  qelem	*qp;
	struct	qelem	*next;
	struct 	qelem	*in;
	struct  plist	*ip;
	struct	sctstr	psect;
	struct	shpstr	pship;
	int 	icount = 0;
	int 	type;
	int	gas;
	char	*ptr;
	short	destroyed = 0;
	

	irvlist = &foo;
	getsect(x, y, &sect);
#ifdef	BETTERABM
	getirvlist(irvlist, bombown);
#else
	getirvlist(irvlist, sect.sct_own);
#endif	BETTERABM
	wu(0, sect.sct_own, fmt("%s nuclear device incoming on sector %s", 
		cname(bombown), xyas(x, y, sect.sct_own)));
	initque (&int_list);
	for (qp = irvlist->q_forw; qp != irvlist; qp = next) {
		next = qp->q_forw;
		ip = (struct plist *)qp;
		pp = &ip->plane;
		pcp = ip->pcp;
		if (pp->pln_range/2 < mapdist(x, y, pp->pln_x, pp->pln_y))
			continue;
		if (pp->pln_ship >= 0) {
			getship(pp->pln_ship, &pship);
			type = EF_SHIP;
			ptr = (char *)&pship;
		} else {
			getsect (pp->pln_x, pp->pln_y, &psect);
			type = EF_SECTOR;
			ptr = (char *)&psect;
		}
		gas = getvar(V_PETROL, ptr, type);
		if (gas < max((pcp->pl_fuel/2),1)) {
			remque(qp);
			free((char *)qp);
			continue;
		}
		/* got one interceptor, delete from irv_list and   
   		 * add to  int_list.
    		 */
		remque(qp);
		insque(qp, &int_list);
		putplane(pp->pln_uid, pp);
		putvar(V_PETROL, gas - max((pcp->pl_fuel/2),1), ptr, type);
		if (pp->pln_ship >= 0)
			putship (pp->pln_ship, &pship);
		else putsect(&psect);
		/* only allow two abms per warhead */
		if (++icount == 2)
			break;
	}
	if (icount == 0) {
 		wu (0, sect.sct_own, fmt("No abms launched to intercept.\n"));
		return (destroyed);
	}
#ifndef	BETTERABM
	pr (fmt("%d %s abm%s launched in defense!\n", icount, 
		 cname(sect.sct_own), icount == 1 ? " is": "s are"));
	wu(0, sect.sct_own, fmt("%d abm%s launched in defense!\n", icount,
		 icount == 1 ? " was": "s were"));
#endif	BETTERABM
	/* attempt to destroy warhead */
/*	in = &int_list->q_forw; */
	in = int_list.q_forw;
	while (!(QEMPTY(&int_list))) {
		interceptor = (struct plist *)in;
#ifdef	BETTERABM
		pr (fmt("%s abm launched in defense!\n",
			 cname(interceptor->plane.pln_own)));
		if (sect.sct_own == interceptor->plane.pln_own) {
		    wu(0, sect.sct_own, "abm launched in defense!\n");
		}
		else
		{
		    wu(0, sect.sct_own, fmt("%s abm launched in defense!\n",
			cname(interceptor->plane.pln_own)));
		    wu(0, interceptor->plane.pln_own,
			fmt("abm launched to defend %s!\n",
				cname(sect.sct_own)));
		}
#endif	BETTERABM
		if (chance(interceptor->plane.pln_att/100.0) && !destroyed)  {
#ifdef	BETTERABM
			pr (fmt("Nuclear device destroyed by %s abm!\n",
				 cname(interceptor->plane.pln_own)));
#else
			pr (fmt("Nuclear device destroyed by %s abm!\n",
				 cname(sect.sct_own)));
#endif	BETTERABM
			wu(0, sect.sct_own, 
				fmt("%s nuclear device intercepted!\n",
			    	     cname(bombown)));
#ifdef	BETTERABM
			if (sect.sct_own != interceptor->plane.pln_own)
				wu(0, interceptor->plane.pln_own, 
					fmt("%s nuclear device intercepted!\n",
					     cname(bombown)));
#endif	BETTERABM
			destroyed = 1;
			/* the news knows all... */
#ifdef	BETTERABM
			nreport(bombown, N_NUKE_STOP,
			    interceptor->plane.pln_own, 1);
#else
			nreport(bombown, N_NUKE_STOP, sect.sct_own, 1);
#endif	BETTERABM
     		}
		/* zap the missile */
#ifdef	BETTERABM
		interceptor->plane.pln_own = 0;
		putplane(interceptor->plane.pln_uid, &(interceptor->plane));
		remque(&interceptor->queue);
		free((char *)interceptor);
#else
		ac_planedamage(interceptor, bombown, 100, sect.sct_own);
#endif	BETTERABM
		in = in->q_forw;
	}
	if (destroyed) return (destroyed);
	pr (fmt("Nuclear device made it through abm defenses!\n"));
	wu(0, sect.sct_own, fmt("Abm interception failed.\n"));
	return (destroyed);
}

#endif	ABM
