#ifndef lint
static char *RCSid = "$Header: deli.c,v 1.6 89/11/14 21:59:56 mr-frog Exp $";
#endif /* not lint */

/*
 * deli.c
 *
 *  Parse <THRESH> <DIR> or <DIR> <THRESH>.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "xy.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "file.h"
#include "path.h"
#include "nsc.h"
#include "nat.h"

int
deli()
{
	extern	char *argp[];
	struct sctstr sect;
	register char *buf;
	register int dir;
	register struct ichrstr *ich;
	register int thresh;
	register int threshtype;
	int     threshval;
	int     threshn;
	int	dirn;
	int     threshold;
	int     deliv;
	int	i_del;
	int	sx, sy;
	struct nstr_sect nstr;

	if ((ich = whatitem(argp[1], "deliver what? ")) == 0)
		return RET_SYN;
	if (ich->i_vtype == V_CIVIL || ich->i_vtype == V_MILIT) {
		pr("You cannot deliver people!\n");
		return RET_FAIL;
	}
	if (!snxtsct(&nstr, argp[2]))
		return RET_SYN;
	i_del = V_DEL(ich-ichr);

	threshtype = ' ', threshval = 0;
	threshn = -1, dirn = -1;
	if (argp[3] != 0) {
		if (index("(+-"/*)*/, argp[3][0]) != 0) {
			threshn = 3;
			if (argp[4] != 0)
				dirn = 4;
		} else if (argp[4] != 0 && index("(+-"/*)*/, argp[4][0]) != 0) {
			threshn = 4;
			dirn = 3;
		} else if (argp[4] == 0)
			dirn = 3;
		else
			return RET_SYN;
		if (dirn != -1 && chkdir(argp[dirn][0], 0, 6) < 0)
			return RET_SYN;
		if (threshn != -1) {
			if (argp[threshn][0] == '(') {
				threshtype = '(';
				threshval = atopi(argp[threshn] + 1);
			} else if (argp[threshn][0] == '+') {
				threshtype = '+';
				threshval = atopi(argp[threshn] + 1);
			} else if (argp[threshn][0] == '-') {
				threshtype = '-';
			} else {
				return RET_SYN;
			}
		}
	}

	if (threshtype == ' ') {
		if (dirn != -1 &&
		    chkdir(argp[dirn][0], DIR_STOP, DIR_LAST) == DIR_STOP)
			threshtype = '(';
		else
			return RET_SYN;
	}
	if (threshtype == '+')	/* set level, do not change direction */
		while (nxtsct(&nstr, &sect) > 0) {
			if (!owner)
				continue; 
			threshold = threshval;
			dir = getvar(i_del, (char *)&sect, EF_SECTOR) & 0x7;
			thresh = threshold & ~0x7;
			if (!putvar(i_del, thresh + dir, (char *)&sect, EF_SECTOR)) {
				pr(fmt("No room for delivery path in %s\n",
					xyas(sect.sct_x, sect.sct_y, cnum)));
				return RET_SYS;
			} else
				putsect(&sect);
		}
	else if (threshtype == '(')	/* set level and change direction */
		while (nxtsct(&nstr, &sect)) {
			if (!owner)
				continue; 
			threshold = threshval;
			dir = -1;
			while (1) { /* loop until we get a valid deliv. dir */
				if (dirn != -1 && argp[dirn] != 0)
					buf = argp[dirn];
				else {
					pr(fmt("Deliver %s from %s @ %s ",
					       ich->i_name,
					       dchr[sect.sct_type].d_name,
					       xyas(sect.sct_x, sect.sct_y,
						       cnum)));
					buf = getstring("in which direction? ");
				}
				if (!buf || !*buf)
					break;	/* ignore dir change */
				dir = chkdir(*buf, 0, 6);
				if (dir >= 0) {	/* a valid direction */
					if (dir == 0) { /* hold delivs */
						threshold = 0;
					} else {
						/* maybe a new thresh too? */
						while (*buf && *buf++ != '(') ;
						if (*buf != 0)
							threshold = atopi(buf);
					}
					break;	/* we are all happy */
				}
				direrr(
				"%c for no delivery, <CR> for no change.\n",
						(char *)0, (char *)0);
			}
			if (dir < 0)	/* Get what was */
				dir = getvar(i_del, (char *)&sect, EF_SECTOR)
					& 0x7;
			thresh = threshold & ~0x7;

			if (putvar(i_del, thresh + dir, (char *)&sect, EF_SECTOR) >= 0)
				putsect(&sect);
			else
				pr(fmt("No room for delivery path in %s\n",
					xyas(sect.sct_x, sect.sct_y, cnum)));
		}
	else /* if (threshtype == '-') */ /* examine delivery routes */
		while (nxtsct(&nstr, &sect)) {
			if (!owner)
				continue;
			deliv = getvar(i_del, (char *)&sect, EF_SECTOR);
			if (deliv != 0) {
				dir = deliv & 0x7;
				sx = diroff[dir][0] + sect.sct_x;
				sy = diroff[dir][1] + sect.sct_y;
				pr(fmt("Deliver %s from %s @ %s to %s",
					ich->i_name,
					dchr[sect.sct_type].d_name,
					xyas(sect.sct_x, sect.sct_y, cnum),
					xyas(sx, sy, cnum)));
				if (!(deliv & ~0x7))
					pr("\n"); /* no cutoff */
				else
					pr(fmt(" (cutoff %d)\n", deliv & ~0x7));
			}
		}

	return RET_OK;
}
