#ifndef lint
static char *RCSid = "$Header: fsize.c,v 1.5 89/09/26 19:49:59 mr-frog Exp $";
#endif

/*
 * fsize.c
 *
 * BSD dependent file and block sizing routines.
 *
 * Dave Pare, 1986
 */

#include "misc.h"

#include <fcntl.h>
#include <sys/stat.h>

/*
 * return the size of the file in bytes.
 */
int
fsize(fd)
	int	fd;
{
	struct	stat statb;

	if (fstat(fd, &statb) < 0)
		return -1;
	return statb.st_size;
}

/*
 * return the block size of the filesystem
 * If it's not a filesystem, return 1024.
 */
int
blksize(fd)
	int	fd;
{
#ifndef aix
	struct	stat statb;

	if (fstat(fd, &statb) < 0)
		return 1024;
	return statb.st_blksize;
#else
	return 1024;
#endif
}

time_t
fdate(fd)
	int	fd;
{
	struct	stat statb;

	if (fstat(fd, &statb) < 0)
		return 0;
	return statb.st_mtime;
}


filetruncate(name)
	char	*name;
{
	close(open(name, O_RDWR|O_TRUNC, 0660));
}
