#ifndef lint
static char *RCSid = "$Header: main.c,v 1.14 90/03/19 10:45:45 mr-frog Exp $";
#endif

/*
 * main.c
 *
 * main command loop and initialization
 * for empire tm server
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "tm.h"
#include "bit.h"
#include "nat.h"
#include "file.h"
#include "io_mask.h"
#include "io.h"

#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/un.h>
#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <fcntl.h>

extern	int errno;

char	*program = "update";
int	(*leprfunc)();
int	aborted;

long	money[MAXNOC];
long	pops[MAXNOC];
long	sea_money[MAXNOC];
long	air_money[MAXNOC];
natid	cnum = 0;

main(argc, argv)
	int	argc;
	char	**argv;
{
	extern	int etu_per_update;
	long	now;
	int	etu;
	int	produce;
	int	n;
	struct	natstr *np;

	if (argc < 3) {
		logerror("usage: %s \"produce|mob\" #etus\n", program);
		exit(1);
	}
	time(&now);
	srandom(now);
	produce = 0;
	if (strcmp(argv[1], "produce") == 0)
		produce = 1;
	else if (strcmp(argv[1], "mob") != 0) {
		logerror("no such update type %s\n", argv[1]);
		exit(1);
	}
	if ((etu = atoi(argv[2])) <= 0) {
		logerror("etu value must be positive\n");
		exit(1);
	}
	if (etu != etu_per_update) {
		logerror("warning: etu_per_update: %d, argv[2]: %d",
			etu_per_update, etu);
	}
	errno = 0;
	logerror("%s update pid %d", argv[1], getpid());
	io_init();
	if (!tm_connect()) {
		logerror("can't connect to transaction manager");
		exit(1);
	}
	ef_open(EF_NATION, O_RDONLY, EFF_MEM);
	ef_open(EF_SECTOR, O_RDWR, EFF_MEM);
	ef_open(EF_SHIP, O_RDWR, EFF_MEM);
	ef_open(EF_PLANE, O_RDWR, EFF_MEM);
	if (produce) {
		/*
		 * set up all the variables which get used in the
		 * sector production routine (for producing education,
		 * happiness, and printing out the state of the nation)
		 */
		logerror("production update (%d etus)", etu);
		ef_open(EF_NEWS, O_RDWR, 0);
		bzero((char *)pops, sizeof(pops));
		bzero((char *)air_money, sizeof(air_money));
		bzero((char *)sea_money, sizeof(sea_money));
		for (n=0; n<MAXNOC; n++) {
			money[n] = 0;
			if ((np = getnatp(n)) == 0)
				continue;
			money[n] = np->nat_money;
		}
		prod_ship(etu);
		prod_plane(etu);
		/*
		 * NOTE: prod_sect MUST be last after all other production
		 * in order to have a proper tally of the pop and money
		 * used this update
		 */
		prod_sect(etu);
		prod_nat(etu);
		age_levels(etu);
		ef_close(EF_NEWS);
		flushwu();
	}
	mob_ship(etu);
	mob_sect(etu);
	mob_plane(etu);
	ef_close(EF_SECTOR);
	ef_close(EF_SHIP);
	ef_close(EF_PLANE);
#ifdef DEMANDUPDATE
	update_removewants();
#endif DEMANDUPDATE
	ef_close(EF_NATION);
	/*system("../backup");*/
	logerror("End %s update", argv[1]);
	tm_exit(0);
}

tm_exit(code)
	int	code;
{
	extern	iop_t iop;

	io_input(iop);			/* ignore input */
	io_noblocking(iop, 0);
	while (io_output(iop) > 0)
		;
	io_close(iop);
	logerror("exiting");
	exit(code);
}
