#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/client/RCS/main.c,v 1.9 89/09/08 01:17:24 mr-frog Exp $";
#endif /* not lint */

/*
 * main.c
 *
 * front end to empire
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "proto.h"
#include "queue.h"
#include "ioqueue.h"
#include "bit.h"

#include <stdio.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>

extern int errno;

#define	RETRY	3

int	interrupt;
int	sock;

main(ac, av)
	int	ac;
	char	*av[];
{
	extern	char *getenv();
	int	intr();
	extern	char empireport[];
	extern	char empirehost[];
	bit_fdmask mask;
	struct	ioqueue server;
	bit_fdmask savemask;
	char	*argv[128];
	int	i, j;
	char	*ptr;
	char	*auxout_fname;
	FILE	*auxout_fp;
	struct	passwd *pwd;
	struct	sockaddr_in sin;
	int	n;
	char	*cname;
	char	*pname;
	int	retry = 0;
	int	send_kill = 0;

	mask = bit_newfdmask();
	savemask = bit_newfdmask();
	bzero((char *)argv, sizeof(argv));
	saveargv(ac, av, argv);
	auxout_fname = 0;
	auxout_fp = 0;
	for (i = j = 1; i < ac; ++i) {
		ptr = argv[i];
		if (strcmp(ptr, "-2") == 0) {
			if (i + 1 >= ac) {
				fprintf(stderr, "-2: Missing filename!\n");
				exit(1);
			}
			auxout_fname = argv[i+1];
			++i;
			continue;
		}
		else if (strcmp(ptr, "-k") == 0) {
			send_kill = 1;
			continue;
		}
		argv[j] = argv[i];
		++j;
	}
	ac = j;
	if (auxout_fname && (auxout_fp = fopen(auxout_fname, "a")) == NULL) {
		fprintf(stderr, "Unable to open %s for append\n", auxout_fname);
		exit(1);
	}
/*	pwd = getpwuid(getuid());
	if (pwd == NULL) {
		fprintf(stderr, "You don't exist.  Go away\n");
		exit(1);
	}*/
	getsose();
	if (!hostport(getenv("EMPIREPORT"), &sin) &&
	    !hostport("empire", &sin) &&
	    !hostport(empireport, &sin)) {
		fprintf(stderr, "No empire port\n");
		exit(1);
	}
	if (!hostaddr(getenv("EMPIREHOST"), &sin) && 
	    !hostaddr(empirehost, &sin)) {
		fprintf(stderr, "No empire host\n");
		exit(1);
	}
	if ((sock = hostconnect(&sin)) < 0)
		exit(1);
	cname = getenv("COUNTRY");
	pname = getenv("PLAYER");
	if (ac > 1)
		cname = argv[1];
	if (ac > 2)
		pname = argv[2];
	if (!login(sock, getlogin(), cname, pname, send_kill))
		exit(1);
	ioq_init(&server, 2048);
	mask = bit_newfdmask();
	BIT_SETB(0, savemask);
	BIT_SETB(sock, savemask);
	(void) signal(SIGINT, intr);
	(void) signal(SIGPIPE, SIG_IGN);
	while (BIT_ISSETB(sock, savemask)) {
		bit_copy(savemask, mask);
		n = select(sock+1, mask, (int *)0, (int *)0,
			(struct timeval *)0);
		if (interrupt) {
			if (!handleintr(sock))
				break;
			errno = 0;
		}
		if (n <= 0) {
			if (errno == EINTR) {
				perror("select");
				(void) close(sock);
				BIT_CLRB(sock, savemask);
			}
		} else {
			if (BIT_ISSETB(0, mask)) {
				if (!termio(0, sock, auxout_fp)) {
					if (retry++ >= RETRY)  {
						BIT_CLRB(0, savemask);
					}
				} else {
					retry = 0;
				}
			}
			if (BIT_ISSETB(sock, mask)) {
				if (!serverio(sock, &server))
					BIT_CLRB(sock, savemask);
				else
					servercmd(&server, auxout_fp);
			}
		}
	}
	ioq_drain(&server);
	(void) close(sock);
	exit(0);
}

intr()
{
	interrupt++;
#ifdef hpux
	signal(SIGINT, intr);
#endif
}
