#ifndef lint
static char *RCSid = "$Header: vchk.c,v 1.4 89/09/26 19:54:34 mr-frog Exp $";
#endif

#include "misc.h"
#include "nat.h"
#include "sect.h"
#include "var.h"
#include "file.h"
#include "item.h"

#include <fcntl.h>

char	*program = "vchk";
int	(*leprfunc)();

main()
{
	register struct sctstr *sp;
	register int n;
	short	vars[256];
	register u_char *type;
	register u_short *amt;
	struct	ichrstr *ip;
	int	i;

	ef_open(EF_SECTOR, O_RDWR, EFF_MEM);
	for (i=0; sp = getsectid(i); i++) {
		if (sp->sct_nv > MAXSCTV) {
			printf("(%d) sct_nv: %d\n", i, sp->sct_nv);
			continue;
		}
		type = sp->sct_vtype;
		amt = sp->sct_vamt;
		bzero(vars, sizeof(vars));
		for (n=0; n < sp->sct_nv; n++) {
			if (vars[type[n]] != 0) {
				ip = &ichr[type[n] & ~VT_TYPE];
				printf("(%d) duplicate VT #%d (%s), amt %d\n",
					i, type[n], ip->i_name, amt[n]);
			}
			if (amt[n] > 32767) {
				ip = &ichr[type[n] & ~VT_TYPE];
				printf("(%d) bad amt, VT #%d (%s), amt %d\n",
					i, type[n], ip->i_name, amt[n]);
				printf("  (reset to 15000)\n");
				amt[n] = 15000;
			}
			vars[type[n]]++;
		}
	}
	ef_close(EF_SECTOR);
	return 0;
}
