#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/update/RCS/plane.c,v 1.9 89/09/18 00:55:40 mr-frog Exp $";
#endif

/*
 * plane.c
 *
 * do "production" for planes -- make more efficient,
 * charge for military, etc.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "plane.h"
#include "ship.h"
#include "nat.h"
#include "file.h"

int
prod_plane(etus)
	int	etus;
{
	extern	double money_mil;
	extern	double money_plane;
	extern	long money[MAXNOC];
	extern	long air_money[MAXNOC];
	register struct plnstr *pp;
	register struct plchrstr *plp;
	struct	natstr *np;
	int	n;
	struct	shpstr *shp;
	struct	mchrstr *mp;
	struct	plchrstr *desc;
	struct  sctstr *sp;
	int	delta;
	int	mult;
	int	eff;
	int	avail;
	int	w_p_eff;
	int	left;
	int	used;
	int     start_money;

	for (n=0; pp = getplanep(n); n++) {
		if (pp->pln_own == 0)
			continue;
		if (pp->pln_effic < 10) {
			pp->pln_own = 0;
			continue;
		}
		shp = 0;
		plp = &plchr[pp->pln_type];
		if (pp->pln_ship >= 0) {
			shp = getshipp(pp->pln_ship);
			if (shp == 0 || shp->shp_own != pp->pln_own) {
				if (--shp->shp_nplane < 0)
					shp->shp_nplane = 0;
				pp->pln_own = 0;
				continue;
			}
			mp = &mchr[shp->shp_type];
			if ((plp->pl_flags & P_M) && !(mp->m_flags & M_MSL)) {
				if (--shp->shp_nplane < 0)
					shp->shp_nplane = 0;
				pp->pln_own = 0;
				continue;
			}
			if (!(plp->pl_flags & P_M) && !(mp->m_flags & M_FLY)) {
				if (--shp->shp_nplane < 0)
					shp->shp_nplane = 0;
				pp->pln_own = 0;
				continue;
			}
		}
#ifdef	ORBIT
		if ((plp->pl_flags & P_O) && (pp->pln_flags & PLN_LAUNCHED) &&
		    !(plp->pl_flags & P_M) &&
		    !(pp->pln_flags & PLN_SYNCHRONOUS))
			move_sat(pp);
#endif	ORBIT
		/* flight pay is 5x the pay received by other military */
		np = getnatp(pp->pln_own);
		start_money = np->nat_money;
		np->nat_money += (int) (etus * (plp->pl_crew * money_mil * 5));
		desc = &plchr[pp->pln_type];
		if (money[pp->pln_own] < 0) {
			delta = random() % (etus/2);
			eff = pp->pln_effic - delta;
			if (eff < 0)
				eff = 0;
			pp->pln_effic = eff;
			if (pp->pln_effic < 10) {
				wu(0, pp->pln_own,
				    fmt("%s #%d lost to lack of maintenance\n",
				    desc->pl_name, n));
				pp->pln_own = 0;
			}
			air_money[pp->pln_own] += np->nat_money - start_money;
			continue;
		}
		sp = getsectp(pp->pln_x, pp->pln_y);
		mult = 1;
		if (np->nat_level[NAT_TLEV] < pp->pln_tech * 0.85)
			mult = 2;
		np->nat_money += (int) (mult * etus *
			dmin(-1.0, desc->pl_cost * money_plane));
		air_money[pp->pln_own] += np->nat_money - start_money;
		start_money = np->nat_money;
		if ((pp->pln_flags & PLN_LAUNCHED) == PLN_LAUNCHED)
			continue;
		left = 100 - pp->pln_effic;
		if (left <= 0)
			continue;
		avail = sp->sct_avail * 100;
		w_p_eff = 20 + (desc->pl_lcm + 2 * desc->pl_hcm);
		delta = roundavg((double)avail/w_p_eff);
		if (delta <= 0)
			continue;
		if (delta > etus)
			delta = etus;
		if (delta > left)
			delta = left;
		used = delta * w_p_eff;
		/*
		 * I didn't use roundavg here, because I want to penalize
		 * the player with a large number of planes.
		 */
		avail = (sp->sct_avail * 100 - used) / 100;
		if (avail < 0)
			avail = 0;
		sp->sct_avail = avail;
		if (sp->sct_type != SCT_AIRPT)
			delta /= 3;
		np->nat_money -= roundavg(mult * delta * desc->pl_cost / 100.0);
		air_money[pp->pln_own] += np->nat_money - start_money;
		pp->pln_effic += delta;
	}
}
