#ifndef lint
static char *RCSid = "$Header: offe.c,v 1.13 89/12/06 20:08:42 mr-frog Exp $";
#endif /* not lint */

/*
 * offe.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "loan.h"
#include "treaty.h"
#include "file.h"

extern char *argp[];
static int do_treaty();
static int do_loan();

int
offe()
{
	register char *cp;

	cp = getstarg(argp[1], "loan or treaty? ");
	switch (*cp) {
	case 'l':
		return do_loan();

	case 't':
		return do_treaty();

	default:
		pr("You must specify \"loan\" or \"treaty\".\n");
		return RET_SYN;
	}
}

static int 
do_treaty()
{
	register char *cp;
	register int ourcond;
	register int theircond;
	register int j;
	struct	tchrstr *tcp;
	struct	trtstr trty;
	struct	nstr_item nstr;
	natid	recipient;
	long    now;
	int	n;
#ifdef	REJECTS
	struct	natstr *natp;
#endif	REJECTS

	if ((n = natarg(argp[2], "Treaty offered to? ")) < 0)
		return RET_SYN;
	recipient = n;
	if (recipient == cnum) {
		pr("You can't sign a treaty with yourself!\n");
		return RET_FAIL;
	}
#ifdef	REJECTS
	natp = getnatp(recipient);
	if (cnum && (getrejects(cnum,natp) & REJ_TREA)) {
		pr(fmt("%s is rejecting your treaties.\n",
			cname(recipient)));
		return RET_SYN;
	}
#endif	REJECTS
	pr(fmt("Terms for %s:\n", cname(recipient)));
	theircond = 0;
	for (tcp = tchr; tcp && tcp->t_cond; tcp++) {
		cp = getstring(fmt("%s? ", tcp->t_name));
		if (cp == 0)
		    return RET_FAIL;
		if (*cp == 'y')
			theircond |= tcp->t_cond;
	}
	pr("Terms for you:\n");
	ourcond = 0;
	for (tcp = tchr; tcp && tcp->t_cond; tcp++) {
		cp = getstring(fmt("%s? ", tcp->t_name));
		if (cp == 0)
		    return RET_FAIL;
		if (*cp == 'y')
			ourcond |= tcp->t_cond;
	}
	if (ourcond == 0 && theircond == 0) {
		pr("Treaties with no clauses aren't very useful, boss!\n");
		return RET_SYN;
	}
	cp = getstring("Proposed treaty duration? (days) ");
	if (cp == 0)
		return RET_FAIL;
	j = atopi(cp);
	if (j == 0) {
		pr("Bad treaty duration.\n");
		return RET_SYN;
	}
	(void) time(&now);
	if (!ef_lock(EF_TREATY)) {
		pr("Couldn't lock treaty file; get help.\n");
		return RET_SYS;
	}
	snxtitem_all(&nstr,EF_TREATY);
	while (nxtitem(&nstr, (char *)&trty)) {
		if (trty.trt_status == TS_FREE) {
			break;
		}
	}
	trty.trt_acond = ourcond;
	trty.trt_bcond = theircond;
	trty.trt_status = TS_PROPOSED;
	trty.trt_cna = cnum;
	trty.trt_cnb = recipient;
	trty.trt_exp = j * SECS_PER_DAY + now;
	if (!puttre(nstr.cur,&trty)) {
		pr("Couldn't save treaty; get help.\n");
		(void) ef_unlock(EF_TREATY);
		return RET_SYS;
	}
	(void) ef_unlock(EF_TREATY);
	wu(0, recipient, fmt("Treaty #%d proposed to you by %s",
		nstr.cur, cname(cnum)));
	pr(fmt("You have proposed treaty #%d\n", nstr.cur));
	return RET_OK;
}

static int 
do_loan()
{
	register int amt, irate, dur, maxloan;
	struct nstr_item nstr;
	struct natstr *natp;
	struct lonstr loan;
	natid	recipient;
	int	n;

	if ((n = natarg(argp[2], "Lend to? ")) < 0)
		return RET_SYN;
	recipient = n;
	if (recipient == cnum) {
		pr("You can't loan yourself money!\n");
		return RET_FAIL;
	}
	natp = getnatp(cnum);
	if (natp->nat_money + 100 > MAXLOAN)
		maxloan = MAXLOAN;
	else
		maxloan = natp->nat_money - 100;
	if (maxloan < 0) {
		pr("You don't have enough money to loan!\n");
		return RET_FAIL;
	}
	amt = onearg(argp[3],
		   fmt("Size of loan for country #%d? (max %d) ",
		       recipient, maxloan));
	if (amt <= 0)
		return RET_FAIL;
	if (amt > maxloan) {
		pr("You can't afford that much.\n");
		return RET_FAIL;
	}
	dur = onearg(argp[4], "Duration? (days, max 127) ");
	if (dur <= 0)
		return RET_FAIL;
	irate = onearg(argp[5], "Interest rate? (max 127%) ");
	if (irate <= 0)
		return RET_FAIL;
	if (!ef_lock(EF_LOAN)) {
		pr("Couldn't lock loan file; get help!\n");
		return RET_SYS;
	}
	snxtitem_all(&nstr, EF_LOAN);
	while (nxtitem(&nstr, (char *) &loan)) {
		if ((loan.l_status == LS_SIGNED) && (loan.l_lonee == cnum) &&
						(loan.l_loner == recipient)) {
			pr("You already owe HIM money - how about repaying your loan?\n");
			(void) ef_unlock(EF_LOAN);
			return RET_FAIL;
		}
	}
	snxtitem_all(&nstr, EF_LOAN);
	while (nxtitem(&nstr, (char *) &loan)) {
		if (loan.l_status == LS_FREE)
			break;
	}
	loan.l_loner = cnum;
	loan.l_lonee = recipient;
	loan.l_status = LS_PROPOSED;
	loan.l_irate = min(irate, 127);
	loan.l_ldur = min(dur, 127);
	loan.l_amtpaid = 0;
	loan.l_amtdue = amt;
	(void) time(&loan.l_lastpay);
	loan.l_duedate = loan.l_ldur * SECS_PER_DAY + loan.l_lastpay;
	if (!putloan(nstr.cur, &loan)) {
		pr("Couldn't save loan; get help!\n");
		(void) ef_unlock(EF_LOAN);
		return RET_SYS;
	}
	(void) ef_unlock(EF_LOAN);
	pr(fmt("You have offered loan %d\n", nstr.cur));
	wu(0, recipient, fmt("Country #%d has offered you a loan (#%d)",
		cnum, nstr.cur));
	return RET_OK;
}
