#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/cuto.c,v 1.6 89/06/18 15:50:18 mr-frog Exp $";
#endif /* not lint */

/*
 * cuto.c
 *
 * do a delivery cutoff level report
 *
 * David Muir Sharnoff, 1987
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "deity.h"
#include "file.h"

cuto()
{
	extern	char *fmt();
	extern	char *argp[];
	struct	sctstr sect;
	extern  double mcost();
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	char	dirstr[12];
	int	del[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	(void) strcpy(dirstr, ".      $");
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			pr("DELIVERY CUTOFF LEVELS\n");
			if (god) 
				pr(fmt("own"));
			pr("  sect      ufsgpidbolhr   uw food  sh gun pet iron dust bar oil lcm hcm rad\n");
		}
		if (god)
			pr(fmt("%3d ", sect.sct_own));
		getvec(VT_DEL, del, (char *)&sect, EF_SECTOR);
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c ", dchr[sect.sct_type].d_mnem));
		pr(fmt("%c", dirstr[del[I_UW] & 0x7]));
		pr(fmt("%c", dirstr[del[I_FOOD] & 0x7]));
		pr(fmt("%c", dirstr[del[I_SHELL] & 0x7]));
		pr(fmt("%c", dirstr[del[I_GUN] & 0x7]));
		pr(fmt("%c", dirstr[del[I_PETROL] & 0x7]));
		pr(fmt("%c", dirstr[del[I_IRON] & 0x7]));
		pr(fmt("%c", dirstr[del[I_DUST] & 0x7]));
		pr(fmt("%c", dirstr[del[I_BAR] & 0x7]));
		pr(fmt("%c", dirstr[del[I_OIL] & 0x7]));
		pr(fmt("%c", dirstr[del[I_LCM] & 0x7]));
		pr(fmt("%c", dirstr[del[I_HCM] & 0x7]));
		pr(fmt("%c ", dirstr[del[I_RAD] & 0x7]));
		pr(fmt("%4d", del[I_UW] & ~0x7));
		pr(fmt("%5d", del[I_FOOD] & ~0x7));
		pr(fmt("%4d", del[I_SHELL] & ~0x7));
		pr(fmt("%4d", del[I_GUN] & ~0x7));
		pr(fmt("%4d", del[I_PETROL] & ~0x7));
		pr(fmt("%5d", del[I_IRON] & ~0x7));
		pr(fmt("%5d", del[I_DUST] & ~0x7));
		pr(fmt("%4d", del[I_BAR] & ~0x7));
		pr(fmt("%4d", del[I_OIL] & ~0x7));
		pr(fmt("%4d", del[I_LCM] & ~0x7));
		pr(fmt("%4d", del[I_HCM] & ~0x7));
		pr(fmt("%4d", del[I_RAD] & ~0x7));
		pr("\n");
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return RET_OK;
}
