.TH Concept "Empire Overview"
.s1
\*(bFA BRIEF HISTORY\*(nF
.br
This version of the game "Empire", known as BSD Empire,
is the most recent in a series of territorial
conquest, political/economic simulation  games initially inspired by
a board game of the same name played at Reed College (Portland, Oregon).
Originally, Empire was written on PDP/11 (with all of 64k i/d space)
by Peter Langston and others.
Then came the VAX/11 series computers, and virtual memory, and from
object code distributed by Langston in the mid 1980's was formed
the basis of the current BSD Empire game.
.s3
Dave Pare and Jim Reuter were responsible for turning Peter's VAX/11
object code distribution into tens of thousands of lines of semi-readable
C code, giving birth to the initial version entitled "UCSD Empire".
Various things were added, such as planes, missiles, periodic
updates, performance enhancements, and -- naturally -- new bugs.
.s3
This somewhat unstable game was sent northward to Berkeley, where
Dave Sharnoff whipped it into shape with the help of his ucsd-empire
mailing list.
With the source code fairly widely available, many bugs were
fixed, new features such as satellites were introduced, and
it became clear after a few years that the code had degenerated
into a hodgepodge of hacks.
.s3
A major restructuring effort took place during the summer of 1989,
by the members of the XCF, a foolish group of people that had plenty
of spare time to help Dave Pare perform the rewrite.
What you see now is the result of the restructuring effort;
an attempt was made to regularize the interface so all the commands
have the same "flavor", while also greatly improving the programmer
interface.
.s1
\*(bFTHE OBJECT OF THE GAME\*(nF
.br
Empire falls into the broad category of simulation games and
involves military, political, and economic factors.
Although no goal is explicitly stated, players
rapidly derive their own, ranging from the mundane desire to be the
biggest, mightiest country in the game and "conquer" all others to the
more refined goals of having the most efficient land use
possible or the lowest ratio of military to civilians while
still surviving, etcetera.
.s1
\*(bFWHY USE A COMPUTER?\*(nF
.br
The role of the computer in Empire is that of modeling the
physical/economic system.
Players interact through the computer rather than with the computer.
The game is played in a "real-time" environment;
players log on and allocate resources, attack neighbors,
send diplomatic communiques, etc. whenever it is convenient.
The program keeps track of these activities, maintaining a record
of time spent and arranging for time to accumulate when players are
not logged in to the game.
Accumulated time is expressed in "Bureaucratic Time Units" or "B.T.U.s".
.s1
\*(bFBTUs?\*(nF
.br
The purpose of the B.T.U. Concept is three-fold:
.br
I) Commands use up B.T.U.s.  This limits the number of commands
that any player can give in any particular time period.
Thus the fanatics can't overrun the players with less free time by
tenacity alone.
.br
II) The build up of B.T.U.s not being dependent on
being logged on at any particular time allows players to participate when
it is convenient rather than at some fixed time (as in the case of
monopoly, the stock market, etc).
.br
III) The B.T.U. arrangement helps compensate for the fact
that in concept, the governments of each country are always "playing"
although the player representing that country may only play periodically.
.s1
\*(bFGEOGRAPHY\*(nF
.br
The geography of the game
is embodied in a rectangular map partitioned into M\ x\ N sectors
(where M and N are powers of two, usually 64, 128, or 256)
that is approximately
50% sea, 45% habitable land and 5% uninhabitable mountains.
This "map" is generated by a program (the "creation") that
places volcanoes pseudo-randomly,
lets large meteors and small meteorites impact the surface,
strews gold deposits and oil deposits around,
covers the planet with water,
dries some of the water to form seas and land masses,
runs rivers from mountain peaks down to the seas,
allows sedimentation to create oil and fertility,
and uses simple tectonics to expose oil and ores,
etc.
.s1
\*(bFWHERE DO THE COUNTRIES COME FROM?\*(nF
.br
New countries may join the game at any time.
Upon entry into the
game a new country is given two adjacent sectors.
These sectors are initially designated "sanctuaries" and are inviolable.
(Each country uses its own coordinate system with sector 0,0 being the
current capital, a sanctuary initially.  The initial two
sectors are always numbered 0,0 and 2,0.)
The new nation may confine itself to these two sectors for any length
of time and thereby be safe from attack.
However, in order to build or expand, it is necessary to
leave the safety of the sanctuary.
The sectors of land that were sanctuaries can then be
redesignated as any of a multitude of other land-use types ranging from
weather stations to gold mines to munitions plants.
.s1
\*(bFFURTHER READING\*(nF
.br
For further information,
here are a few "info" command topics that are basic to the understanding
of the game:
.NF
bye      designate  map           spy       break
census   food       move          syntax    distribute
nation   info       sector-types  time      {commands}
.FI
\*(bFA FINAL NOTE\*(nF
.br
It should be remembered that Empire is merely an interesting pastime;
in the vernacular, "it's just a game".
There are many amusing stories of people who took the game too seriously;
one tells of a corporate Vice President who walked into
the computer room one Saturday and flipped the main circuit breaker
in order to stop an attack on his country; another tells of the Harvard
student who refused to go to bed until everyone logged out of Empire and
the other players who took turns staying up late...
.s1
At this point Peter Langston would suggest that the people who
act so nastily to you in the game aren't really such boors in real life,
and that the game doesn't necessarily reflect the true being underneath.
He is probably right.
Unfortunately, Empire is and always has been a game of manufacturing
military hardware.
Almost every product that can be produced in Empire has military application,
and the problem with producing military hardware is that once you have it,
it is so tempting to use it "just to see how it works".
.s3
So if you log in one morning to find out that your country has been
turned into a sea of question-marks, and your navy is resting on the
bottom, and your air-force is scrap metal or on the market under
someone else's flag, just remember that you hold the moral high ground
because you didn't spend all night playing some silly game!
.s3
See Also: bugs, commands
