#ifndef lint
static char *RCSid = "$Header: sona.c,v 1.10 89/09/26 20:03:02 mr-frog Exp $";
#endif

/*
 * sona.c
 *
 * sonar from a sub (or other sonar-equipped ship)
 *
 * Jim Griffith, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "file.h"
#include <fcntl.h>
#include <ctype.h>

sona()
{
	extern	char *argp[];
	register int i;
	struct	nstr_item ni;
	struct	shpstr ship;
	struct	shpstr *targ;
	struct	mchrstr *tmcp;
	int	range;
	int	pingrange;
	int	vrange;
	int	dist;
	char	*name;
	char	*p;

	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;

	/* ick */
	ef_close(EF_SHIP);
	ef_open(EF_SHIP, O_RDONLY, EFF_MEM);

	while (nxtitem(&ni, (char *)&ship)) {
		if (!owner)
			continue;
		tmcp = &mchr[ship.shp_type];
		if (!(tmcp->m_flags & M_SONAR))
			continue;
		range = (int) techfact(ship.shp_tech,
			(double) mchr[ship.shp_type].m_vrnge);
		for (i=0; targ = getshipp(i); i++) {
			if (targ->shp_own == cnum || targ->shp_own == 0)
				continue;
			tmcp = &mchr[targ->shp_type];
			pingrange = max(tmcp->m_visib, 10) * range / 10;
			vrange = pingrange * ship.shp_effic / 200;
			dist = mapdist(targ->shp_x, targ->shp_y,
				ship.shp_x, ship.shp_y);
			pingrange = (max(pingrange, 2) * targ->shp_effic)/100; 
			if (dist > pingrange)
				continue;
			if (tmcp->m_flags & M_SONAR) {
			    p = fmt("Sonar ping from %s detected by %s #%d!\n",
					xyas(ship.shp_x, ship.shp_y,
						targ->shp_own),
					tmcp->m_name, targ->shp_uid);
				wu(0, targ->shp_own, p);
			}
			if ((dist > vrange))
				continue;
			if ((tmcp->m_flags & M_FOOD) && dist > 0)
				name = "fishing vessel";
			else
				name = tmcp->m_name;
			pr(fmt("%s (#%d) %s #%d @%s\n", cname(targ->shp_own),
				targ->shp_own, name, i,
				xyas(targ->shp_x, targ->shp_y, cnum)));
		}
	}
	ef_close(EF_SHIP);
	ef_open(EF_SHIP, O_RDWR, 0);
	return RET_OK;
}
