#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/sell.c,v 1.6 89/09/10 19:22:40 mr-frog Exp $";
#endif

/*
 * sell.c
 *
 * engage in inter-nation trading of commodities.
 * Place commodities on-sale at the deity trading post.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "xy.h"
#include "file.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "nsc.h"
#include "nat.h"
#include "nuke.h"
#include "plane.h"
#include "ship.h"
#include "trade.h"

/*
 * format: sell <COMMODITY> <SECTS> <NUMBER> <PRICE>
 *   where NUMBER represents either the number to reach
 *   or, if negative, the abs number to try and get from
 *   each sector.
 */
sell()
{
	extern char *argp[];
	struct sctstr	sect;
	struct nstr_sect nstr;
	struct ichrstr	*ip;
	int     number_set;
	int     number_sub;
	int     product;
	int     totalcom;
	int     amt;
	int     com;
	char	*p;
	float   price;

	if ((ip = whatitem(argp[1], "Commodity to sell : ")) == 0)
		return RET_SYN;
	if (ip->i_sell == 0) {
		pr(fmt("You can't sell %s\n", ip->i_name));
		return RET_FAIL;
	}
	product = ip - ichr;
	if (!snxtsct(&nstr, argp[2]))
		return RET_SYN;
	number_set = 0;
	number_sub = 0;
	if ((p = getstarg(argp[3], "amount :  ")) == 0 || *p == 0)
		return RET_SYN;
	number_set = atoi(p);
	if (number_set < 0) {
		number_sub = -number_set;
		number_set = 0;
	}
	if ((p = getstarg(argp[4], "price : ")) == 0 || *p == 0)
		return RET_SYN;
	price = atof(p);
	if (price <= 0.0) {
		pr("No sale.\n");
		return RET_FAIL;
	}
	totalcom = 0;
	while (nxtsct(&nstr, &sect) > 0) {
		if (!owner)
			continue;
		/*
		 * military control necessary to sell
		 * goodies in occupied territory.
		 */
		if (sect.sct_oldown != cnum) {
			if (getvar(V_MILIT, (char *)&sect, EF_SECTOR) * 10
				< getvar(V_CIVIL, (char *)&sect, EF_SECTOR))
				continue;
		}
		if (((amt = getvar(ip->i_vtype, (char *)&sect,EF_SECTOR))) == 0)
			continue;
		if (number_sub)
			com = min(number_sub, amt);
		else
			com = amt - number_set;
		if (com <= 0)
			continue;
		totalcom += com;
		amt -= com;
		pr(fmt("Sold %d %s at %s (%d left)\n", com, ip->i_name,
		       xyas(sect.sct_x, sect.sct_y, cnum), amt));
		putvar(ip->i_vtype, amt, (char *)&sect, EF_SECTOR);
		putsect(&sect);
	}
	if (totalcom > 0) {
		dolcost += (double) (totalcom * ip->i_lbs / 10);
		if (!commlock()) {
			pr("Unable to lock commodity file; get help!\n");
			return RET_SYS;
		}
		if (commread() < 0) {
			(void) communlock();
			pr("Unable to read commodity file; get help!\n");
			return RET_SYS;
		}
		commset(cnum, product, totalcom);
		commprice(product, &price);
		if (commwrite() < 0) {
			(void) communlock();
			pr("Unable to write commodity file; get help!\n");
			return RET_SYS;
		}
		(void) communlock();
		pr(fmt("Total %s put on the market : %d\n", ip->i_name,
		       totalcom));
		pr(fmt("item unit cost : %8.2f\n", price));
		return RET_OK;
	}
	else {
		pr(fmt("No eligible %s for sale\n", ip->i_name));
		return RET_FAIL;
	}
}
