#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/fina.c,v 1.9 89/09/10 19:51:42 mr-frog Exp $";
#endif /* not lint */

/*
 * fina.c
 *
 * Financial report on current status of loans to countries.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "loan.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"

/*
 * format: fina
 */
fina()
{
	struct	lonstr loan;
	struct	nstr_item ni;
	long	now;
	int	rdur;
	int	xdur;
	double	rate;
	double	amt;
	int	due;
	int	last;

	(void)time(&now);
	pr("\n");
	pr("             -= Empire Financial Status Report =- \n");
	pr("                  ");
	prdate();
	pr(
	fmt("Loan       From            To        Rate   Dur     Paid    Total\n"));

	snxtitem(&ni, EF_LOAN, "*");
	while (nxtitem(&ni, (char *)&loan)) {
		if (loan.l_status != LS_SIGNED)
			continue;
		due = loan.l_duedate;
		last = loan.l_lastpay;
		rdur = 0;
		xdur = 0;
		if (now < due) {
			rdur = now - last;
			xdur = 0;
		}
		if (last < due && due < now) {
			rdur = due - last;
			xdur = now - due;
		}
		if (due < last) {
			rdur = 0;
			xdur = now - last;
		}
		if (loan.l_ldur == 0) {
			logerror("loan #%d has zero duration", ni.cur);
			continue;
		}
		rate = loan.l_irate / (loan.l_ldur * 8640000.0);
		amt = (rdur * rate + xdur * rate * 2.0 + 1.0) * loan.l_amtdue;
		pr(fmt(" %-2d  (%3d) %-8.8s  (%3d) %-8.8s  ", ni.cur,
		       loan.l_loner, cname(loan.l_loner),
		       loan.l_lonee, cname(loan.l_lonee)));
		pr(fmt("%3d%%   %3d    %5d    %5d",
		       loan.l_irate, loan.l_ldur, loan.l_amtpaid, (int) amt));
		if (now > loan.l_duedate)
			pr(" (in arrears)\n");
		else
			pr("\n");
	}
	pr("\n");
	return RET_OK;
}
