#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/gen/RCS/chance.c,v 1.2 89/05/29 01:50:52 emp-src Exp $";
#endif

/*
 * chance.c
 *
 * return 1 if "roll" is under the chance
 *
 * from PSL Empire, 1985
 */

int
chance(d)
	double	d;
{
	double	roll;

	roll = (random() & 0x7fff);
	if (d >= roll/32768.0)
		return 1;
	return 0;
}

int
roll(n)
	int	n;
{
	return (random() % n) + 1;
}

/*
 * round value to nearest int (on the average). E.g. rounds up
 * with a chance proportional to the size of the fractional part.
 */
int
roundavg(val)
	double	val;
{
	int	flr;

	flr = (int) val;
	if (val < 0)
		flr -= chance(flr - val);
	else
		flr += chance(val - flr);
	return flr;
}

#ifdef hpux
srandom(n)
	long	n;
{
	srand(n);
}

long
random()
{
	extern	long rand();

	return (rand() >> 8);
}
#endif
