#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/tm/RCS/delaywrite.c,v 1.2 89/09/18 00:15:08 mr-frog Exp $";
#endif

/*
 * delaywrite.c
 *
 * perform delayed writes
 *
 */

#include "misc.h"
#include "file.h"

#define DWSIZE			10
#define	DWHASH(type, record)	((type + record) % DWSIZE)

struct dw {
	int type;
	int record;
	struct dw *next;
};

struct dw *dwhash[DWSIZE];

dw_queue(type, record)
	int	type;
	int	record;
{
	struct	dw *dwp;

	for (dwp = dwhash[DWHASH(type, record)]; dwp != 0; dwp = dwp->next)
		if (dwp->type == type && dwp->record == record)
			return;
	dwp = (struct dw *) malloc(sizeof(*dwp));
	dwp->type = type;
	dwp->record = record;
	dwp->next = dwhash[DWHASH(type, record)];
	dwhash[DWHASH(type, record)] = dwp;
}

dw_flush()
{
	register struct dw *dwp;
	register struct dw *next;
	register int i;
	char	*ptr;

	for (i=0; i<DWSIZE; i++) {
		for (dwp = dwhash[i]; dwp != 0; dwp = next) {
			next = dwp->next;
			ptr = ef_ptr(dwp->type, dwp->record);
			ef_nbwrite(dwp->type, dwp->record, ptr);
			free(dwp);
		}
		dwhash[i] = 0;
	}
}
