#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/map.c,v 1.15 89/09/02 02:36:19 mr-frog Exp $";
#endif /* not lint */

/*
 * map.c
 *
 * empire map: probably the most-used command in empire.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "deity.h"
#include "nat.h"
#include "map.h"

map()
{
	extern	int aborted;
	extern	char *argp[];
	register char *ptr;
	struct	nstr_sect ns;
	struct	natstr *np;
	struct	sctstr sect;
	struct	range range;
	int	i;
	u_char	bitmap[WORLD_X*WORLD_Y/8];
	char	wmap[WORLD_Y][MAPWIDTH(1)];
	coord	y;

	if (!snxtsct(&ns, argp[1]))
		return RET_FAIL;
	np = getnatp(cnum);
	if (!god) {
		bzero((char *)bitmap, sizeof(bitmap));
		bitinit(&ns, bitmap);
	}
	/* zap any conditionals */
	ns.ncond = 0;
	xyrelrange(np, &ns.range, &range);
	border(&range, "     ", "");
	blankfill((char *)wmap, &ns.range, 1);
	while (nxtsct(&ns, &sect) && !aborted) {
		if (!god && !getbit(ns.x, ns.y, bitmap))
			continue;
		ptr = &wmap[ns.dy][ns.dx];
		if (sect.sct_type > SCT_MAXDEF)
			*ptr = '?';
		else {
			*ptr = dchr[sect.sct_type].d_mnem;
			switch (sect.sct_type) {
			case SCT_WATER:
			case SCT_RURAL:
			case SCT_MOUNT:
			case SCT_WASTE:
				break;
			default:
				if (sect.sct_own != cnum && !god)
					*ptr = '?';
				break;
			}
		}
	}
	if (aborted)
		return RET_OK;
	for (y=ns.range.ly, i=0; i < ns.range.height; y++, i++) {
		int yval;

		yval = yrel(np, y);
		pr(fmt("%4d %s %-4d\n", yval, wmap[i], yval));
		if (y >= WORLD_Y)
			y -= WORLD_Y;
	}
	border(&range, "     ", "");
	return RET_OK;
}
