#ifndef lint
static char *RCSid = "$Header: edit.c,v 1.53 90/03/19 11:00:39 mr-frog Exp $";
#endif /* not lint */

/*
 * edit.c
 *
 * David Muir Sharnoff
 *
 * This command NEEDS TO BE REDONE.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"
#include "file.h"
#include "plane.h"
#include "ship.h"

#define END -1
static	prnat();
static	prplane();
static	prship();
static	prsect();
static	noise();
static	benefit();


/*
 * format: give c <amt> <commod> <sect>
 */
edit()
{
	extern	char *argp[];
	extern	int shp_maxno;
	extern	int m_m_p_d;
	struct	sctstr sect;
	struct	plnstr plane;
	struct	shpstr ship;
	char	*what;
	char	*ptr;
	char	*thing;
	int	num;
	int	arg;
	int	err;
	coord	x, y;
	float	farg;
	natid	nat;
	struct	natstr	*np;

	if ((what = getstarg(argp[1],
		"Edit What (country, land, ship, plane, nuke)? ")) == 0) 
		return RET_SYN;
	switch (what[0]) {
	case 'l':
		if (!(ptr = getstarg(argp[2], "Sector : ")))
			return RET_FAIL;
		if (!sarg_xy(ptr, &x, &y))
			return RET_FAIL;
		if (!getsect(x, y, &sect))
			return RET_FAIL;
		break;
	case 'c':
		if ((num = natarg(argp[2], "Country number? ")) < 0)
			return RET_SYN;
		nat = (natid) num;
		np = getnatp(nat);
		break;
	case 'p':
		if ((num = onearg(argp[2], "Plane number? ")) < 0)
			return RET_SYN;
		if (!getplane(num, &plane))
			return RET_SYN;
		break;
	case 's':
		if ((num = onearg(argp[2], "Ship number? ")) < 0)
			return RET_SYN;
		if (!getship(num, &ship))
			return RET_SYN;
		break;
	case 'n':
		pr("Not implemented yet.\n");
		break;
	default:
		pr("huh?\n");
		return RET_SYN;
	}
	if (argp[3] == 0) {
		switch (what[0]) {
		case 'l':
			prsect(&sect);
			break;
		case 'c':
			prnat(nat);
			break;
		case 'p':
			prplane(&plane);
			break;
		case 's':
			prship(&ship);
			break;
		}
	} else if (argp[4] != 0)
		(void) strcat (argp[3], argp[4]);
	if (!(ptr = getstarg(argp[3], "%c xxxxx -- thing value : "))) {
		return RET_SYN;
	}
	for (;;) {
		if ((err = getin(&thing, &ptr, &arg)) != RET_OK) {
			if (err == END) {
				switch (what[0]) {
				case 'c':
					prnat(nat);
					break;
				case 'l':
					prsect(&sect);
					break;
				case 's':
					prship(&ship);
					break;
				case 'p':
					prplane(&plane);
					break;
				}
				break;
			} else
				return err;
		}
		switch (what[0]) {
		case 'c':
			farg = atof(ptr);
			if ((err = docountry(thing[0], arg, ptr, farg, nat, np))
								    != RET_OK)
				return err;
			break;
		case 'l':
			if ((err = doland(thing[0], arg, &sect)) != RET_OK)
				return err;
			if (!putsect(&sect))
				return RET_FAIL;
			break;
		case 's':
			if ((err = doship(thing[0], arg, ptr, &ship)) != RET_OK)
				return err;
			if (!putship(ship.shp_uid, &ship))
				return RET_FAIL;
			break;
		case 'p':
			if ((err = doplane(thing[0], arg, ptr, &plane))
								    != RET_OK)
				return err;
			if (!putplane(plane.pln_uid, &plane))
				return RET_FAIL;
			break;
		}
		if (err != RET_OK)
			break;
		else
			ptr = 0;
	}
	return RET_OK;
}

static
benefit(who, good) 
	natid	who;
	int	good;
{
	if (good) {
		if (who)
			nreport(cnum, N_AIDS, who, 1);
	} else {
		if (who)
			nreport(cnum, N_HURTS, who, 1);
	}
}

static
noise(sptr, public_amt, name, old, new)
	struct	sctstr *sptr;
	int	public_amt;
	char	*name;
	int	old, new;
{
	char p[100];

	pr(fmt("%s of %s changed from %d to %d%\n",
		name, xyas(sptr->sct_x, sptr->sct_y, cnum), old, new));
	if (public_amt) 
		(void) strcpy(p, fmt("changed from %d to %d", old, new));
	else
		(void) strcpy(p, fmt("%s", old<new ? "increased":"decreased"));
	if (sptr->sct_own)
		wu(0, sptr->sct_own,
			fmt("%s in %s was %s by an act of %s\n",
			    name, xyas(sptr->sct_x, sptr->sct_y, sptr->sct_own),
			    p, cname(cnum)));
	benefit(sptr->sct_own, (old < new));
}

static
prsect(sect) 
	struct	sctstr *sect;
{
	pr("  sect       own  oo eff mob min gld frt oil urn wrk lty  che plg ptime avail\n");
	pr("things:        o   O   e   m   i   g   f   c   u   w   l    x   p     t     a\n");
	pr(xyfmt("%4d,%-4d", sect->sct_x, sect->sct_y, cnum));
	pr(fmt(" %c%c %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %4d %3d %5d %5d\n",
		dchr[sect->sct_type].d_mnem,
		(sect->sct_newtype == sect->sct_type) ? ' ' :
			 dchr[sect->sct_newtype].d_mnem,
		sect->sct_own, sect->sct_oldown,
		sect->sct_effic, sect->sct_mobil,
		sect->sct_min, sect->sct_gmin,
		sect->sct_fertil, sect->sct_oil, sect->sct_uran,
		sect->sct_work, sect->sct_loyal,
		getvar(V_CHE, (char *)sect, EF_SECTOR),
		getvar(V_PSTAGE, (char *)sect, EF_SECTOR),
		getvar(V_PTIME, (char *)sect, EF_SECTOR),
		sect->sct_avail));
}


static
prnat(n) 
	natid	n;
{
	struct natstr *np;

	if ((np = getnatp(n)) == 0)
		return;
	pr(fmt("Country #: %2d\n", n));
	pr(fmt("Name <n>: %-20s\t", np->nat_cnam)); 
	pr(fmt("Representative <r>: %-20s\n", np->nat_pnam));
	pr(fmt("BTUs <b>: %3d\t\t\t", np->nat_btu));
	pr(fmt("Reserves <m>: %5d\n", np->nat_reserve));
	pr(fmt("Capital <c>: %s\t\t", xyas(np->nat_xcap, np->nat_ycap, cnum)));
	pr(fmt("Origin <o>: %3s\n", xyas(np->nat_xorg, np->nat_yorg, cnum)));
	pr(fmt("Status <s>: 0x%x\t\t\t", np->nat_stat));
	pr(fmt("Min Used <u>: %3d\n", np->nat_minused));
	pr(fmt("Technology <T>: %.2f\t\t", np->nat_level[NAT_TLEV]));
	pr(fmt("Research <R>: %.2f\n", np->nat_level[NAT_RLEV]));
	pr(fmt("Education <E>: %.2f\t\t", np->nat_level[NAT_ELEV]));
	pr(fmt("Happiness <H>: %.2f\n", np->nat_level[NAT_HLEV]));
	pr(fmt("Money <M>: $%6d\n", np->nat_money));
}

static
prplane(plane)
	struct plnstr *plane;
{
	pr(fmt("Owner <o>: %d\t\t", (int)plane->pln_own));
	pr(fmt("Location <l>: %s\n", xyas(plane->pln_x, plane->pln_y, cnum)));
	pr(fmt("Efficiency <e>: %d\t", (int)plane->pln_effic));
	pr(fmt("Mobility <m>: %d\n", (int)plane->pln_mobil));
	pr(fmt("Tech <t>: %d\t\t", plane->pln_tech));
	pr(fmt("Wing <w>: %c\n", plane->pln_wing));
	pr(fmt("Attack <a>: %d\t\t", plane->pln_att));
	pr(fmt("Defense <d>: %d\n", plane->pln_def));
	pr(fmt("Range <r>: %d\n", plane->pln_range));
	pr(fmt("Ship <s>: %d\n", plane->pln_ship));
}

static
prship(ship)
	struct shpstr *ship;
{
	int	vec[I_MAX+1];
	struct natstr *natp;

	if ((natp = getnatp(ship->shp_own)) == 0)
		return;
	pr(fmt("%s (#%d) %s #%d\n", natp->nat_cnam, (int)ship->shp_own,
				mchr[ship->shp_type].m_name, ship->shp_uid));
	pr(fmt("Owner <O>: %d\t\t\t", (int)ship->shp_own));
	pr(fmt("Location <L>: %s\n", xyas(ship->shp_x, ship->shp_y, cnum)));
	pr(fmt("Tech <T>: %d\t\t\t", ship->shp_tech));
	pr(fmt("Efficiency <E>: %d\n", (int)ship->shp_effic));
	pr(fmt("Mobility <M>: %d\t\t", (int)ship->shp_mobil));
	pr(fmt("Fleet <F>: %c\n", ship->shp_fleet));
	pr(fmt("Planes <P>: %d\n", (int)ship->shp_nplane));
	getvec(VT_ITEM, vec, (char *)ship, EF_SHIP);
	pr("civ mil  uw food shl gun  pet  irn  dst  oil  lcm  hcm rad\n");
	pr("  c   m   u    f   s   g    p    i    d    o    l    h   r\n");
	pr(fmt("%3d", vec[I_CIVIL]));
	pr(fmt("%4d", vec[I_MILIT]));
	pr(fmt("%4d", vec[I_UW]));
	pr(fmt("%5d", vec[I_FOOD]));
	pr(fmt("%4d", vec[I_SHELL]));
	pr(fmt("%4d", vec[I_GUN]));
	pr(fmt("%5d", vec[I_PETROL]));
	pr(fmt("%5d", vec[I_IRON]));
	pr(fmt("%5d", vec[I_DUST]));
	pr(fmt("%5d", vec[I_OIL]));
	pr(fmt("%5d", vec[I_LCM]));
	pr(fmt("%5d", vec[I_HCM]));
	pr(fmt("%4d", vec[I_RAD]));
	pr("\n");
}

errcheck(num, max)
	int	num, max;
{
	if (num < 0)
		return(0);
	else if (num > max)
		return(max);
	return (num);
}

getin(what, p, arg)
	char	**what, **p;
	int	*arg;
{
	if (!(*what = getstarg(*p, "%c xxxxx -- thing value : "))) {
		return RET_SYN;
	}
	if (**what == '\0')
		return END;
	while(isspace(**what))
		++what;
	*p = *what + 1;
	while(isspace(**p))
		++(*p);
	*arg = atoi(*p);
	if (*arg < 0)
		*arg = 0;
	return RET_OK;
}


doland(op, arg, sect)
	char	op;
	int	arg;
	struct	sctstr *sect;
{
	natid	newown, oldown;
	int	new, old;
	switch (op) {
	case 'o':
		if (arg < 0)
			return RET_SYN;
		newown = (natid) errcheck(arg, MAXNOC-1);
		pr(fmt("Owner of %s changed from %s (#%d) to %s (#%d).\n",
			xyas(sect->sct_x, sect->sct_y, cnum),
			cname(sect->sct_own),
			sect->sct_own, cname(newown), newown));
		if (sect->sct_own) {
			wu(0, sect->sct_own, 
			fmt("Sector %s lost to deity intervention", 
			xyas(sect->sct_x, sect->sct_y, sect->sct_own)));
		}
		benefit(sect->sct_own, 0);
		sect->sct_own = newown;
		if (newown) {
			wu(0, newown,
			fmt("Sector %s gained from deity intervention",
			xyas(sect->sct_x, sect->sct_y, sect->sct_own)));
		}
		benefit(newown, 1);
		break;
	case 'O':
		if (arg < 0)
			return RET_SYN;
		oldown = (natid) errcheck(arg, MAXNOC-1);
		pr(fmt("Old owner of %s changed from %s (#%d) to %s (#%d).\n",
			xyas(sect->sct_x, sect->sct_y, cnum),
			cname(sect->sct_oldown),
			sect->sct_oldown, cname(oldown), oldown));
		sect->sct_oldown = oldown;
		break;
	case 'e':
		new = errcheck(arg, 100);
		noise(sect, 1, "Efficiency", (int) sect->sct_effic, new);
		sect->sct_effic = (u_char) new;
		break;
	case 'm':
		new = errcheck(arg, 127);
		noise(sect, 1, "Mobility", (int) sect->sct_mobil, new);
		sect->sct_mobil = (u_char) new;
		break;
	case 'i':
		new = errcheck(arg, 100);
		noise(sect, 1, "Iron ore content", (int) sect->sct_min, new);
		sect->sct_min = (u_char) new;
		break;
	case 'g':
		new = errcheck(arg, 100);
		noise(sect, 1, "Gold content", (int) sect->sct_gmin, new);
		sect->sct_gmin = (u_char) new;
		break;
	case 'f':
		new = errcheck(arg, 120);
		noise(sect, 1, "Fertility", (int) sect->sct_fertil, new);
		sect->sct_fertil = (u_char) new;
		break;
	case 'c':
		new = errcheck(arg, 100);
		noise(sect, 1, "Oil content", (int) sect->sct_oil, new);
		sect->sct_oil = (u_char) new;
		break;
	case 'u':
		new = errcheck(arg, 100);
		noise(sect, 1, "Uranium content", (int) sect->sct_uran, new);
		sect->sct_uran = (u_char) new;
		break;
	case 'w':
		new = errcheck(arg, 100);
		noise(sect, 1, "Workforce percentage",
			(int) sect->sct_work, new);
		sect->sct_work = (u_char) new;
		break;
	case 'l':
		new = errcheck(arg, 100);
		pr(fmt("Loyalty of %s changed from %d to %d%%\n",
			xyas(sect->sct_x, sect->sct_y, cnum),
			sect->sct_loyal, new));
		sect->sct_loyal = (u_char) new;
		break;
	case 'x':
		old = getvar(V_CHE, (char *)sect, EF_SECTOR);
		new = errcheck(arg, 65536);
		pr(fmt("Guerillas in %s changed from %d to %d%\n",
			xyas(sect->sct_x, sect->sct_y, cnum), old, new));
		putvar(V_CHE, new, (char *)sect, EF_SECTOR);
		break;
	case 'p':
		old = getvar(V_PSTAGE, (char *)sect, EF_SECTOR);
		new = errcheck(arg, PLG_EXPOSED);
		pr(fmt("Plague stage of %s changed from %d to %d%\n",
			xyas(sect->sct_x, sect->sct_y, cnum), old, new));
		putvar(V_PSTAGE, new, (char *)sect, EF_SECTOR);
		break;
	case 't':
		old = getvar(V_PTIME, (char *)sect, EF_SECTOR);
		new = errcheck(arg, 64);
		pr(fmt("Plague time of %s changed from %d to %d%\n",
			xyas(sect->sct_x, sect->sct_y, cnum), old, new));
		putvar(V_PTIME, new, (char *)sect, EF_SECTOR);
		break;
	case 'a':
		new = errcheck(arg, 999);
		noise(sect, 1, "Available workforce", (int) sect->sct_avail,
			new);
		sect->sct_avail = new;
		break;
	default:
		pr(fmt("huh? (%c)\n",op));
		return RET_SYN;
	}
	return RET_OK;
}



docountry(op, arg, p, farg, nat, np)
	char	op;
	int	arg;
	char	*p;
	float	farg;
	natid	nat;
	struct	natstr *np;
{
	coord	newx, newy;
	switch (op) {
	case 'n':
		pr(fmt("Country name changed from %s to %s\n",
							np->nat_cnam, p));
		NAT_SET(nat_cnam[0], nat, p);
		break;
	case 'r':
		pr(fmt("Country representative changed from %s to %s\n",
							np->nat_pnam, p));
		NAT_SET(nat_pnam[0], nat, p);
		break;
	case 'b':
		arg = errcheck(arg, 255);
		pr(fmt("BTU's changed from %d to %d\n", np->nat_btu, arg));
		NAT_SET(nat_btu, nat, arg);
		break;
	case 'm':
		benefit(nat, np->nat_reserve < arg);
		pr(fmt("Military Reserves changed from %d to %d\n",
			np->nat_reserve, arg));
		if (np->nat_stat == STAT_NORM)
			wu(0, nat,
			    fmt("Military Reserves changed from %d to %d by divine intervention.\n", 
			    np->nat_reserve, arg));
		NAT_SET(nat_reserve, nat, arg);
		break;
	case 'c':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		pr(fmt("Capitol coordinates changed from %s to %s\n",
			xyas(np->nat_xcap, np->nat_ycap, cnum),
			xyas(newx, newy, cnum)));
		NAT_SET(nat_xcap, nat, newx);
		NAT_SET(nat_ycap, nat, newy);
		break;
	case 'o':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		pr(fmt("Origin coordinates changed from %s to %s\n",
			xyas(np->nat_xorg, np->nat_yorg, cnum),
			xyas(newx, newy, cnum)));
		NAT_SET(nat_xorg, nat, newx);
		NAT_SET(nat_yorg, nat, newy);
		break;
	case 's':
		NAT_SET(nat_stat, nat, (char)errcheck(arg, STAT_NEW));
		break;
	case 'u':
		arg = errcheck(arg, m_m_p_d);
		pr(fmt("Number of minutes used changed from %d to %d.\n",
			np->nat_minused, arg));
		NAT_SET(nat_minused, nat, arg);
		break;
	case 'M':
		pr(fmt("Money changed from %d to %d\n",np->nat_money, arg));
		wu(0, nat,
		    fmt("Money changed from %d to %d by divine intervention.\n",
			np->nat_money, arg));
		NAT_SET(nat_money, nat, arg);
		break;
	case 'T':
		pr(fmt("Tech changed from %.2f to %.2f.\n",
			np->nat_level[NAT_TLEV], farg));
		NAT_SETARY(nat_level[0], nat, NAT_TLEV, farg);
		break;
	case 'R':
		pr(fmt("Research changed from %.2f to %.2f.\n",
			np->nat_level[NAT_RLEV], farg));
		NAT_SETARY(nat_level[0], nat, NAT_RLEV, farg);
		break;
	case 'E':
		pr(fmt("Education changed from %.2f to %.2f.\n",
			np->nat_level[NAT_ELEV], farg));
		NAT_SETARY(nat_level[0], nat, NAT_ELEV, farg);
		break;
	case 'H':
		pr(fmt("Happiness changed from %.2f to %.2f.\n",
			np->nat_level[NAT_HLEV], farg));
		NAT_SETARY(nat_level[0], nat, NAT_HLEV, farg);
		break;
	default:
		pr(fmt("huh? (%c)\n",op));
		break;
	}
	return RET_OK;
}


doship(op, arg, p, ship)
	char	op;
	int	arg;
	char	*p;
	struct	shpstr *ship;
{
	coord	newx, newy;

	newx = newy = 0;
	switch (op) {
	case 'O':
		if (ship->shp_own)
			wu(0, ship->shp_own,
				fmt("%s #%d taken from you by deity intervention!\n",
				mchr[ship->shp_type].m_name, ship->shp_uid));
		if (arg && arg < MAXNOC) {
			wu(0, (natid)arg,
			    fmt("%s #%d given to you by deity intervention!\n",
			    mchr[ship->shp_type].m_name, ship->shp_uid));
			ship->shp_own = (natid) arg;
		} else if (!arg) {
			ship->shp_effic = 0;
			ship->shp_own = (natid) 0;
		}
		break;
	case 'L':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		ship->shp_x = newx;
		ship->shp_y = newy;
		break;
	case 'T':
		ship->shp_tech = arg;
		break;
	case 'E':
		ship->shp_effic = errcheck(arg, 100);
		if (arg < 10) {
			ship->shp_effic = 0;
			ship->shp_own = (natid) 0;
		}
		break;
	case 'M':
		ship->shp_mobil = errcheck(arg, 64);
		break;
	case 'F':
		if (p[0] == '~')
			ship->shp_fleet = ' ';
		else if (isalpha(p[0]))
			ship->shp_fleet = p[0];
		else {
			pr(fmt("%c: invalid fleet\n",p[0]));
			return RET_FAIL;
		}
		break;
	case 'P':
		ship->shp_nplane = errcheck(arg, 100);
		break;
	case 'c':
		if (!putvar(V_CIVIL, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
			break;
	case 'm':
		if (!putvar(V_MILIT, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'u':
		if (!putvar(V_UW, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'f':
		if (!putvar(V_FOOD, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
				return RET_FAIL;
			}
			break;
	case 's':
		if (!putvar(V_SHELL, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'g':
		if (!putvar(V_GUN, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'p':
		if (!putvar(V_PETROL, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
				return RET_FAIL;
			}
			break;
	case 'i':
		if (!putvar(V_IRON, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'd':
		if (!putvar(V_DUST, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'o':
		if (!putvar(V_OIL, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'l':
		if (!putvar(V_LCM, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	case 'h':
		if (!putvar(V_HCM, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
				return RET_FAIL;
			}
			break;
	case 'r':
		if (!putvar(V_RAD, arg, (char *)ship, EF_SHIP)) {
			pr("No room on ship!\n");
			return RET_FAIL;
		}
		break;
	default:
		pr(fmt("huh? (%c)\n",op));
		return RET_FAIL;
	}
	return RET_OK;
}


doplane(op, arg, p, plane)
	char	op;
	int	arg;
	char	*p;
	struct	plnstr *plane;
{
	coord	newx, newy;

	switch (op) {
	case 'l':
		if (!sarg_xy(p, &newx, &newy))
			return RET_SYN;
		plane->pln_x = newx;
		plane->pln_y = newy;
		break;
	case 'o':
		if (plane->pln_own)
			wu(0, plane->pln_own,
				fmt("%s #%d taken from you by deity intervention!\n",
				plchr[plane->pln_type].pl_name, plane->pln_uid));
		if (arg && arg < MAXNOC) {
			plane->pln_own = (natid) arg;
			wu(0, plane->pln_own,
			    fmt("%s #%d given to you by deity intervention!\n",
			    plchr[plane->pln_type].pl_name, plane->pln_uid));
		} else if (!arg) {
			plane->pln_effic = 0;
			plane->pln_own = (natid) 0;
		}
		break;
	case 'e':
		plane->pln_effic = errcheck(arg, 100);
		if (arg < 10) {
			plane->pln_effic = 0;
			plane->pln_own = (natid) 0;
		}
		break;
	case 'm':
		plane->pln_mobil = errcheck(arg, 127);
		break;
	case 't':
		plane->pln_tech = arg;
		break;
	case 'w':
		if (p[0] == '~')
			plane->pln_wing = ' ';
		else if (isalpha(p[0]))
			plane->pln_wing = p[0];
		else {
			pr(fmt("%c: invalid wing\n",p[0]));
			return RET_FAIL;
		}
		break;
	case 'a':
		plane->pln_att = (char) errcheck(arg, 127);
		break;
	case 'd':
		plane->pln_def = (char) errcheck(arg, 127);
		break;
	case 'r':
		plane->pln_range = (u_char) arg;
		break;
	case 's':
		plane->pln_ship = errcheck(arg, 32767);
		break;
	default:
		pr(fmt("huh? (%c)\n",op));
		return RET_FAIL;
	}
	return RET_OK;
}
